/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ReplicaDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ReplicaCountThresholds;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplicaDistributionAbstractGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaDistributionAbstractGoal.class);
    protected boolean fixOfflineReplicasOnly;
    protected final Set<Integer> brokerIdsAboveBalanceUpperLimit = new HashSet<Integer>();
    protected final Set<Integer> brokerIdsUnderBalanceLowerLimit = new HashSet<Integer>();
    protected double avgReplicasOnBrokerToBalance;
    protected ReplicaCountThresholds replicaThresholds;

    boolean isReplicaCountUnderBalanceUpperLimitAfterChange(Broker broker, int currentReplicaCount, ChangeType changeType) {
        int brokerBalanceUpperLimit;
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("isReplicaCountUnderBalanceUpperLimitAfterChange doesn't accept ignored broker as input.");
        }
        int n = brokerBalanceUpperLimit = broker.isAlive() ? this.replicaThresholds.numReplicasUpperLimit : 0;
        return changeType == ChangeType.ADD ? currentReplicaCount + 1 <= brokerBalanceUpperLimit : currentReplicaCount - 1 <= brokerBalanceUpperLimit;
    }

    boolean isReplicaCountAboveBalanceLowerLimitAfterChange(Broker broker, int currentReplicaCount, ChangeType changeType) {
        int brokerBalanceLowerLimit;
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("isReplicaCountAboveBalanceLowerLimitAfterChange doesn't accept ignored broker as input.");
        }
        int n = brokerBalanceLowerLimit = broker.isAlive() ? this.replicaThresholds.numReplicasLowerLimit : 0;
        return changeType == ChangeType.ADD ? currentReplicaCount + 1 >= brokerBalanceLowerLimit : currentReplicaCount - 1 >= brokerBalanceLowerLimit;
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.eligibleSourceBrokers();
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> metricsOpt) {
        SortedSet<Broker> eligibleDestinationBrokers = clusterModel.eligibleDestinationBrokers();
        this.avgReplicasOnBrokerToBalance = (double)this.numInterestedReplicas(clusterModel) / (double)eligibleDestinationBrokers.size();
        if (clusterModel.topics().equals(optimizationOptions.excludedTopics())) {
            LOG.warn("All replicas are excluded from {}.", (Object)this.name());
        }
        this.fixOfflineReplicasOnly = false;
        this.replicaThresholds = ReplicaCountThresholds.compute(optimizationOptions, this.balancingConstraint, this.avgReplicasOnBrokerToBalance, this.balancePercentage());
        LOG.info("Initiated {} with lower limit {} and upper limit {} (isTriggeredByGoalViolation {})", new Object[]{this.name(), this.replicaThresholds.numReplicasLowerLimit, this.replicaThresholds.numReplicasUpperLimit, optimizationOptions.isTriggeredByGoalViolation()});
        if (metricsOpt.isPresent()) {
            List<BrokerResourceStats> resources = eligibleDestinationBrokers.stream().map(b -> new BrokerResourceStats((double)this.balancingConstraint.maxReplicasPerBroker().longValue(), (double)this.numInterestedReplicas((Broker)b), b.id(), this.resource(), b.cell().id())).collect(Collectors.toList());
            ReplicaDistributionStatsSnapshot statsSnapshot = ReplicaDistributionStatsSnapshot.compute(this.replicaThresholds, resources);
            OptimizationMetrics metrics = metricsOpt.get();
            metrics.recordDistributionBalanceStats(this, statsSnapshot);
        }
    }

    abstract ReplicaDistributionStatsSnapshot.ReplicaResource resource();

    abstract int numInterestedReplicas(ClusterModel var1);

    abstract int numInterestedReplicas(Broker var1);

    abstract double balancePercentage();

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        if (this.fixOfflineReplicasOnly && sourceBroker.replica(action.topicPartition()).isCurrentOffline()) {
            return true;
        }
        return this.actionAcceptance(action, clusterModel) == ActionAcceptance.ACCEPT;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        if (!this.brokerIdsAboveBalanceUpperLimit.isEmpty()) {
            LOG.debug("Replicas count on broker ids:{} {} above the balance limit of {} after {}.", new Object[]{this.brokerIdsAboveBalanceUpperLimit, this.brokerIdsAboveBalanceUpperLimit.size() > 1 ? "are" : "is", this.replicaThresholds.numReplicasUpperLimit, clusterModel.selfHealingEligibleReplicas().isEmpty() ? "rebalance" : "self-healing"});
            this.brokerIdsAboveBalanceUpperLimit.clear();
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        if (!this.brokerIdsUnderBalanceLowerLimit.isEmpty()) {
            LOG.debug("Replica count on broker ids:{} {} under the balance limit of {} after {}.", new Object[]{this.brokerIdsUnderBalanceLowerLimit, this.brokerIdsUnderBalanceLowerLimit.size() > 1 ? "are" : "is", this.replicaThresholds.numReplicasLowerLimit, clusterModel.selfHealingEligibleReplicas().isEmpty() ? "rebalance" : "self-healing"});
            this.brokerIdsUnderBalanceLowerLimit.clear();
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        try {
            GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        }
        catch (OptimizationFailureException ofe) {
            if (this.fixOfflineReplicasOnly) {
                throw ofe;
            }
            this.fixOfflineReplicasOnly = true;
            LOG.info("Ignoring replica balance limit to move replicas from dead brokers/disks.");
            return;
        }
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    protected static enum ChangeType {
        ADD,
        REMOVE;

    }
}

