/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerProposalLeaderboard;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.DetailedProposal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ProposalObservabilityTrackingOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

public class ProposalLeaderboard {
    private final Map<Integer, BrokerProposalLeaderboard> leaderboardByBroker = new HashMap<Integer, BrokerProposalLeaderboard>();
    private final boolean isEnabled;
    private final int maxNumProposals;
    private boolean finished = false;
    private Result finishedResult = null;

    public ProposalLeaderboard(ProposalObservabilityTrackingOptions trackingOptions) {
        this.maxNumProposals = trackingOptions.maxNumberOfProposals;
        this.isEnabled = trackingOptions.isEnabled;
    }

    public Result finish() {
        if (this.finished) {
            return this.finishedResult;
        }
        this.finishedResult = new Result(this.leaderboardByBroker.values().stream().map(BrokerProposalLeaderboard::finish).collect(Collectors.toMap(BrokerProposalLeaderboard.Result::brokerId, v -> v)), this.maxNumProposals);
        this.finished = true;
        return this.finishedResult;
    }

    public void submitProposal(DetailedProposal.Result detailedProposalResult) {
        if (this.finished) {
            throw new IllegalStateException("Cannot add a proposal to a finished leaderboard.");
        }
        if (!this.isEnabled) {
            return;
        }
        int broker = detailedProposalResult.proposal.brokerForRebalance;
        BrokerProposalLeaderboard leaderboard = this.leaderboardByBroker.computeIfAbsent(broker, k -> new BrokerProposalLeaderboard((int)k, this.maxNumProposals));
        leaderboard.submitProposal(detailedProposalResult);
    }

    @Immutable
    public static class Result {
        private final Map<Integer, BrokerProposalLeaderboard.Result> leaderboardByBroker;
        private final int numProposals;

        public Result(Map<Integer, BrokerProposalLeaderboard.Result> leaderboardByBroker, int numProposals) {
            this.leaderboardByBroker = Collections.unmodifiableMap(leaderboardByBroker);
            this.numProposals = numProposals;
        }

        public boolean isEmpty() {
            return this.leaderboardByBroker.isEmpty();
        }

        public int maxNumProposalsPerLeaderboard() {
            return this.numProposals;
        }

        public Map<Integer, BrokerProposalLeaderboard.Result> leaderboardByBroker() {
            return this.leaderboardByBroker;
        }
    }
}

