/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholds;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ResourceUtilizationRatioThresholdsProvider {
    private final ResourceUtilizationRatioThresholds clusterThresholds;
    private final Map<Integer, ResourceUtilizationRatioThresholds> cellThresholds;

    public ResourceUtilizationRatioThresholdsProvider(ResourceUtilizationRatioThresholds clusterThresholds, Map<Integer, ResourceUtilizationRatioThresholds> cellThresholds) {
        this.clusterThresholds = Objects.requireNonNull(clusterThresholds, "Cannot construct ResourceUtilizationRatioThresholdsProvider with null clusterThresholds");
        this.cellThresholds = Objects.requireNonNull(Collections.unmodifiableMap(cellThresholds), "Cannot construct ResourceUtilizationRatioThresholdsProvider with null cellThresholds");
        Set resourcesInCellThresholds = cellThresholds.values().stream().map(ResourceUtilizationRatioThresholds::resource).collect(Collectors.toSet());
        if (resourcesInCellThresholds.size() > 1 || !resourcesInCellThresholds.isEmpty() && clusterThresholds.resource() != resourcesInCellThresholds.iterator().next()) {
            throw new IllegalArgumentException("clusterThresholds and all cell thresholds within cellThresholds must be referring towards the same resource type");
        }
    }

    public ResourceUtilizationRatioThresholds clusterThresholds() {
        return this.clusterThresholds;
    }

    public Map<Integer, ResourceUtilizationRatioThresholds> cellsThresholds() {
        return this.cellThresholds;
    }

    public double balanceUpperThreshold(Broker broker) {
        return this.thresholds(broker).balanceUpperThreshold();
    }

    public double balanceUpperThreshold(int cellId) {
        return this.thresholds(cellId).balanceUpperThreshold();
    }

    public double balanceLowerThreshold(Broker broker) {
        return this.thresholds(broker).balanceLowerThreshold();
    }

    public double balanceLowerThreshold(int cellId) {
        return this.thresholds(cellId).balanceLowerThreshold();
    }

    public double lowUtilizationRatio(Broker broker) {
        return this.thresholds(broker).lowUtilizationRatio();
    }

    public double lowUtilizationRatio(int cellId) {
        return this.thresholds(cellId).lowUtilizationRatio();
    }

    public double meanUtilizationRatio(Broker broker) {
        return this.thresholds(broker).meanUtilizationRatio();
    }

    public double meanUtilizationRatio(int cellId) {
        return this.thresholds(cellId).meanUtilizationRatio();
    }

    public Resource resource() {
        return this.clusterThresholds.resource();
    }

    private ResourceUtilizationRatioThresholds thresholds(Broker broker) {
        ResourceUtilizationRatioThresholdsProvider.assertNotNullBroker(broker);
        return this.thresholds(broker.cell().id());
    }

    private ResourceUtilizationRatioThresholds thresholds(int cellId) {
        if (this.useClusterThresholds(cellId)) {
            return this.clusterThresholds;
        }
        return this.cellThresholds.get(cellId);
    }

    private boolean useClusterThresholds(int cellId) {
        return Cell.isDefaultCellId(cellId) || Cell.isImaginaryCellId(cellId);
    }

    private static void assertNotNullBroker(Broker broker) {
        if (Objects.isNull(broker)) {
            throw new IllegalArgumentException("broker cannot be null");
        }
    }
}

