/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import com.linkedin.kafka.cruisecontrol.common.BatchedConfigsFetcher;
import com.linkedin.kafka.cruisecontrol.common.SbcClusterSnapshot;
import com.linkedin.kafka.cruisecontrol.config.ConfigSupplier;
import com.linkedin.kafka.cruisecontrol.config.GoalConfigChangeNotifier;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.monitor.MonitorUtils;
import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.DescribeCellsOptions;
import io.confluent.kafka.clients.DescribeTenantsOptions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DegradedBroker;
import org.apache.kafka.clients.admin.DescribeBrokerHealthOptions;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsOptions;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.TopicPlacement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataClient {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataClient.class);
    private ClusterMetadata clusterMetadata;
    private int metadataGeneration = 0;
    private final Time time;
    private final long metadataTTLMs;
    private final CloudAdmin adminClient;
    private final int refreshMetadataTimeoutMs;
    private final ConfigSupplier configSupplier;
    private long lastSuccessfulUpdateMs;
    private volatile boolean requiresTopicPlacementData;
    long version;

    MetadataClient(ConfigSupplier configSupplier, int timeoutMs, long metadataTTLMs, Time time, CloudAdmin adminClient, boolean fetchTopicPlacementData, GoalConfigChangeNotifier goalConfigChangeNotifier) {
        this.refreshMetadataTimeoutMs = timeoutMs;
        this.configSupplier = configSupplier;
        this.adminClient = adminClient;
        this.time = time;
        this.metadataTTLMs = metadataTTLMs;
        this.version = 0L;
        this.lastSuccessfulUpdateMs = 0L;
        this.requiresTopicPlacementData = fetchTopicPlacementData;
        this.clusterMetadata = new ClusterMetadata(Cluster.empty(), Optional.empty(), Collections.emptyMap(), Collections.emptySet());
        goalConfigChangeNotifier.registerListener(new GoalConfigChangeNotifier.GoalConfigChangeListener("metadata-client-goal-change-listener"){

            @Override
            public void onChange(SbcGoalsConfig newConfig) {
                GoalsConfig rebalancingGoals = newConfig.rebalancingGoals();
                GoalsConfig incrementalBalancingGoals = newConfig.incrementalBalancingGoals();
                boolean newRequiresTopicPlacementData = Stream.of(rebalancingGoals, incrementalBalancingGoals).map(GoalsConfig::requirements).anyMatch(ModelCompletenessRequirements::requiresTopicPlacements);
                if (newRequiresTopicPlacementData != MetadataClient.this.requiresTopicPlacementData) {
                    LOG.info("Changed requirement of topic placement data fetching in metadata client from {}->{}", (Object)MetadataClient.this.requiresTopicPlacementData, (Object)newRequiresTopicPlacementData);
                }
                MetadataClient.this.requiresTopicPlacementData = newRequiresTopicPlacementData;
            }
        });
    }

    public boolean isRequiresTopicPlacementData() {
        return this.requiresTopicPlacementData;
    }

    public ClusterAndGeneration maybeRefreshMetadata() {
        return this.maybeRefreshMetadata(this.refreshMetadataTimeoutMs, false);
    }

    public ClusterAndGeneration forceRefreshMetadata(int timeoutMs) {
        return this.maybeRefreshMetadata(timeoutMs, true);
    }

    public ClusterAndGeneration forceRefreshMetadata() {
        return this.maybeRefreshMetadata(this.refreshMetadataTimeoutMs, true);
    }

    public ClusterAndGeneration maybeRefreshMetadata(int timeoutMs) {
        return this.maybeRefreshMetadata(timeoutMs, false);
    }

    private synchronized ClusterAndGeneration maybeRefreshMetadata(int timeoutMs, boolean force) {
        if (force || this.time.milliseconds() >= this.lastSuccessfulUpdateMs + this.metadataTTLMs) {
            try {
                ClusterMetadata refreshedClusterMetadata = this.doRefreshMetadata(timeoutMs);
                this.lastSuccessfulUpdateMs = this.time.milliseconds();
                ++this.version;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Metadata refresh, was generation ID: {} cluster data: {}", (Object)this.metadataGeneration, (Object)this.clusterMetadata);
                    LOG.debug("Metadata refresh switching to version {} cluster data: {}", (Object)this.version, (Object)refreshedClusterMetadata);
                }
                if (MonitorUtils.metadataChanged(this.clusterMetadata, refreshedClusterMetadata)) {
                    ++this.metadataGeneration;
                    this.clusterMetadata = refreshedClusterMetadata;
                }
            }
            catch (InterruptedException | ExecutionException | org.apache.kafka.common.errors.TimeoutException e) {
                LOG.warn("Exception while updating metadata ", e);
                LOG.warn("Failed to update metadata in {}ms (force = {}). Using old metadata with version {} and last successful update {}.", new Object[]{timeoutMs, force, this.version, this.lastSuccessfulUpdateMs});
            }
        }
        return new ClusterAndGeneration(this.clusterMetadata, this.metadataGeneration);
    }

    public Optional<SbcClusterSnapshot> fetchSbcClusterSnapshot(Collection<String> topicNames) throws InterruptedException {
        return this.fetchSbcClusterSnapshot(topicNames, this.refreshMetadataTimeoutMs);
    }

    Optional<SbcClusterSnapshot> fetchSbcClusterSnapshot(Collection<String> topicNames, int timeoutMs) throws InterruptedException {
        Optional<Collection<Node>> nodes;
        Optional<Object> partitionInfoCollection = Optional.empty();
        long deadlineMs = this.time.hiResClockMs() + (long)timeoutMs;
        do {
            Map topicFutureDescriptionMap;
            Optional<Collection<TopicDescription>> topicDescriptions;
            int timeTillDeadlineMs = (int)(deadlineMs - this.time.hiResClockMs());
            DescribeTopicsResult describeTopics = this.adminClient.describeTopics(topicNames, new DescribeTopicsOptions().timeoutMs(Integer.valueOf(timeTillDeadlineMs)));
            DescribeClusterResult describeClusterResult = this.adminClient.describeCluster(new DescribeClusterOptions().timeoutMs(Integer.valueOf(timeTillDeadlineMs)));
            nodes = MetadataClient.getNodes(timeTillDeadlineMs, describeClusterResult);
            if (nodes.isPresent() && (topicDescriptions = this.extractFoundTopicDescriptions(topicFutureDescriptionMap = describeTopics.topicNameValues(), timeTillDeadlineMs)).isPresent()) {
                partitionInfoCollection = MetadataClient.tryMapToPartitionInfo(topicDescriptions.get(), nodes.get());
            }
            if (this.time.hiResClockMs() < deadlineMs) continue;
            LOG.info("Unable to fetch information about the topics and cluster state in {} ms", (Object)timeoutMs);
            return Optional.empty();
        } while (!partitionInfoCollection.isPresent());
        return Optional.of(new SbcClusterSnapshot(nodes.get(), MetadataClient.partitionsByTopicPartition((Collection)partitionInfoCollection.get())));
    }

    private static Optional<Collection<Node>> getNodes(int timeTillDeadlineMs, DescribeClusterResult describeClusterResult) throws InterruptedException {
        try {
            return Optional.ofNullable(describeClusterResult.nodes().get((long)timeTillDeadlineMs, TimeUnit.MILLISECONDS));
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof org.apache.kafka.common.errors.TimeoutException) {
                LOG.info("Describe kafka cluster timed out after {} ms", (Object)timeTillDeadlineMs, (Object)executionException);
            } else {
                LOG.warn("Unable to describe cluster due to an unexpected exception", (Throwable)executionException);
            }
        }
        catch (TimeoutException timeoutException) {
            LOG.info("Describe kafka cluster future timed out after {} ms", (Object)timeTillDeadlineMs, (Object)timeoutException);
        }
        return Optional.empty();
    }

    private Set<DescribeTenantsResponseData.TenantDescription> fetchTenantsInfo(int timeoutMs) throws ExecutionException, InterruptedException {
        List tenantDescriptions = Collections.emptyList();
        if (this.configSupplier.getConfig().getBoolean("confluent.cells.enable").booleanValue()) {
            tenantDescriptions = (List)this.adminClient.describeTenants(Collections.emptyList(), (DescribeTenantsOptions)new DescribeTenantsOptions().timeoutMs(Integer.valueOf(timeoutMs))).value().get();
        }
        return new HashSet<DescribeTenantsResponseData.TenantDescription>(tenantDescriptions);
    }

    private Map<Integer, DescribeCellsResponseData.Cell> fetchCellsInfo(Collection<Node> nodes, int timeoutMs) throws InterruptedException, ExecutionException {
        HashMap<Integer, DescribeCellsResponseData.Cell> brokerIdToCell = new HashMap<Integer, DescribeCellsResponseData.Cell>();
        if (this.configSupplier.getConfig().getBoolean("confluent.cells.enable").booleanValue()) {
            List cellsInfo = ((DescribeCellsResponseData)this.adminClient.describeCells(Collections.emptyList(), (DescribeCellsOptions)new DescribeCellsOptions().timeoutMs(Integer.valueOf(timeoutMs))).value().get()).cells();
            cellsInfo.forEach(cellDescription -> cellDescription.brokers().forEach(broker -> brokerIdToCell.put((Integer)broker, (DescribeCellsResponseData.Cell)cellDescription)));
        }
        if (nodes.size() != brokerIdToCell.size()) {
            List<Integer> unassignedBrokerIds = nodes.stream().filter(node -> !brokerIdToCell.containsKey(node.id())).map(node -> node.id()).collect(Collectors.toList());
            DescribeCellsResponseData.Cell defaultCell = new DescribeCellsResponseData.Cell().setCellId(-1).setState(CellState.UNKNOWN.code()).setBrokers(unassignedBrokerIds);
            unassignedBrokerIds.forEach(nodeId -> brokerIdToCell.put((Integer)nodeId, defaultCell));
        }
        return brokerIdToCell;
    }

    private Optional<Collection<TopicDescription>> extractFoundTopicDescriptions(Map<String, KafkaFuture<TopicDescription>> topicFutureDescriptionMap, int timeoutMs) throws InterruptedException {
        ArrayList<TopicDescription> topicDescriptionMap = new ArrayList<TopicDescription>(topicFutureDescriptionMap.size());
        for (Map.Entry<String, KafkaFuture<TopicDescription>> entry : topicFutureDescriptionMap.entrySet()) {
            try {
                TopicDescription topicDescription = (TopicDescription)entry.getValue().get((long)timeoutMs, TimeUnit.MILLISECONDS);
                topicDescriptionMap.add(topicDescription);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                    LOG.debug("Describe topics returned unknown topic for {}.", (Object)entry.getKey(), (Object)e);
                    continue;
                }
                if (e.getCause() instanceof org.apache.kafka.common.errors.TimeoutException) {
                    LOG.info("Describe topics timed out ({} ms)", (Object)timeoutMs, (Object)e);
                    return Optional.empty();
                }
                LOG.warn("Unable to describe topic {} due to an unexpected exception.", (Object)entry.getKey(), (Object)e);
                return Optional.empty();
            }
            catch (TimeoutException e) {
                LOG.info("Describe topics future timed out ({} ms)", (Object)timeoutMs, (Object)e);
                return Optional.empty();
            }
        }
        return Optional.of(topicDescriptionMap);
    }

    private static Map<TopicPartition, PartitionInfo> partitionsByTopicPartition(Collection<PartitionInfo> partitionInfoCollection) {
        return partitionInfoCollection.stream().collect(Collectors.toMap(k -> new TopicPartition(k.topic(), k.partition()), v -> v));
    }

    private static Optional<Collection<PartitionInfo>> tryMapToPartitionInfo(Collection<TopicDescription> topicDescriptions, Collection<Node> nodes) {
        Set nodeIds = nodes.stream().map(Node::id).collect(Collectors.toSet());
        ArrayList<PartitionInfo> partitionsByTopicPartition = new ArrayList<PartitionInfo>();
        for (TopicDescription topicDescription : topicDescriptions) {
            String topicName = topicDescription.name();
            for (TopicPartitionInfo topicPartitionInfo : topicDescription.partitions()) {
                if (topicPartitionInfo.leader() != null && !nodeIds.contains(topicPartitionInfo.leader().id())) {
                    LOG.info("Leader node for partition {} is not found in set of nodes: {}.", (Object)topicPartitionInfo, nodeIds);
                    return Optional.empty();
                }
                PartitionInfo partitionInfo = PartitionInfo.of((String)topicName, (int)topicPartitionInfo.partition(), (Node)topicPartitionInfo.leader(), (Node[])topicPartitionInfo.replicas().toArray(new Node[0]), (Node[])topicPartitionInfo.observers().toArray(new Node[0]), (Node[])topicPartitionInfo.isr().toArray(new Node[0]), (Node[])((Node[])topicPartitionInfo.replicas().stream().filter(r -> !nodes.contains(r)).toArray(Node[]::new)));
                partitionsByTopicPartition.add(partitionInfo);
            }
        }
        return Optional.of(partitionsByTopicPartition);
    }

    private ClusterMetadata doRefreshMetadata(int timeoutMs) throws InterruptedException, org.apache.kafka.common.errors.TimeoutException, ExecutionException {
        Optional<Map<String, TopicPlacement>> topicPlacementData;
        Node controller;
        String clusterId;
        Collection nodes;
        Optional<Collection<PartitionInfo>> partitionsCollection;
        Collection<Object> demotions;
        List exclusions;
        Set topicNames;
        DescribeClusterResult describeClusterResult;
        long startMs;
        int remainingMs;
        block5: {
            remainingMs = timeoutMs;
            startMs = this.time.milliseconds();
            KafkaFuture topicNamesFuture = this.adminClient.listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(remainingMs)).listInternal(true)).names();
            KafkaFuture exclusionsFuture = this.adminClient.describeBrokerReplicaExclusions((DescribeBrokerReplicaExclusionsOptions)new DescribeBrokerReplicaExclusionsOptions().timeoutMs(Integer.valueOf(remainingMs))).descriptions();
            describeClusterResult = this.adminClient.describeCluster(new DescribeClusterOptions().timeoutMs(Integer.valueOf(remainingMs)));
            KafkaFuture demotionsFuture = this.adminClient.describeBrokerHealth((DescribeBrokerHealthOptions)new DescribeBrokerHealthOptions().timeoutMs(Integer.valueOf(remainingMs))).future();
            topicNames = (Set)topicNamesFuture.get();
            exclusions = (List)exclusionsFuture.get();
            demotions = Collections.emptySet();
            try {
                demotions = (Collection)demotionsFuture.get();
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnsupportedVersionException)) break block5;
                LOG.debug("Caught an UnsupportedVersionException while trying to describe the degraded brokers. Falling back to an empty set of degraded brokers, assuming that the cluster is running in KRaft mode (which does not yet support the API).");
            }
        }
        long elapsedTimeMs = this.time.milliseconds() - startMs;
        remainingMs = Math.max(0, (int)((long)remainingMs - elapsedTimeMs));
        Map<Integer, String> excludedBrokers = exclusions.stream().collect(Collectors.toMap(DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription::brokerId, DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription::reason));
        Map<Integer, List<String>> degradedBrokers = demotions.stream().collect(Collectors.toMap(DegradedBroker::brokerId, DegradedBroker::reasons));
        Map reassignmentMap = (Map)this.adminClient.listPartitionReassignments((ListPartitionReassignmentsOptions)new ListPartitionReassignmentsOptions().timeoutMs(Integer.valueOf(remainingMs))).reassignments().get();
        do {
            startMs = this.time.milliseconds();
            if (describeClusterResult == null) {
                describeClusterResult = this.adminClient.describeCluster(new DescribeClusterOptions().timeoutMs(Integer.valueOf(remainingMs)));
            }
            nodes = (Collection)describeClusterResult.nodes().get();
            clusterId = (String)describeClusterResult.clusterId().get();
            controller = (Node)describeClusterResult.controller().get();
            describeClusterResult = null;
            elapsedTimeMs = this.time.milliseconds() - startMs;
            remainingMs = Math.max(0, (int)((long)remainingMs - elapsedTimeMs));
            startMs = this.time.milliseconds();
            DescribeTopicsResult describeTopicsResult = this.adminClient.describeTopics((Collection)topicNames, new DescribeTopicsOptions().timeoutMs(Integer.valueOf(remainingMs)));
            elapsedTimeMs = this.time.milliseconds() - startMs;
            remainingMs = Math.max(0, (int)((long)remainingMs - elapsedTimeMs));
            startMs = this.time.milliseconds();
            topicPlacementData = this.maybeFetchTopicPlacements(topicNames, remainingMs);
            Map topicDescriptions = (Map)describeTopicsResult.allTopicNames().get();
            partitionsCollection = MetadataClient.tryMapToPartitionInfo(topicDescriptions.values(), nodes);
            elapsedTimeMs = this.time.milliseconds() - startMs;
            remainingMs = Math.max(0, (int)((long)remainingMs - elapsedTimeMs));
        } while (!partitionsCollection.isPresent() && remainingMs > 0);
        if (!partitionsCollection.isPresent()) {
            throw new org.apache.kafka.common.errors.TimeoutException(String.format("Unable to get metadata in %d msecs", timeoutMs));
        }
        LOG.debug("Fetched cluster metadata in {} msecs", (Object)(timeoutMs - remainingMs));
        int apiTimeout = this.configSupplier.getConfig().getInt("default.api.timeout.ms");
        Set<DescribeTenantsResponseData.TenantDescription> tenants = this.fetchTenantsInfo(apiTimeout);
        Map<Integer, DescribeCellsResponseData.Cell> brokerIdToCell = this.fetchCellsInfo(nodes, apiTimeout);
        Cluster cluster = new Cluster(clusterId, nodes, partitionsCollection.get(), Collections.emptySet(), Collections.emptySet(), controller);
        return new ClusterMetadata(cluster, topicPlacementData, excludedBrokers, reassignmentMap.keySet(), tenants, brokerIdToCell, degradedBrokers);
    }

    Optional<Map<String, TopicPlacement>> maybeFetchTopicPlacements(Set<String> topicNames, int remainingMs) {
        Optional<Map<String, TopicPlacement>> topicPlacementData = Optional.empty();
        if (this.requiresTopicPlacementData) {
            BatchedConfigsFetcher batchedConfigsFetcher = BatchedConfigsFetcher.of((Admin)this.adminClient, this.configSupplier.getConfig(), ConfigResource.Type.TOPIC, this.time).entities(topicNames).timeout(remainingMs).ignoreUnknownTopicOrPartitionException(true).build();
            topicPlacementData = Optional.ofNullable(MetadataClient.toTopicPlacements(batchedConfigsFetcher.getConfigs()));
        }
        return topicPlacementData;
    }

    private static Map<String, TopicPlacement> toTopicPlacements(Map<ConfigResource, Config> topicConfigs) {
        return topicConfigs.entrySet().stream().flatMap(entry -> {
            ConfigEntry topicPlacementConfig = ((Config)entry.getValue()).get("confluent.placement.constraints");
            if (topicPlacementConfig != null) {
                try {
                    Optional topicPlacement = TopicPlacement.parse((String)topicPlacementConfig.value());
                    if (topicPlacement.isPresent()) {
                        return Stream.of(new AbstractMap.SimpleEntry(((ConfigResource)entry.getKey()).name(), topicPlacement.get()));
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Error parsing topic placement config {}. Received exception: {}", (Object)topicPlacementConfig.value(), (Object)e.getMessage());
                    return Stream.empty();
                }
            }
            return Stream.empty();
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public synchronized ClusterAndGeneration clusterAndGeneration() {
        return new ClusterAndGeneration(this.clusterMetadata, this.metadataGeneration);
    }

    public Cluster cluster() {
        return this.clusterMetadata.cluster();
    }

    public static class ClusterAndGeneration {
        private final ClusterMetadata clusterMetadata;
        private final int generation;

        public ClusterAndGeneration(ClusterMetadata cluster, int generation) {
            this.clusterMetadata = cluster;
            this.generation = generation;
        }

        public Cluster cluster() {
            return this.clusterMetadata.cluster();
        }

        public Optional<Map<String, TopicPlacement>> topicPlacements() {
            return this.clusterMetadata.topicPlacements();
        }

        public Map<Integer, String> replicaExclusions() {
            return this.clusterMetadata.replicaExclusions();
        }

        public Map<Integer, List<String>> degradedBrokers() {
            return this.clusterMetadata.degradedBrokers();
        }

        public Set<TopicPartition> reassigningPartitions() {
            return this.clusterMetadata.reassigningPartitions();
        }

        public Set<DescribeTenantsResponseData.TenantDescription> tenants() {
            return this.clusterMetadata.tenantsDescription;
        }

        public Map<Integer, DescribeCellsResponseData.Cell> brokerIdToCellDescription() {
            return Collections.unmodifiableMap(this.clusterMetadata.brokerIdToCellDescription);
        }

        public int generation() {
            return this.generation;
        }

        public String toString() {
            return "ClusterAndGeneration{clusterMetadata=" + this.clusterMetadata + ", generation=" + this.generation + "}";
        }
    }

    public static class ClusterMetadata {
        private final Cluster cluster;
        private final Optional<Map<String, TopicPlacement>> topicPlacements;
        private final Map<Integer, String> brokerReplicaExclusions;
        private final Set<TopicPartition> reassigningPartitions;
        private final Set<DescribeTenantsResponseData.TenantDescription> tenantsDescription;
        private final Map<Integer, DescribeCellsResponseData.Cell> brokerIdToCellDescription;
        private final Map<Integer, List<String>> degradedBrokers;

        public ClusterMetadata(Cluster cluster, Optional<Map<String, TopicPlacement>> topicPlacements, Map<Integer, String> brokerReplicaExclusions, Set<TopicPartition> reassigningPartitions) {
            this(cluster, topicPlacements, brokerReplicaExclusions, reassigningPartitions, Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap());
        }

        public ClusterMetadata(Cluster cluster, Optional<Map<String, TopicPlacement>> topicPlacements, Map<Integer, String> brokerReplicaExclusions, Set<TopicPartition> reassigningPartitions, Set<DescribeTenantsResponseData.TenantDescription> tenantsDescription, Map<Integer, DescribeCellsResponseData.Cell> brokerIdToCellDescription, Map<Integer, List<String>> degradedBrokers) {
            this.cluster = cluster;
            this.topicPlacements = topicPlacements;
            this.brokerReplicaExclusions = brokerReplicaExclusions;
            this.reassigningPartitions = reassigningPartitions;
            this.tenantsDescription = tenantsDescription;
            this.brokerIdToCellDescription = brokerIdToCellDescription;
            this.degradedBrokers = degradedBrokers;
        }

        public Cluster cluster() {
            return this.cluster;
        }

        public Optional<Map<String, TopicPlacement>> topicPlacements() {
            return this.topicPlacements;
        }

        public Map<Integer, String> replicaExclusions() {
            return this.brokerReplicaExclusions;
        }

        public Map<Integer, List<String>> degradedBrokers() {
            return this.degradedBrokers;
        }

        public Set<TopicPartition> reassigningPartitions() {
            return this.reassigningPartitions;
        }

        public Set<DescribeTenantsResponseData.TenantDescription> tenants() {
            return this.tenantsDescription;
        }

        public Map<Integer, DescribeCellsResponseData.Cell> brokerIdToCellDescription() {
            return this.brokerIdToCellDescription;
        }

        public String toString() {
            return "ClusterMetadata{cluster=" + this.cluster + ", topicPlacements=" + this.topicPlacements + ", brokerReplicaExclusions=" + this.brokerReplicaExclusions + ", reassigningPartitions=" + this.reassigningPartitions + ", tenantsDescription=" + this.tenantsDescription + ", brokerIdToCellDescription=" + this.brokerIdToCellDescription + ", degradedBrokers=" + this.degradedBrokers + "}";
        }
    }

    public static class Builder {
        private final Time time;
        public final int metadataTimeoutMs;
        public final long metadataTtlMs;
        public final boolean requiresTopicPlacement;
        public final ConfigSupplier configSupplier;
        private final GoalConfigChangeNotifier goalConfigChangeNotifier;

        public Builder(ConfigSupplier configSupplier, Time time, UpdatableSbcGoalsConfig updatableSbcGoalsConfig) {
            this.configSupplier = configSupplier;
            KafkaCruiseControlConfig config = configSupplier.getConfig();
            this.time = time;
            this.metadataTimeoutMs = config.getInt("metadata.client.timeout.ms");
            this.metadataTtlMs = config.getLong("metadata.ttl");
            this.requiresTopicPlacement = updatableSbcGoalsConfig.config().rebalancingGoals().requirements().requiresTopicPlacements();
            this.goalConfigChangeNotifier = updatableSbcGoalsConfig;
        }

        public MetadataClient build(CloudAdmin admin) {
            return new MetadataClient(this.configSupplier, this.metadataTimeoutMs, this.metadataTtlMs, this.time, admin, this.requiresTopicPlacement, this.goalConfigChangeNotifier);
        }
    }
}

