/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.errors.BalancerMisconfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class SbcGoalsConfigDelta {
    private static final Logger LOG = LoggerFactory.getLogger(SbcGoalsConfigDelta.class);
    private final List<String> newRebalancingGoals;
    private final List<String> newTriggeringGoals;
    private final Boolean newIncrementalBalancingEnabled;
    private final List<String> newIncrementalBalancingGoals;
    private final Boolean hasUpdate;

    private SbcGoalsConfigDelta(Builder builder) {
        this.newRebalancingGoals = builder.newRebalancingGoals;
        this.newTriggeringGoals = builder.newTriggeringGoals;
        this.newIncrementalBalancingEnabled = builder.newIncrementalBalancingEnabled;
        this.newIncrementalBalancingGoals = builder.newIncrementalBalancingGoals;
        this.hasUpdate = builder.hasUpdate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public String toString() {
        return "{newRebalancingGoals=" + this.newRebalancingGoals + ", newTriggeringGoals=" + this.newTriggeringGoals + ", newIncrementalBalancingEnabled=" + this.newIncrementalBalancingEnabled + ", newIncrementalBalancingGoals=" + this.newIncrementalBalancingGoals + ", hasUpdate=" + this.hasUpdate + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SbcGoalsConfigDelta that = (SbcGoalsConfigDelta)o;
        return Objects.equals(this.newRebalancingGoals, that.newRebalancingGoals) && Objects.equals(this.newTriggeringGoals, that.newTriggeringGoals) && Objects.equals(this.newIncrementalBalancingEnabled, that.newIncrementalBalancingEnabled) && Objects.equals(this.newIncrementalBalancingGoals, that.newIncrementalBalancingGoals) && Objects.equals(this.hasUpdate, that.hasUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.newRebalancingGoals, this.newTriggeringGoals, this.newIncrementalBalancingEnabled, this.newIncrementalBalancingGoals, this.hasUpdate);
    }

    public KafkaCruiseControlConfig apply(KafkaCruiseControlConfig oldConfig) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        boolean rebalancingGoalsAreDefined = !SbcGoalsConfigDelta.isNullOrEmpty(this.newRebalancingGoals);
        boolean triggeringGoalsAreDefined = !SbcGoalsConfigDelta.isNullOrEmpty(this.newTriggeringGoals);
        boolean clearGoalsConfig = false;
        if (rebalancingGoalsAreDefined && triggeringGoalsAreDefined) {
            newConfigs.put("goals", this.newRebalancingGoals);
            newConfigs.put("anomaly.detection.goals", this.newTriggeringGoals);
        } else if (!rebalancingGoalsAreDefined && !triggeringGoalsAreDefined) {
            clearGoalsConfig = true;
        } else {
            LOG.warn("Changes to rebalancing and triggering goals are not applied since new rebalancing goals ({}) or new triggering goals ({}) are not defined.", this.newRebalancingGoals, this.newTriggeringGoals);
        }
        if (this.newIncrementalBalancingEnabled != null) {
            newConfigs.put("incremental.balancing.enabled", this.newIncrementalBalancingEnabled);
        }
        if (this.newIncrementalBalancingGoals != null) {
            newConfigs.put("incremental.balancing.goals", this.newIncrementalBalancingGoals);
        }
        KafkaCruiseControlConfig updatedConfig = oldConfig.clone(newConfigs);
        return clearGoalsConfig ? this.clearGoalsConfig(updatedConfig) : updatedConfig;
    }

    private KafkaCruiseControlConfig clearGoalsConfig(KafkaCruiseControlConfig kafkaCruiseControlConfig) {
        HashMap<String, Object> updatedConfig = new HashMap<String, Object>(kafkaCruiseControlConfig.mergedConfigValues());
        updatedConfig.remove("goals");
        updatedConfig.remove("anomaly.detection.goals");
        return new KafkaCruiseControlConfig(updatedConfig);
    }

    private static boolean isNullOrEmpty(List<String> goals) {
        return goals == null || goals.isEmpty();
    }

    public static class Builder {
        private List<String> newRebalancingGoals = null;
        private List<String> newTriggeringGoals = null;
        private Boolean newIncrementalBalancingEnabled = null;
        private List<String> newIncrementalBalancingGoals = null;
        private boolean hasUpdate = false;

        public Builder newRebalancingGoals(List<String> newRebalancingGoals) {
            this.newRebalancingGoals = newRebalancingGoals;
            this.hasUpdate = true;
            return this;
        }

        public Builder newTriggeringGoals(List<String> newTriggeringGoals) {
            this.newTriggeringGoals = newTriggeringGoals;
            this.hasUpdate = true;
            return this;
        }

        public Builder newIncrementalBalancingEnabled(Boolean newIncrementalBalancingEnabled) {
            this.newIncrementalBalancingEnabled = newIncrementalBalancingEnabled;
            this.hasUpdate = true;
            return this;
        }

        public Builder newIncrementalBalancingGoals(List<String> newIncrementalBalancingGoals) {
            this.newIncrementalBalancingGoals = newIncrementalBalancingGoals;
            this.hasUpdate = true;
            return this;
        }

        public SbcGoalsConfigDelta build() {
            if (SbcGoalsConfigDelta.isNullOrEmpty(this.newRebalancingGoals) ^ SbcGoalsConfigDelta.isNullOrEmpty(this.newTriggeringGoals)) {
                String errorMessage = String.format("Non-incremental rebalancing goals and triggering goals must be modified together (both non-null) or not modified at all (both null).%nNew rebalancing goals: %s%nNew triggering goals: %s%n", this.newRebalancingGoals, this.newTriggeringGoals);
                throw new BalancerMisconfigurationException(errorMessage);
            }
            return new SbcGoalsConfigDelta(this);
        }
    }
}

