/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.notifier;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.detector.notifier.SelfHealingNotifier;
import com.linkedin.kafka.cruisecontrol.detector.notifier.SlackMessage;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackSelfHealingNotifier
extends SelfHealingNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(SlackSelfHealingNotifier.class);
    public static final String SLACK_SELF_HEALING_NOTIFIER_WEBHOOK = "slack.self.healing.notifier.webhook";
    public static final String SLACK_SELF_HEALING_NOTIFIER_ICON = "slack.self.healing.notifier.icon";
    public static final String SLACK_SELF_HEALING_NOTIFIER_USER = "slack.self.healing.notifier.user";
    public static final String SLACK_SELF_HEALING_NOTIFIER_CHANNEL = "slack.self.healing.notifier.channel";
    public static final String DEFAULT_SLACK_SELF_HEALING_NOTIFIER_ICON = ":information_source:";
    public static final String DEFAULT_SLACK_SELF_HEALING_NOTIFIER_USER = "Cruise Control";
    protected String slackWebhook;
    protected String slackIcon;
    protected String slackChannel;
    protected String slackUser;

    public SlackSelfHealingNotifier() {
    }

    public SlackSelfHealingNotifier(Time time) {
        super(time);
    }

    @Override
    public void configure(Map<String, ?> config) {
        super.configure(config);
        this.slackWebhook = (String)config.get(SLACK_SELF_HEALING_NOTIFIER_WEBHOOK);
        this.slackIcon = (String)config.get(SLACK_SELF_HEALING_NOTIFIER_ICON);
        this.slackChannel = (String)config.get(SLACK_SELF_HEALING_NOTIFIER_CHANNEL);
        this.slackUser = (String)config.get(SLACK_SELF_HEALING_NOTIFIER_USER);
        this.slackIcon = this.slackIcon == null ? DEFAULT_SLACK_SELF_HEALING_NOTIFIER_ICON : this.slackIcon;
        this.slackUser = this.slackUser == null ? DEFAULT_SLACK_SELF_HEALING_NOTIFIER_USER : this.slackUser;
    }

    @Override
    public void alert(Object anomaly, boolean autoFixTriggered, long selfHealingStartTime, AnomalyType anomalyType) {
        super.alert(anomaly, autoFixTriggered, selfHealingStartTime, anomalyType);
        if (this.slackWebhook == null) {
            LOG.warn("Slack webhook is null, can't send Slack self healing notification");
            return;
        }
        if (this.slackChannel == null) {
            LOG.warn("Slack channel name is null, can't send Slack self healing notification");
            return;
        }
        String text = autoFixTriggered ? "Self-healing has been triggered." : String.format("%s detected %s. Self healing %s.", new Object[]{anomalyType, anomaly, (Boolean)this.selfHealingEnabled.get((Object)anomalyType) != false ? String.format("start time %s", KafkaCruiseControlUtils.toDateString(selfHealingStartTime)) : "is disabled"});
        try {
            this.sendSlackMessage(new SlackMessage(this.slackUser, text, this.slackIcon, this.slackChannel), this.slackWebhook);
        }
        catch (IOException e) {
            LOG.warn("ERROR sending alert to Slack", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSlackMessage(SlackMessage slackMessage, String slackWebhookUrl) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(slackWebhookUrl);
        StringEntity entity = new StringEntity(slackMessage.toString());
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        try {
            client.execute((HttpUriRequest)httpPost);
        }
        finally {
            client.close();
        }
    }
}

