/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExecutionTask
implements Comparable<ExecutionTask> {
    private static final String EXECUTION_ID = "executionId";
    private static final String TYPE = "type";
    private static final String STATE = "state";
    private static final String PROPOSAL = "proposal";
    private static final String BROKER_ID = "brokerId";
    private static final Map<State, Set<State>> VALID_TRANSFER = new HashMap<State, Set<State>>();
    private final TaskType type;
    private final long executionId;
    private final ExecutionProposal proposal;
    private final int brokerId;
    private State state;
    private boolean hasBeenRetried;
    private long startTime;
    private long endTime;

    public ExecutionTask(long executionId, ExecutionProposal proposal, Integer brokerId, TaskType type) {
        if (type != TaskType.INTRA_BROKER_REPLICA_ACTION && brokerId != null) {
            throw new IllegalArgumentException("Broker id is specified for non-intra-broker task.");
        }
        this.executionId = executionId;
        this.proposal = proposal;
        this.brokerId = brokerId == null ? -1 : brokerId;
        this.state = State.PENDING;
        this.hasBeenRetried = false;
        this.type = type;
        this.startTime = -1L;
        this.endTime = -1L;
    }

    public ExecutionTask(long executionId, ExecutionProposal proposal, TaskType type) {
        this(executionId, proposal, null, type);
    }

    public boolean canTransferToState(State targetState) {
        return VALID_TRANSFER.get((Object)this.state).contains((Object)targetState);
    }

    public Set<State> validTargetState() {
        return Collections.unmodifiableSet(VALID_TRANSFER.get((Object)this.state));
    }

    public long executionId() {
        return this.executionId;
    }

    public ExecutionProposal proposal() {
        return this.proposal;
    }

    public TaskType type() {
        return this.type;
    }

    public State state() {
        return this.state;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int requiredParallelism() {
        return Math.max(this.proposal().replicaMovementParallelism(), 1);
    }

    public void pending() {
        this.ensureValidTransfer(State.PENDING);
        this.state = State.PENDING;
    }

    public void inProgress(long now) {
        this.ensureValidTransfer(State.IN_PROGRESS);
        this.state = State.IN_PROGRESS;
        this.startTime = now;
    }

    public void toBeRetried() {
        this.ensureValidTransfer(State.TO_RETRY);
        this.state = State.TO_RETRY;
        this.hasBeenRetried = true;
    }

    public void kill(long now) {
        this.ensureValidTransfer(State.DEAD);
        this.state = State.DEAD;
        this.endTime = now;
    }

    public void abort() {
        this.ensureValidTransfer(State.ABORTING);
        this.state = State.ABORTING;
    }

    public void aborted(long now) {
        this.ensureValidTransfer(State.ABORTED);
        this.state = State.ABORTED;
        this.endTime = now;
    }

    public void completed(long now) {
        this.ensureValidTransfer(State.COMPLETED);
        this.state = State.COMPLETED;
        this.endTime = now;
    }

    public boolean equals(Object o) {
        return o instanceof ExecutionTask && this.executionId == ((ExecutionTask)o).executionId;
    }

    public int hashCode() {
        return (int)this.executionId;
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> executionStatsMap = new HashMap<String, Object>();
        executionStatsMap.put(EXECUTION_ID, this.executionId);
        executionStatsMap.put(TYPE, (Object)this.type);
        executionStatsMap.put(STATE, (Object)this.state);
        executionStatsMap.put(PROPOSAL, this.proposal.getJsonStructure());
        if (this.type == TaskType.INTRA_BROKER_REPLICA_ACTION) {
            executionStatsMap.put(BROKER_ID, this.brokerId);
        }
        return executionStatsMap;
    }

    private void ensureValidTransfer(State targetState) {
        if (!this.canTransferToState(targetState)) {
            throw new IllegalStateException("Cannot mark a task in " + (Object)((Object)this.state) + " to" + (Object)((Object)targetState) + "state. The valid target state are " + this.validTargetState());
        }
        if (targetState == State.TO_RETRY && this.hasBeenRetried) {
            throw new IllegalStateException("Cannot mark task " + this.executionId + " to be retried as it had already done so previously.");
        }
    }

    public String toString() {
        switch (this.type) {
            case INTRA_BROKER_REPLICA_ACTION: {
                return String.format("{EXE_ID: %d, %s(%d), %s, %s}", new Object[]{this.executionId, this.type, this.brokerId, this.proposal, this.state});
            }
            case INTER_BROKER_REPLICA_ACTION: 
            case LEADER_ACTION: {
                return String.format("{EXE_ID: %d, %s, %s, %s}", new Object[]{this.executionId, this.type, this.proposal, this.state});
            }
        }
        throw new IllegalStateException("Unknown task type " + (Object)((Object)this.type));
    }

    @Override
    public int compareTo(ExecutionTask o) {
        return Long.compare(this.executionId, o.executionId);
    }

    static {
        VALID_TRANSFER.put(State.PENDING, new HashSet<State>(Collections.singleton(State.IN_PROGRESS)));
        VALID_TRANSFER.put(State.TO_RETRY, new HashSet<State>(Collections.singleton(State.PENDING)));
        VALID_TRANSFER.put(State.IN_PROGRESS, new HashSet<State>(Arrays.asList(State.TO_RETRY, State.ABORTING, State.DEAD, State.COMPLETED)));
        VALID_TRANSFER.put(State.ABORTING, new HashSet<State>(Arrays.asList(State.ABORTED, State.DEAD)));
        VALID_TRANSFER.put(State.COMPLETED, Collections.emptySet());
        VALID_TRANSFER.put(State.DEAD, Collections.emptySet());
        VALID_TRANSFER.put(State.ABORTED, Collections.emptySet());
    }

    public static enum State {
        PENDING{

            @Override
            public String toString(int numMovements) {
                return String.format("%d tasks pending", numMovements);
            }
        }
        ,
        IN_PROGRESS{

            @Override
            public String toString(int numMovements) {
                return String.format("%d tasks in-progress", numMovements);
            }
        }
        ,
        TO_RETRY{

            @Override
            public String toString(int numMovements) {
                return String.format("%d tasks to be retried", numMovements);
            }
        }
        ,
        ABORTING{

            @Override
            public String toString(int numMovements) {
                return String.format("%d tasks aborting", numMovements);
            }
        }
        ,
        ABORTED{

            @Override
            public String toString(int numMovements) {
                return String.format("%d tasks aborted (rolled back successfully)", numMovements);
            }
        }
        ,
        COMPLETED{

            @Override
            public String toString(int numMovements) {
                return String.format("%d tasks completed", numMovements);
            }
        }
        ,
        DEAD{

            @Override
            public String toString(int numMovements) {
                return String.format("%d tasks dead (cannot be rolled back)", numMovements);
            }
        };

        private static final List<State> CACHED_VALUES;

        public abstract String toString(int var1);

        public static String summarize(Map<State, Integer> stateToNumMovements) {
            return stateToNumMovements.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparingInt(Enum::ordinal))).map(kv -> ((State)((Object)((Object)kv.getKey()))).toString((Integer)kv.getValue())).collect(Collectors.joining(", "));
        }

        public static List<State> cachedValues() {
            return CACHED_VALUES;
        }

        static {
            CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(State.values()));
        }
    }

    public static enum TaskType {
        INTER_BROKER_REPLICA_ACTION{

            @Override
            public String toString() {
                return "inter-broker replica movements";
            }
        }
        ,
        INTRA_BROKER_REPLICA_ACTION{

            @Override
            public String toString() {
                return "intra-broker replica movements";
            }
        }
        ,
        LEADER_ACTION{

            @Override
            public String toString() {
                return "leadership replica movements";
            }
        };

        private static final List<TaskType> CACHED_VALUES;

        public abstract String toString();

        public static List<TaskType> cachedValues() {
            return CACHED_VALUES;
        }

        static {
            CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(TaskType.values()));
        }
    }
}

