/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum RawMetricType {
    ALL_TOPIC_BYTES_IN(MetricScope.BROKER, 0),
    ALL_TOPIC_BYTES_OUT(MetricScope.BROKER, 1),
    TOPIC_BYTES_IN(MetricScope.TOPIC, 2),
    TOPIC_BYTES_OUT(MetricScope.TOPIC, 3),
    PARTITION_SIZE(MetricScope.PARTITION, 4),
    BROKER_CPU_UTIL(MetricScope.BROKER, 5),
    ALL_TOPIC_REPLICATION_BYTES_IN(MetricScope.BROKER, 6),
    ALL_TOPIC_REPLICATION_BYTES_OUT(MetricScope.BROKER, 7),
    ALL_TOPIC_PRODUCE_REQUEST_RATE(MetricScope.BROKER, 8),
    ALL_TOPIC_FETCH_REQUEST_RATE(MetricScope.BROKER, 9),
    ALL_TOPIC_MESSAGES_IN_PER_SEC(MetricScope.BROKER, 10),
    TOPIC_REPLICATION_BYTES_IN(MetricScope.TOPIC, 11),
    TOPIC_REPLICATION_BYTES_OUT(MetricScope.TOPIC, 12),
    TOPIC_PRODUCE_REQUEST_RATE(MetricScope.TOPIC, 13),
    TOPIC_FETCH_REQUEST_RATE(MetricScope.TOPIC, 14),
    TOPIC_MESSAGES_IN_PER_SEC(MetricScope.TOPIC, 15),
    BROKER_PRODUCE_REQUEST_RATE(MetricScope.BROKER, 16),
    BROKER_CONSUMER_FETCH_REQUEST_RATE(MetricScope.BROKER, 17),
    BROKER_FOLLOWER_FETCH_REQUEST_RATE(MetricScope.BROKER, 18),
    BROKER_DISK_CAPACITY(MetricScope.BROKER, 19),
    TOPIC_FOLLOWER_FETCH_REQUEST_RATE(MetricScope.TOPIC, 20),
    ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE(MetricScope.BROKER, 21),
    TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT(MetricScope.TOPIC, 22),
    ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT(MetricScope.BROKER, 23),
    TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE(MetricScope.TOPIC, 24),
    ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE(MetricScope.BROKER, 25);

    private static final Set<RawMetricType> BROKER_METRIC_TYPES;
    private static final List<RawMetricType> TOPIC_METRIC_TYPES;
    private final byte id;
    private final MetricScope metricScope;

    private RawMetricType(MetricScope scope, byte id) {
        this.id = id;
        this.metricScope = scope;
    }

    public byte id() {
        return this.id;
    }

    public MetricScope metricScope() {
        return this.metricScope;
    }

    public static List<RawMetricType> topicMetricTypes() {
        return TOPIC_METRIC_TYPES;
    }

    public static Set<RawMetricType> brokerMetricTypes() {
        return BROKER_METRIC_TYPES;
    }

    public static RawMetricType forId(byte id) {
        if (id < RawMetricType.values().length) {
            return RawMetricType.values()[id];
        }
        throw new IllegalArgumentException("CruiseControlMetric type " + id + " does not exist.");
    }

    private static Set<RawMetricType> buildBrokerMetricTypes() {
        HashSet<RawMetricType> buildBrokerMetricTypes = new HashSet<RawMetricType>();
        for (RawMetricType type : RawMetricType.values()) {
            if (type.metricScope() != MetricScope.BROKER) continue;
            buildBrokerMetricTypes.add(type);
        }
        return buildBrokerMetricTypes;
    }

    private static List<RawMetricType> buildMetricTypeList(MetricScope metricScope) {
        ArrayList<RawMetricType> brokerMetricTypes = new ArrayList<RawMetricType>();
        for (RawMetricType type : RawMetricType.values()) {
            if (type.metricScope() != metricScope) continue;
            brokerMetricTypes.add(type);
        }
        return brokerMetricTypes;
    }

    static {
        BROKER_METRIC_TYPES = RawMetricType.buildBrokerMetricTypes();
        TOPIC_METRIC_TYPES = RawMetricType.buildMetricTypeList(MetricScope.TOPIC);
    }

    public static enum MetricScope {
        BROKER,
        TOPIC,
        PARTITION;

    }
}

