/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;

public class Replica
implements Serializable,
Comparable<Replica> {
    private final TopicPartition tp;
    private final Load load;
    private final Utilization utilization;
    private final Broker originalBroker;
    private boolean isOriginalOffline;
    private Broker broker;
    private boolean isLeader;
    private boolean isObserver;
    private final Disk originalDisk;
    private Disk disk;
    private EnumSet<Resource> saturatedResources;

    public Replica(TopicPartition tp, Broker broker, boolean isLeader) {
        this(tp, broker, isLeader, false, null, false);
    }

    public Replica(TopicPartition tp, Broker broker, boolean isLeader, boolean isOriginalOffline, Disk disk, boolean isObserver) {
        this.tp = tp;
        this.load = new Load();
        this.originalBroker = broker;
        this.broker = broker;
        this.utilization = Utilization.from(this.load, broker.strategy());
        this.isLeader = isLeader;
        this.isOriginalOffline = isOriginalOffline;
        this.originalDisk = disk;
        this.disk = disk;
        this.isObserver = isObserver;
        this.saturatedResources = EnumSet.noneOf(Resource.class);
    }

    public void markSaturatedResource(Resource resource) {
        this.saturatedResources.add(resource);
    }

    public boolean isSaturatedForResource(Resource resource) {
        return this.saturatedResources.contains((Object)resource);
    }

    public boolean isOriginalOffline() {
        return this.isOriginalOffline || !this.originalBroker.isAlive();
    }

    public boolean isCurrentOffline() {
        return this.isOriginalOffline() && this.broker.id() == this.originalBroker.id() || !this.broker.isAlive();
    }

    public void markOriginalOffline() {
        if (this.broker.id() != this.originalBroker.id()) {
            throw new IllegalStateException("Cannot mark an immigrant replica as offline.");
        }
        this.isOriginalOffline = true;
        this.originalBroker.currentOfflineReplicas().add(this);
    }

    public TopicPartition topicPartition() {
        return this.tp;
    }

    public Load load() {
        return this.load;
    }

    public Utilization utilization() {
        return this.utilization;
    }

    public Broker originalBroker() {
        return this.originalBroker;
    }

    public Broker broker() {
        return this.broker;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public boolean isObserver() {
        return this.isObserver;
    }

    public boolean isImmigrant() {
        return this.originalBroker != this.broker;
    }

    void setBroker(Broker broker) {
        this.broker = broker;
    }

    void setDisk(Disk disk) {
        this.disk = disk;
    }

    public void setObservership(boolean isObserver) {
        this.isObserver = isObserver;
    }

    public Disk originalDisk() {
        return this.originalDisk;
    }

    public Disk disk() {
        return this.disk;
    }

    void setLeadership(boolean leader) {
        this.isLeader = leader;
    }

    void setMetricValues(AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        this.load.initializeMetricValues(aggregatedMetricValues, windows);
    }

    void makeFollower(AggregatedMetricValues leadershipLoadDelta) {
        this.load.subtractLoad(leadershipLoadDelta);
        this.setLeadership(false);
    }

    void makeLeader(AggregatedMetricValues leadershipLoadDelta) {
        this.setLeadership(true);
        this.load.addLoad(leadershipLoadDelta);
    }

    public Map<String, Object> getJsonStructureForLoad() {
        HashMap<String, Object> replicaMap = new HashMap<String, Object>();
        replicaMap.put("isLeader", this.isLeader);
        replicaMap.put("brokerid", this.broker.id());
        replicaMap.put("topic", this.tp.topic());
        replicaMap.put("partition", this.tp.partition());
        replicaMap.put("load", this.load.getJsonStructure());
        return replicaMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(String.format("<Replica isLeader=\"%s\" id=\"%d\">%n%s", this.isLeader(), this.broker.id(), this.tp).getBytes(StandardCharsets.UTF_8));
        this.load.writeTo(out);
        out.write("</Replica>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return String.format("Replica[isLeader=%s,rack=%s,broker=%d,TopicPartition=%s,origBroker=%d,isOriginalOffline=%s,isCurrentOffline=%s,isObserver=%s]", this.isLeader, this.broker.rack().id(), this.broker.id(), this.tp, this.originalBroker == null ? -1 : this.originalBroker.id(), this.isOriginalOffline(), this.isCurrentOffline(), this.isObserver());
    }

    public String shortString() {
        return String.format("Replica[broker=%d,TopicPartition=%s,origBroker=%d]", this.broker.id(), this.tp, this.originalBroker == null ? -1 : this.originalBroker.id());
    }

    @Override
    public int compareTo(Replica o) {
        boolean isR1Offline = this.isCurrentOffline();
        boolean isR2Offline = o.isCurrentOffline();
        if (isR1Offline && !isR2Offline) {
            return -1;
        }
        if (!isR1Offline && isR2Offline) {
            return 1;
        }
        if (this.tp.partition() > o.topicPartition().partition()) {
            return 1;
        }
        if (this.tp.partition() < o.topicPartition().partition()) {
            return -1;
        }
        if (this.originalBroker.id() > o.originalBroker().id()) {
            return 1;
        }
        if (this.originalBroker.id() < o.originalBroker().id()) {
            return -1;
        }
        return this.tp.topic().compareTo(o.topicPartition().topic());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replica replica = (Replica)o;
        return Objects.equals(this.tp, replica.tp) && this.originalBroker.id() == replica.originalBroker().id();
    }

    public int hashCode() {
        return Objects.hash(this.tp, this.originalBroker.id());
    }
}

