/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Objects;
import java.util.function.Function;

public class ReplicaWrapper
implements Comparable<ReplicaWrapper> {
    private final Replica replica;
    private final double score;
    private final Function<Replica, Integer> priorityFunction;

    public ReplicaWrapper(Replica replica, double score, Function<Replica, Integer> priorityFunction) {
        this.replica = replica;
        this.score = score;
        this.priorityFunction = priorityFunction;
    }

    public double score() {
        return this.score;
    }

    public Replica replica() {
        return this.replica;
    }

    public String toString() {
        return String.format("(Partition=%s,Broker=%d,Score=%f)", this.replica.topicPartition(), this.replica.broker().id(), this.score);
    }

    @Override
    public int compareTo(ReplicaWrapper o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot compare to a null object.");
        }
        int result = this.comparePriority(o.replica());
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.score(), o.score());
        if (result != 0) {
            return result;
        }
        return this.replica().compareTo(o.replica());
    }

    private int comparePriority(Replica replica) {
        if (this.priorityFunction != null) {
            int p1 = this.priorityFunction.apply(this.replica);
            int p2 = this.priorityFunction.apply(replica);
            return Integer.compare(p1, p2);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof ReplicaWrapper && ((ReplicaWrapper)obj).score() == this.score && ((ReplicaWrapper)obj).replica().equals(this.replica);
    }

    public int hashCode() {
        return Objects.hash(this.replica, this.score);
    }
}

