/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.DiskStats;
import com.linkedin.kafka.cruisecontrol.monitor.BasicStats;
import java.util.HashMap;
import java.util.Map;

public class SingleBrokerStats {
    protected static final String HOST = "Host";
    protected static final String BROKER = "Broker";
    protected static final String BROKER_STATE = "BrokerState";
    protected static final String DISK_STATE = "DiskState";
    protected final String host;
    protected final int id;
    protected final Broker.Strategy strategy;
    protected final BasicStats basicStats;
    protected final boolean isEstimated;
    protected final Map<String, DiskStats> diskStatsByLogdir;

    public SingleBrokerStats(String host, int id, Broker.Strategy strategy, double diskUtil, double cpuUtil, double leaderBytesInRate, double followerBytesInRate, double bytesOutRate, double potentialBytesOutRate, int numReplicas, int numLeaders, boolean isEstimated, double capacity, Map<String, DiskStats> diskStatsByLogdir) {
        this.host = host;
        this.id = id;
        this.strategy = strategy;
        this.basicStats = new BasicStats(diskUtil, cpuUtil, leaderBytesInRate, followerBytesInRate, bytesOutRate, potentialBytesOutRate, numReplicas, numLeaders, capacity);
        this.isEstimated = isEstimated;
        this.diskStatsByLogdir = diskStatsByLogdir;
    }

    public String host() {
        return this.host;
    }

    public Broker.Strategy strategy() {
        return this.strategy;
    }

    public int id() {
        return this.id;
    }

    public BasicStats basicStats() {
        return this.basicStats;
    }

    public Map<String, DiskStats> diskStatsByLogdir() {
        return this.diskStatsByLogdir;
    }

    public boolean isEstimated() {
        return this.isEstimated;
    }

    public double bytesIn() {
        return this.basicStats.leaderBytesInRate() + this.basicStats.followerBytesInRate();
    }

    public double bytesOut() {
        return this.basicStats.bytesOutRate();
    }

    public Map<String, Object> getJSONStructure() {
        Map<String, Object> entry = this.basicStats.getJSONStructure();
        entry.put(HOST, this.host);
        entry.put(BROKER, this.id);
        entry.put(BROKER_STATE, (Object)this.strategy);
        if (!this.diskStatsByLogdir.isEmpty()) {
            HashMap diskStates = new HashMap(this.diskStatsByLogdir.size());
            this.diskStatsByLogdir.forEach((k, v) -> diskStates.put(k, v.getJSONStructure()));
            entry.put(DISK_STATE, diskStates);
        }
        return entry;
    }
}

