/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.exception.MetricSamplingException;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricFetcher;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaBrokerMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaPartitionMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaReplicaMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerMetricSample;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionMetricSample;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaMetricSample;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SamplingFetcher
extends MetricFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(SamplingFetcher.class);
    private final MetricSampler metricSampler;
    private final MetadataClient metadataClient;
    private final KafkaReplicaMetricSampleAggregator replicaMetricSampleAggregator;
    private final KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator;
    private final KafkaBrokerMetricSampleAggregator brokerMetricSampleAggregator;
    private final Set<PartitionInfo> assignedPartitions;
    private final Set<TopicPartition> assignedTopicPartitions;
    private final long startTimeMs;
    private final long endTimeMs;
    private final boolean leaderValidation;
    private final Timer fetchTimer;
    private final Meter fetchFailureRate;

    SamplingFetcher(MetricSampler metricSampler, MetadataClient metadataClient, KafkaReplicaMetricSampleAggregator replicaMetricSampleAggregator, KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator, KafkaBrokerMetricSampleAggregator brokerMetricSampleAggregator, Set<PartitionInfo> assignedPartitions, long startTimeMs, long endTimeMs, boolean leaderValidation, Timer fetchTimer, Meter fetchFailureRate) {
        this.metricSampler = metricSampler;
        this.metadataClient = metadataClient;
        this.replicaMetricSampleAggregator = replicaMetricSampleAggregator;
        this.partitionMetricSampleAggregator = partitionMetricSampleAggregator;
        this.brokerMetricSampleAggregator = brokerMetricSampleAggregator;
        this.assignedPartitions = assignedPartitions;
        this.startTimeMs = startTimeMs;
        this.endTimeMs = endTimeMs;
        this.leaderValidation = leaderValidation;
        this.fetchTimer = fetchTimer;
        this.fetchFailureRate = fetchFailureRate;
        this.assignedTopicPartitions = assignedPartitions.stream().map(this::topicPartition).collect(Collectors.toSet());
    }

    private TopicPartition topicPartition(PartitionInfo partitionInfo) {
        return new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
    }

    @Override
    protected void fetchMetricsForAssignedPartitions() throws MetricSamplingException {
        TimerContext ctx = this.fetchTimer.time();
        try {
            this.fetchSamples();
        }
        catch (Exception e) {
            this.fetchFailureRate.mark();
            throw e;
        }
        finally {
            ctx.stop();
        }
    }

    private void fetchSamples() throws MetricSamplingException {
        MetricSampler.Samples samples = this.metricSampler.getSamples(this.metadataClient.cluster(), this.assignedPartitions, this.startTimeMs, this.endTimeMs);
        if (samples == null) {
            samples = MetricSampler.EMPTY_SAMPLES;
        }
        this.addReplicaSamples(samples.replicaMetricSamples());
        this.addPartitionSamples(samples.partitionMetricSamples());
        this.addBrokerMetricSamples(samples.brokerMetricSamples());
    }

    void addReplicaSamples(Set<ReplicaMetricSample> replicaMetricSamples) {
        int returnedReplicas = 0;
        if (replicaMetricSamples != null) {
            int discarded = 0;
            Iterator<ReplicaMetricSample> iter = replicaMetricSamples.iterator();
            while (iter.hasNext()) {
                ReplicaMetricSample replicaMetricSample = iter.next();
                PartitionInfo tp = ((ReplicaEntity)replicaMetricSample.entity()).tp();
                if (this.assignedTopicPartitions.contains(this.topicPartition(tp))) {
                    replicaMetricSample.close(this.endTimeMs);
                    if (this.replicaMetricSampleAggregator.addSample(replicaMetricSample)) {
                        LOG.trace("Enqueued replica metric sample {}", (Object)replicaMetricSample);
                    } else {
                        iter.remove();
                        ++discarded;
                        LOG.debug("Failed to add replica metric sample {}", (Object)replicaMetricSample);
                    }
                    ++returnedReplicas;
                    continue;
                }
                LOG.warn("Collected replica metric sample for partition {} which is not an assigned partition. The metric sample will be ignored.", (Object)tp);
            }
            LOG.info("Collected {} ({} discarded) replica metric samples for {} replicas. Total partition assigned: {}.", new Object[]{replicaMetricSamples.size(), discarded, returnedReplicas, this.assignedTopicPartitions.size()});
        } else {
            LOG.warn("Failed to collect replica metric samples for {} assigned partitions.", (Object)this.assignedTopicPartitions.size());
        }
    }

    private void addPartitionSamples(Set<PartitionMetricSample> partitionMetricSamples) {
        int returnedPartitions = 0;
        if (partitionMetricSamples != null) {
            int discarded = 0;
            Iterator<PartitionMetricSample> iter = partitionMetricSamples.iterator();
            while (iter.hasNext()) {
                PartitionMetricSample partitionMetricSample = iter.next();
                TopicPartition tp = ((PartitionEntity)partitionMetricSample.entity()).tp();
                if (this.assignedTopicPartitions.contains(tp)) {
                    partitionMetricSample.open(this.startTimeMs);
                    partitionMetricSample.close(this.endTimeMs);
                    if (this.partitionMetricSampleAggregator.addSample(partitionMetricSample, this.leaderValidation)) {
                        LOG.trace("Enqueued partition metric sample {}", (Object)partitionMetricSample);
                    } else {
                        iter.remove();
                        ++discarded;
                        LOG.debug("Failed to add partition metric sample {}", (Object)partitionMetricSample);
                    }
                    ++returnedPartitions;
                    continue;
                }
                LOG.warn("Collected partition metric sample for partition {} which is not an assigned partition. The metric sample will be ignored.", (Object)tp);
            }
            LOG.debug("Collected {} ({} discarded) partition metric samples for {} partitions. Total partition assigned: {}.", new Object[]{partitionMetricSamples.size(), discarded, returnedPartitions, this.assignedTopicPartitions.size()});
        } else {
            LOG.warn("Failed to collect partition metric samples for {} assigned partitions", (Object)this.assignedTopicPartitions.size());
        }
    }

    private void addBrokerMetricSamples(Set<BrokerMetricSample> brokerMetricSamples) {
        HashSet<Integer> returnedBrokerIds = new HashSet<Integer>();
        if (brokerMetricSamples != null) {
            int discarded = 0;
            Iterator<BrokerMetricSample> iter = brokerMetricSamples.iterator();
            while (iter.hasNext()) {
                BrokerMetricSample brokerMetricSample = iter.next();
                brokerMetricSample.open(this.startTimeMs);
                brokerMetricSample.close(this.endTimeMs);
                if (this.brokerMetricSampleAggregator.addSample(brokerMetricSample)) {
                    LOG.trace("Enqueued broker metric sample {}", (Object)brokerMetricSample);
                } else {
                    iter.remove();
                    ++discarded;
                    LOG.trace("Failed to add broker metric sample {}", (Object)brokerMetricSample);
                }
                returnedBrokerIds.add(brokerMetricSample.brokerId());
            }
            LOG.debug("Collected {} ({} discarded) broker metric samples for {} brokers.", new Object[]{brokerMetricSamples.size(), discarded, returnedBrokerIds.size()});
        } else {
            LOG.warn("Failed to collect broker metrics samples.");
        }
    }
}

