/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.task;

import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricFetcherManager;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SamplingTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SamplingTask.class);
    private final long samplingIntervalMs;
    private final Time time;
    private final MetadataClient metadataClient;
    private final LoadMonitorTaskRunner loadMonitorTaskRunner;
    private final MetricFetcherManager metricFetcherManager;
    private long lastSamplingPeriodEndTimeMs;

    SamplingTask(long samplingIntervalMs, MetadataClient metadataClient, LoadMonitorTaskRunner loadMonitorTaskRunner, MetricFetcherManager metricFetcherManager, Time time) {
        this.samplingIntervalMs = samplingIntervalMs;
        this.time = time;
        this.metadataClient = metadataClient;
        this.loadMonitorTaskRunner = loadMonitorTaskRunner;
        this.metricFetcherManager = metricFetcherManager;
        this.lastSamplingPeriodEndTimeMs = time.milliseconds() - samplingIntervalMs;
    }

    @Override
    public void run() {
        long now = this.time.milliseconds();
        if (!this.loadMonitorTaskRunner.awaitingPauseSampling() && this.loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.SAMPLING)) {
            long samplingPeriodEndMs = now;
            try {
                boolean hasSamplingError;
                long deadline = this.time.milliseconds() + this.samplingIntervalMs;
                do {
                    this.metadataClient.maybeRefreshMetadata();
                    samplingPeriodEndMs = this.time.milliseconds();
                    hasSamplingError = this.metricFetcherManager.fetchPartitionMetricSamples(this.lastSamplingPeriodEndTimeMs, samplingPeriodEndMs, deadline - now);
                    if (!hasSamplingError) {
                        this.lastSamplingPeriodEndTimeMs = samplingPeriodEndMs;
                    }
                    if ((now = this.time.milliseconds()) <= deadline) continue;
                    throw new TimeoutException();
                } while (hasSamplingError);
            }
            catch (TimeoutException e) {
                LOG.warn("Sampling did not finish in {} ms, skipping this sampling interval.", (Object)this.samplingIntervalMs);
                this.lastSamplingPeriodEndTimeMs = samplingPeriodEndMs;
            }
            catch (Throwable t) {
                LOG.error("Uncaught exception in sampling", t);
                throw t;
            }
            finally {
                this.loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.SAMPLING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING);
            }
        } else {
            String reason = this.loadMonitorTaskRunner.reasonOfLatestPauseOrResume();
            LOG.info("Skip sampling because the load monitor is in {} state{}.", (Object)this.loadMonitorTaskRunner.state(), (Object)String.format(reason == null ? "" : " due to %s.", reason));
            this.lastSamplingPeriodEndTimeMs = now - this.samplingIntervalMs;
        }
    }
}

