/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.statemachine;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.statemachine.Task;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachineProcessor.class);
    private static final int TASK_POLL_SECONDS = 10;
    private volatile ExecutorService executor;
    private final BlockingQueue<Task> taskQueue = new LinkedBlockingQueue<Task>();
    private volatile boolean shutdownRequested = false;

    public void init() {
        if (this.executor != null) {
            throw new RuntimeException("Executor is already initialized.");
        }
        KafkaCruiseControlThreadFactory threadFactory = new KafkaCruiseControlThreadFactory("StateMachineProcessor", true, LOG, Optional.empty());
        this.executor = Executors.newFixedThreadPool(2, threadFactory);
    }

    public void startUp() {
        if (this.shutdownRequested) {
            throw new RuntimeException("StateMachineProcessor already shutdown. Can't start it back up.");
        }
        this.executor.submit(this::processTasks);
    }

    public void shutdown() {
        if (this.shutdownRequested) {
            throw new RuntimeException("StateMachineProcessor getting shut down or is already shut down.");
        }
        this.shutdownRequested = true;
        this.taskQueue.add(ShutdownTask.SHUTDOWN_TASK);
        KafkaCruiseControlUtils.executeSilently(this.executor, ExecutorService::shutdown);
    }

    public String handleTask(Task task) {
        if (this.shutdownRequested) {
            throw new RuntimeException("StateMachineProcessor already shutdown. Can't execute task: " + task);
        }
        this.taskQueue.add(task);
        return task.taskId();
    }

    private void processTasks() {
        do {
            try {
                Task task = this.taskQueue.poll(10L, TimeUnit.SECONDS);
                if (task == ShutdownTask.SHUTDOWN_TASK) {
                    LOG.info("Shutting down StateMachineProcessor event loop.");
                    return;
                }
                if (task == null) continue;
                LOG.info("Starting to process task ({}) with id: {}", (Object)task.getClass().getSimpleName(), (Object)task.taskId());
                this.executor.submit(task);
            }
            catch (InterruptedException e) {
                LOG.info("State machine processing thread was interrupted. Shutting down.");
                LOG.debug("Sate machine thread interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        } while (!this.shutdownRequested && !Thread.currentThread().isInterrupted());
    }

    private static class ShutdownTask
    implements Task {
        static final ShutdownTask SHUTDOWN_TASK = new ShutdownTask();

        private ShutdownTask() {
        }

        @Override
        public String taskId() {
            return "ShutdownTask";
        }
    }
}

