/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import io.confluent.cruisecontrol.analyzer.history.GoalOptimizationHistoryListener;
import io.confluent.cruisecontrol.analyzer.history.SuspendedTopicPartition;
import io.confluent.cruisecontrol.analyzer.history.TopicPartitionMovement;
import io.confluent.databalancer.utils.TableGenerator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GoalOptimizationLogger {
    private static final TableGenerator DEFAULT_TABLE_GENERATOR = new TableGenerator();
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(GoalOptimizationLogger.class);
    private static final List<String> HEADERS_LIST = Arrays.asList("TIMESTAMP", "TOPIC", "PARTITION", "BALANCE_EPOCH", "SRC", "DST", "GOAL", "REASON");
    private final TableGenerator tableGenerator;
    private final Logger log;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private long epoch = 0L;
    @GuardedBy(value="lock")
    private final Map<Long, Map<TopicPartition, SortedSet<TopicPartitionMovement>>> topicPartitionMovementsByEpoch = new HashMap<Long, Map<TopicPartition, SortedSet<TopicPartitionMovement>>>();

    public GoalOptimizationLogger() {
        this(DEFAULT_TABLE_GENERATOR, DEFAULT_LOGGER);
    }

    GoalOptimizationLogger(TableGenerator tableGenerator, Logger log) {
        this.tableGenerator = tableGenerator;
        this.log = log;
    }

    public GoalOptimizationHistoryListener<TopicPartitionMovement> topicPartitionMovementListener() {
        return new GoalOptimizationHistoryListener<TopicPartitionMovement>(){

            @Override
            public void onNewHistory(TopicPartitionMovement topicPartitionMovement) {
                GoalOptimizationLogger.this.lock.writeLock().lock();
                try {
                    this.addOrRemoveTopicPartitionMovement(topicPartitionMovement, Operation.ADD);
                }
                finally {
                    GoalOptimizationLogger.this.lock.writeLock().unlock();
                }
            }

            @Override
            public void onExpiredHistory(TopicPartitionMovement topicPartitionMovement) {
                GoalOptimizationLogger.this.lock.writeLock().lock();
                try {
                    this.addOrRemoveTopicPartitionMovement(topicPartitionMovement, Operation.REMOVE);
                }
                finally {
                    GoalOptimizationLogger.this.lock.writeLock().unlock();
                }
            }

            private void addOrRemoveTopicPartitionMovement(TopicPartitionMovement topicPartitionMovement, Operation operation) {
                long tpEpoch = topicPartitionMovement.epoch();
                TopicPartition tp = topicPartitionMovement.topicPartition();
                if (GoalOptimizationLogger.this.epoch <= tpEpoch) {
                    SortedSet topicPartitionMovements = GoalOptimizationLogger.this.topicPartitionMovements(tpEpoch, tp);
                    switch (operation) {
                        case ADD: {
                            topicPartitionMovements.add(topicPartitionMovement);
                            break;
                        }
                        case REMOVE: {
                            topicPartitionMovements.remove(topicPartitionMovement);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Only ADD and REMOVE are the valid Operations");
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdatedEpoch(long newEpoch) {
                GoalOptimizationLogger.this.lock.writeLock().lock();
                try {
                    if (GoalOptimizationLogger.this.epoch < newEpoch) {
                        long oldEpoch = GoalOptimizationLogger.this.epoch;
                        GoalOptimizationLogger.this.epoch = newEpoch;
                        GoalOptimizationLogger.this.topicPartitionMovementsByEpoch.remove(oldEpoch);
                    }
                }
                finally {
                    GoalOptimizationLogger.this.lock.writeLock().unlock();
                }
            }
        };
    }

    public GoalOptimizationHistoryListener<SuspendedTopicPartition> suspendedTopicPartitionListener() {
        return new GoalOptimizationHistoryListener<SuspendedTopicPartition>(){

            @Override
            public void onNewHistory(SuspendedTopicPartition suspendedTopicPartition) {
                long tpEpoch = suspendedTopicPartition.epoch();
                TopicPartition tp = suspendedTopicPartition.topicPartition();
                Optional topicPartitionMovementsOpt = GoalOptimizationLogger.this.maybeGetTopicPartitionMovement(tpEpoch, tp);
                topicPartitionMovementsOpt.ifPresent(topicPartitionMovements -> {
                    long remainingSuspensionPeriod = suspendedTopicPartition.untilDeadline(TimeUnit.SECONDS);
                    GoalOptimizationLogger.this.log.info("Topic Partition {} is suspended for movement due to excessive amount of repeated movements since last successful self-healing/broker addition/broker removal. Remaining suspension period: {} seconds", (Object)tp, (Object)remainingSuspensionPeriod);
                    if (GoalOptimizationLogger.this.log.isDebugEnabled()) {
                        GoalOptimizationLogger.this.tableGenerator.generateTable(HEADERS_LIST, GoalOptimizationLogger.this.topicPartitionMovementsRows(topicPartitionMovements)).ifPresent(arg_0 -> ((Logger)GoalOptimizationLogger.this.log).debug(arg_0));
                    }
                });
            }

            @Override
            public void onExpiredHistory(SuspendedTopicPartition suspendedTopicPartition) {
            }

            @Override
            public void onUpdatedEpoch(long newEpoch) {
            }
        };
    }

    private List<List<String>> topicPartitionMovementsRows(Collection<TopicPartitionMovement> topicPartitionMovements) {
        ArrayList rows = new ArrayList();
        for (TopicPartitionMovement tpm : topicPartitionMovements) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(Instant.ofEpochMilli(tpm.timestampMs()).toString());
            row.add(tpm.topicPartition().topic());
            row.add(String.valueOf(tpm.topicPartition().partition()));
            row.add(String.valueOf(tpm.epoch()));
            row.add(String.valueOf(tpm.sourceBroker()));
            row.add(String.valueOf(tpm.destinationBroker()));
            row.add(tpm.proposingGoal().getSimpleName());
            row.add(tpm.movementReason());
            rows.add(Collections.unmodifiableList(row));
        }
        return Collections.unmodifiableList(rows);
    }

    private SortedSet<TopicPartitionMovement> topicPartitionMovements(long epoch, TopicPartition tp) {
        Map topicPartitionMovementsByTopicPartition = this.topicPartitionMovementsByEpoch.computeIfAbsent(epoch, e -> new HashMap());
        return topicPartitionMovementsByTopicPartition.computeIfAbsent(tp, t -> new TreeSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<SortedSet<TopicPartitionMovement>> maybeGetTopicPartitionMovement(long tpEpoch, TopicPartition tp) {
        this.lock.readLock().lock();
        try {
            if (this.epoch <= tpEpoch) {
                Optional<SortedSet<TopicPartitionMovement>> optional = Optional.ofNullable(this.topicPartitionMovementsByEpoch.get(tpEpoch)).map(topicPartitionMovementMap -> (SortedSet)topicPartitionMovementMap.get(tp)).map(TreeSet::new);
                return optional;
            }
            Optional<SortedSet<TopicPartitionMovement>> optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<SortedSet<TopicPartitionMovement>> maybeGetTopicPartitionMovementFromEpoch(long epoch, TopicPartition tp) {
        this.lock.readLock().lock();
        try {
            Optional<SortedSet<TopicPartitionMovement>> optional = Optional.ofNullable(this.topicPartitionMovementsByEpoch.get(epoch)).map(topicPartitionMovementMap -> (SortedSet)topicPartitionMovementMap.get(tp)).map(TreeSet::new);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    long epoch() {
        this.lock.readLock().lock();
        try {
            long l = this.epoch;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void epoch(long newEpoch) {
        this.lock.writeLock().lock();
        try {
            this.epoch = newEpoch;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static enum Operation {
        ADD,
        REMOVE;

    }
}

