/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.crn;

import com.google.common.base.CaseFormat;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnAuthority;
import io.confluent.crn.CrnAuthorityConfig;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.crn.ScopedResourcePattern;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.Utils;

public class ConfluentServerCrnAuthority
implements CrnAuthority,
Configurable {
    public static final String ORGANIZATION_TYPE = "organization";
    public static final String ENVIRONMENT_TYPE = "environment";
    public static final String CLOUD_CLUSTER_TYPE = "cloud-cluster";
    public static final String KAFKA_CLUSTER_TYPE = "kafka";
    public static final String KSQL_CLUSTER_TYPE = "ksql";
    public static final String CONNECT_CLUSTER_TYPE = "connect";
    public static final String SCHEMA_REGISTRY_CLUSTER_TYPE = "schema-registry";
    public static final String IDENTITY_PROVIDER_TYPE = "identity-provider";
    public static final String FLINK_CLUSTER_TYPE = "flink";
    public static final String NETWORK_TYPE = "network";
    public static final String KAFKA_CLUSTER_KEY = "kafka-cluster";
    public static final String KSQL_CLUSTER_KEY = "ksql-cluster";
    public static final String CONNECT_CLUSTER_KEY = "connect-cluster";
    public static final String SCHEMA_REGISTRY_CLUSTER_KEY = "schema-registry-cluster";
    public static final String IDENTITY_PROVIDER_KEY = "identity-provider";
    public static final String FLINK_CLUSTER_KEY = "flink-cluster";
    public static final String ORGANIZATION_RESOURCE_TYPE = "Organization";
    public static final String ENVIRONMENT_RESOURCE_TYPE = "Environment";
    public static final String CLOUD_CLUSTER_RESOURCE_TYPE = "CloudCluster";
    public static final String KAFKA_CLUSTER_RESOURCE_TYPE = "Cluster";
    public static final String KSQL_CLUSTER_RESOURCE_TYPE = "KsqlCluster";
    public static final String FLINK_CLUSTER_RESOURCE_TYPE = "FlinkCluster";
    public static final String NETWORK_RESOURCE_TYPE = "Network";
    public static final String CONNECT_CLUSTER_RESOURCE_TYPE = "ConnectCluster";
    public static final String SCHEMA_REGISTRY_RESOURCE_TYPE = "SchemaRegistry";
    public static final String IDENTITY_PROVIDER_RESOURCE_TYPE = "IdentityProvider";
    public static final Set<String> SCOPE_RESOURCE_TYPES = Utils.mkSet((Object[])new String[]{"Organization", "Environment", "CloudCluster", "Cluster", "KsqlCluster", "ConnectCluster", "SchemaRegistry", "IdentityProvider", "FlinkCluster", "Network"});
    public static final Map<String, String> SCOPE_KEY_BY_TYPE = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"organization", (Object)"organization"), Utils.mkEntry((Object)"environment", (Object)"environment"), Utils.mkEntry((Object)"cloud-cluster", (Object)"cloud-cluster"), Utils.mkEntry((Object)"kafka", (Object)"kafka-cluster"), Utils.mkEntry((Object)"ksql", (Object)"ksql-cluster"), Utils.mkEntry((Object)"connect", (Object)"connect-cluster"), Utils.mkEntry((Object)"schema-registry", (Object)"schema-registry-cluster"), Utils.mkEntry((Object)"identity-provider", (Object)"identity-provider"), Utils.mkEntry((Object)"flink", (Object)"flink-cluster"), Utils.mkEntry((Object)"network", (Object)"network")});
    public static final Map<String, String> CLUSTER_TYPE_BY_KEY = SCOPE_KEY_BY_TYPE.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    public static final Map<String, String> SCOPE_RESOURCE_TYPE_BY_TYPE = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"organization", (Object)"Organization"), Utils.mkEntry((Object)"environment", (Object)"Environment"), Utils.mkEntry((Object)"cloud-cluster", (Object)"CloudCluster"), Utils.mkEntry((Object)"kafka", (Object)"Cluster"), Utils.mkEntry((Object)"ksql", (Object)"KsqlCluster"), Utils.mkEntry((Object)"connect", (Object)"ConnectCluster"), Utils.mkEntry((Object)"schema-registry", (Object)"SchemaRegistry"), Utils.mkEntry((Object)"identity-provider", (Object)"IdentityProvider"), Utils.mkEntry((Object)"flink", (Object)"FlinkCluster"), Utils.mkEntry((Object)"network", (Object)"Network")});
    private String authorityName;
    private int cacheCapacity;
    private final Map<String, Result<ConfluentResourceName, CrnSyntaxException>> crnCacheByString;
    private final Map<ScopedResourcePattern, Result<ConfluentResourceName, CrnSyntaxException>> crnCacheByScopedResourcePattern;

    public ConfluentServerCrnAuthority(String authorityName, int initialCacheCapacity) {
        this.authorityName = authorityName;
        this.cacheCapacity = initialCacheCapacity;
        this.crnCacheByString = Collections.synchronizedMap(new LinkedHashMap<String, Result<ConfluentResourceName, CrnSyntaxException>>(this.cacheCapacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > ConfluentServerCrnAuthority.this.cacheCapacity;
            }
        });
        this.crnCacheByScopedResourcePattern = Collections.synchronizedMap(new LinkedHashMap<ScopedResourcePattern, Result<ConfluentResourceName, CrnSyntaxException>>(this.cacheCapacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > ConfluentServerCrnAuthority.this.cacheCapacity;
            }
        });
    }

    public ConfluentServerCrnAuthority() {
        this(null, 10000);
    }

    private String toCrnResourceType(String rbacResourceName) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, rbacResourceName);
    }

    private String toPatternResourceType(String crnResourceName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, crnResourceName);
    }

    public String name() {
        return this.authorityName;
    }

    protected String resolvePathElement(ConfluentResourceName.Element element) throws CrnSyntaxException {
        return element.encodedResourceName();
    }

    public ScopedResourcePattern resolveScopePattern(ConfluentResourceName crn) throws CrnSyntaxException {
        ResourcePattern resourcePattern = null;
        Scope.Builder scopeBuilder = new Scope.Builder(new String[0]);
        if (!this.authorityName.equals(crn.authority())) {
            throw new CrnSyntaxException(crn.toString(), "Wrong authority. Expected: " + this.authorityName);
        }
        List elements = crn.elements();
        boolean lastElementIsScope = false;
        block20: for (ConfluentResourceName.Element e : elements) {
            PatternType patternType;
            String type;
            switch (type = e.resourceType()) {
                case "organization": 
                case "environment": 
                case "cloud-cluster": 
                case "identity-provider": {
                    scopeBuilder.addPath(this.resolvePathElement(e));
                    lastElementIsScope = true;
                    continue block20;
                }
                case "kafka": 
                case "ksql": 
                case "connect": 
                case "schema-registry": 
                case "flink": 
                case "network": {
                    try {
                        scopeBuilder.withCluster(SCOPE_KEY_BY_TYPE.get(type), e.encodedResourceName());
                    }
                    catch (IllegalArgumentException exception) {
                        throw new CrnSyntaxException(crn.toString(), e.toString());
                    }
                    lastElementIsScope = true;
                    continue block20;
                }
            }
            if (resourcePattern != null) {
                throw new CrnSyntaxException(crn.toString(), String.format("Found multiple resources: %s=%s and %s=%s", resourcePattern.resourceType(), resourcePattern.name(), e.resourceType(), e.encodedResourceName()));
            }
            String resourceName = e.encodedResourceName();
            if (resourceName.equals("*")) {
                patternType = PatternType.ANY;
                resourceName = "";
            } else if (resourceName.endsWith("*")) {
                patternType = PatternType.PREFIXED;
                resourceName = resourceName.substring(0, resourceName.length() - 1);
            } else {
                patternType = PatternType.LITERAL;
            }
            try {
                resourceName = URLDecoder.decode(resourceName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            resourcePattern = new ResourcePattern(this.toPatternResourceType(e.resourceType()), resourceName, patternType);
            lastElementIsScope = false;
        }
        if (lastElementIsScope) {
            ConfluentResourceName.Element lastCluster = (ConfluentResourceName.Element)elements.get(elements.size() - 1);
            String type = lastCluster.resourceType();
            resourcePattern = new ResourcePattern(SCOPE_RESOURCE_TYPE_BY_TYPE.get(type), SCOPE_KEY_BY_TYPE.get(type), PatternType.LITERAL);
        }
        return new ScopedResourcePattern(scopeBuilder.build(), resourcePattern);
    }

    protected void parsePathElements(List<String> path, ConfluentResourceName.Builder builder) throws CrnSyntaxException {
        for (int i = 0; i < path.size() - 1; ++i) {
            builder.addElement(ORGANIZATION_TYPE, path.get(i));
        }
        if (path.size() > 0) {
            builder.addElement(ENVIRONMENT_TYPE, path.get(path.size() - 1));
        }
    }

    private ConfluentResourceName uncachedCanonicalCrn(Scope scope, ResourcePattern resourcePattern) throws CrnSyntaxException {
        try {
            ConfluentResourceName.Builder builder = ConfluentResourceName.newBuilder();
            builder.setAuthority(this.authorityName);
            this.parsePathElements(scope.path(), builder);
            if (!scope.clusters().isEmpty()) {
                this.addClusters(builder, scope);
            }
            if (resourcePattern != null) {
                this.addResource(builder, resourcePattern);
            }
            return builder.build();
        }
        catch (CrnSyntaxException e) {
            throw new CrnSyntaxException("Syntax exception while creating CRN for Scope: " + scope + " resourcePattern: " + resourcePattern, Collections.singleton(e));
        }
    }

    protected void addClusters(ConfluentResourceName.Builder builder, Scope scope) throws CrnSyntaxException {
        Map clusters = scope.clusters();
        if (!clusters.containsKey(KAFKA_CLUSTER_KEY)) {
            throw new CrnSyntaxException("", "Kafka cluster must be present");
        }
        builder.addElement(KAFKA_CLUSTER_TYPE, (String)clusters.get(KAFKA_CLUSTER_KEY));
        ArrayList exceptions = new ArrayList();
        clusters.entrySet().stream().filter(e -> !KAFKA_CLUSTER_KEY.equals(e.getKey())).sorted(Map.Entry.comparingByKey()).forEach(e -> {
            try {
                String clusterType = CLUSTER_TYPE_BY_KEY.get(e.getKey());
                if (clusterType != null) {
                    builder.addElement(clusterType, (String)e.getValue());
                } else {
                    exceptions.add(new CrnSyntaxException((String)e.getKey(), "Unknown cluster type"));
                }
            }
            catch (CrnSyntaxException exception) {
                exceptions.add(exception);
            }
        });
        if (!exceptions.isEmpty()) {
            throw new CrnSyntaxException("", exceptions);
        }
    }

    protected void addResource(ConfluentResourceName.Builder builder, ResourcePattern resourcePattern) throws CrnSyntaxException {
        if (resourcePattern != null && !SCOPE_RESOURCE_TYPES.contains(resourcePattern.resourceType().name())) {
            String resourceType = this.toCrnResourceType(resourcePattern.resourceType().name());
            String resourceName = resourcePattern.name();
            if (resourcePattern.patternType() == PatternType.ANY) {
                builder.addElementWithWildcard(resourceType, "");
            } else if (resourcePattern.patternType() == PatternType.PREFIXED) {
                builder.addElementWithWildcard(resourceType, resourceName);
            } else {
                builder.addElement(resourceType, resourceName);
            }
        }
    }

    public ConfluentResourceName canonicalCrn(Scope scope, ResourcePattern resourcePattern) throws CrnSyntaxException {
        ScopedResourcePattern scopedResourcePattern = new ScopedResourcePattern(scope, resourcePattern);
        Result result = this.crnCacheByScopedResourcePattern.computeIfAbsent(scopedResourcePattern, srp -> {
            try {
                return new Result(this.uncachedCanonicalCrn(srp.scope(), srp.resourcePattern()));
            }
            catch (CrnSyntaxException e) {
                return new Result(e);
            }
        });
        return (ConfluentResourceName)result.get();
    }

    public ConfluentResourceName canonicalCrn(Scope scope) throws CrnSyntaxException {
        return this.canonicalCrn(scope, null);
    }

    public ConfluentResourceName canonicalCrn(String crnString) throws CrnSyntaxException {
        Result result = this.crnCacheByString.computeIfAbsent(crnString, s -> {
            try {
                ScopedResourcePattern resolved = this.resolveScopePattern(ConfluentResourceName.fromString((String)crnString));
                return new Result(this.canonicalCrn(resolved.scope(), resolved.resourcePattern()));
            }
            catch (CrnSyntaxException e) {
                return new Result(e);
            }
        });
        return (ConfluentResourceName)result.get();
    }

    public ConfluentResourceName canonicalCrn(ConfluentResourceName crn) throws CrnSyntaxException {
        ScopedResourcePattern resolved = this.resolveScopePattern(crn);
        return this.canonicalCrn(resolved.scope(), resolved.resourcePattern());
    }

    public boolean areEquivalent(ConfluentResourceName a, ConfluentResourceName b) throws CrnSyntaxException {
        return this.canonicalCrn(a).equals((Object)this.canonicalCrn(b));
    }

    public void configure(Map<String, ?> configs) {
        CrnAuthorityConfig config = new CrnAuthorityConfig(configs);
        this.authorityName = config.getString("confluent.authorizer.authority.name");
        this.cacheCapacity = config.getInt("confluent.authorizer.authority.cache.entries");
    }

    private static class Result<T, E extends Exception> {
        final T value;
        final E exception;

        public Result(T value) {
            this.value = value;
            this.exception = null;
        }

        public Result(E exception) {
            this.value = null;
            this.exception = exception;
        }

        public T get() throws E {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
    }
}

