/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.projectnessie.cel.common.Location;
import org.projectnessie.cel.common.Source;

final class SourceImpl
implements Source {
    private final String content;
    private final String description;
    private final List<Integer> lineOffsets;
    private final Map<Long, Integer> idOffsets;

    SourceImpl(String content, String description, List<Integer> lineOffsets) {
        this(content, description, lineOffsets, new HashMap<Long, Integer>());
    }

    SourceImpl(String content, String description, List<Integer> lineOffsets, Map<Long, Integer> idOffsets) {
        this.content = content;
        this.description = description;
        this.lineOffsets = lineOffsets;
        this.idOffsets = idOffsets;
    }

    @Override
    public String content() {
        return this.content;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public List<Integer> lineOffsets() {
        return this.lineOffsets;
    }

    @Override
    public int locationOffset(Location location) {
        return this.findLineOffset(location.line()) + location.column();
    }

    @Override
    public Location newLocation(int line, int col) {
        return Location.newLocation(line, col);
    }

    @Override
    public Location offsetLocation(int offset) {
        int lo;
        int line = 1;
        Iterator<Integer> iterator = this.lineOffsets.iterator();
        while (iterator.hasNext() && (lo = iterator.next().intValue()) <= offset) {
            ++line;
        }
        int lineOffset = line == 1 ? 0 : this.lineOffsets.get(line - 2);
        return Location.newLocation(line, offset - lineOffset);
    }

    @Override
    public String snippet(int line) {
        int charStart = this.findLineOffset(line);
        if (charStart < 0) {
            return null;
        }
        int charEnd = this.findLineOffset(line + 1);
        if (charEnd >= 0) {
            return this.content.substring(charStart, charEnd - 1);
        }
        return this.content.substring(charStart);
    }

    private int findLineOffset(int line) {
        if (line == 1) {
            return 0;
        }
        if (line > 1 && line <= this.lineOffsets.size()) {
            return this.lineOffsets.get(line - 2);
        }
        return -1;
    }
}

