/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.security.authentication.AuthenticationConfig;
import io.confluent.security.authentication.Authenticator;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.oauthbearer.AlgorithmWhitelist;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticator;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.authentication.oauthbearer.JwtPrincipal;
import io.confluent.security.authentication.oauthbearer.SignatureAlgorithm;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
public final class JwtAuthenticationConfig
extends AuthenticationConfig<BearerCredential, JwtPrincipal> {
    public static final String CONFLUENT_ISSUER = "Confluent";
    private final List<JwtIssuer> issuers;
    private final Set<SignatureAlgorithm> algorithmWhitelist;

    private JwtAuthenticationConfig(List<JwtIssuer> issuers, Set<SignatureAlgorithm> algorithmWhitelist) {
        this.issuers = Collections.unmodifiableList(issuers);
        this.algorithmWhitelist = Collections.unmodifiableSet(algorithmWhitelist);
    }

    @Override
    @JsonIgnore
    public AuthenticationConfig.Kind kind() {
        return AuthenticationConfig.Kind.JWT;
    }

    @JsonProperty(value="algorithmWhitelist")
    public Set<SignatureAlgorithm> algorithmWhitelist() {
        return this.algorithmWhitelist;
    }

    @JsonProperty(value="issuers")
    public List<JwtIssuer> issuers() {
        return this.issuers;
    }

    @Override
    public Authenticator<BearerCredential, JwtPrincipal> createAuthenticator() {
        return new JwtAuthenticator(this.issuers, Collections.singletonList(new AlgorithmWhitelist(this.algorithmWhitelist)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<JwtIssuer> issuers;
        private Set<SignatureAlgorithm> algorithmWhitelist;

        private Builder() {
        }

        @JsonSetter(value="issuers", nulls=Nulls.AS_EMPTY)
        public Builder issuers(List<JwtIssuer> issuers) {
            this.issuers = issuers;
            return this;
        }

        @JsonSetter(value="algorithmWhitelist", nulls=Nulls.AS_EMPTY)
        public Builder algorithmWhitelist(Set<SignatureAlgorithm> algorithmWhitelist) {
            this.algorithmWhitelist = algorithmWhitelist;
            return this;
        }

        public JwtAuthenticationConfig build() {
            return new JwtAuthenticationConfig(this.issuers, this.algorithmWhitelist == null || this.algorithmWhitelist.isEmpty() ? DefaultWhiteList.INSTANCE : this.algorithmWhitelist);
        }
    }

    private static class DefaultWhiteList {
        private static final Set<SignatureAlgorithm> INSTANCE = new HashSet<SignatureAlgorithm>(){
            {
                this.add(SignatureAlgorithm.RS256);
                this.add(SignatureAlgorithm.ES256);
            }
        };

        private DefaultWhiteList() {
        }
    }
}

