/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.engine;

import io.confluent.security.policyapi.ConfluentPolicy;
import io.confluent.security.policyapi.PolicyRuleLoadingCache;
import io.confluent.security.policyapi.cel.TrustPolicyCelParser;
import io.confluent.security.policyapi.engine.PolicyEngine;
import io.confluent.security.policyapi.exception.PolicyEngineException;
import java.util.Map;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustPolicyEngine
implements PolicyEngine<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustPolicyEngine.class);
    public static final int CHAIN_LIMIT_DEFAULT = 32;
    public static final int NESTING_LIMIT_DEFAULT = 32;
    public static final int ARRAY_LIST_LIMIT_DEFAULT = 256;
    private final PolicyRuleLoadingCache<String> cache;
    private final Env env;

    public TrustPolicyEngine() {
        this(null, null);
    }

    public TrustPolicyEngine(PolicyRuleLoadingCache<String> cache) {
        this(null, cache);
    }

    public TrustPolicyEngine(Env env, PolicyRuleLoadingCache<String> cache) {
        this.env = env == null ? TrustPolicyCelParser.getTrustPolicyEnv() : env;
        this.cache = cache == null ? new PolicyRuleLoadingCache(this.env) : cache;
    }

    @Override
    public boolean evaluatePolicy(ConfluentPolicy<String> policy, Map<String, Object> claims) throws PolicyEngineException {
        try {
            Program program = TrustPolicyCelParser.compilePolicy(this.env, policy.condition());
            return TrustPolicyCelParser.evaluatePolicy(program, claims);
        }
        catch (Throwable t) {
            throw new PolicyEngineException("Could not evaluate rule for workload identity " + policy, t);
        }
    }

    @Override
    public void validatePolicy(String statements) throws PolicyEngineException {
        try {
            TrustPolicyCelParser.compilePolicy(this.env, statements);
        }
        catch (Exception e) {
            LOGGER.error("Could not compile statements {}: {}", (Object)statements, (Object)e);
            throw new PolicyEngineException(e);
        }
    }

    @Override
    public boolean validatePolicyEvaluation(String statements, Map<String, Object> claims) throws PolicyEngineException {
        try {
            Program program = TrustPolicyCelParser.compilePolicy(this.env, statements);
            return TrustPolicyCelParser.evaluatePolicy(program, claims);
        }
        catch (Exception e) {
            LOGGER.error("Could not evaluate rule for expression {}: {}", (Object)statements, (Object)e);
            throw new PolicyEngineException(e);
        }
    }
}

