/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schema;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufMapper;
import com.fasterxml.jackson.dataformat.protobuf.schema.FileDescriptorSet;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchemaLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public class DescriptorLoader {
    protected static final String DESCRIPTOR_PROTO = "/descriptor.proto";
    protected final ObjectReader _reader;

    public DescriptorLoader(ObjectReader reader) {
        this._reader = reader;
    }

    public static DescriptorLoader construct(ProtobufMapper mapper) throws IOException {
        return DescriptorLoader.construct(mapper, mapper.schemaLoader());
    }

    public static DescriptorLoader construct(ObjectMapper mapper, ProtobufSchemaLoader schemaLoader) throws IOException {
        ProtobufSchema schema;
        try (InputStream in = DescriptorLoader.class.getResourceAsStream(DESCRIPTOR_PROTO);){
            schema = schemaLoader.load(in, "FileDescriptorSet");
        }
        return new DescriptorLoader(mapper.readerFor(FileDescriptorSet.class).with((FormatSchema)schema));
    }

    public FileDescriptorSet load(URL src) throws IOException {
        return (FileDescriptorSet)this._reader.readValue(src);
    }

    public FileDescriptorSet load(File src) throws IOException {
        return (FileDescriptorSet)this._reader.readValue(src);
    }

    public FileDescriptorSet load(InputStream in) throws IOException {
        return (FileDescriptorSet)this._reader.readValue(in);
    }

    public FileDescriptorSet load(Reader r) throws IOException {
        return (FileDescriptorSet)this._reader.readValue(r);
    }
}

