/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.EntityFilter;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Set;
import java.util.function.Predicate;

public class ChainReplicaFilter
implements EntityFilter<Replica> {
    private Predicate<Replica> chainFilter;

    @SafeVarargs
    public ChainReplicaFilter(Predicate<Replica> ... filters) {
        for (Predicate<Replica> filter : filters) {
            this.registerFilter(filter);
        }
    }

    @Override
    public void registerFilter(Predicate<Replica> filter) {
        if (this.chainFilter == null) {
            this.chainFilter = filter;
            return;
        }
        this.chainFilter = this.chainFilter.and(filter);
    }

    @Override
    public void filterEntities(Set<Replica> replicas) {
        if (this.chainFilter == null) {
            return;
        }
        replicas.removeIf(replica -> !this.chainFilter.test((Replica)replica));
    }
}

