/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.util;

import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class HotPartitionsInfo {
    private Map<Integer, List<TopicPartition>> hotPartitionsByBroker;
    private int totalNumHotPartitions;
    private Set<Replica> saturatedReplicas;
    private double maxReplicaLoad;

    public HotPartitionsInfo(Map<Integer, List<TopicPartition>> hotPartitionsByBroker, Set<Replica> saturatedReplicas, double maxReplicaLoad) {
        this.hotPartitionsByBroker = hotPartitionsByBroker;
        this.totalNumHotPartitions = this.hotPartitionsByBroker().values().stream().mapToInt(List::size).sum();
        this.saturatedReplicas = saturatedReplicas;
        this.maxReplicaLoad = maxReplicaLoad;
    }

    public Map<Integer, List<TopicPartition>> hotPartitionsByBroker() {
        return this.hotPartitionsByBroker;
    }

    public Set<Replica> saturatedReplicas() {
        return this.saturatedReplicas;
    }

    public double maxReplicaLoad() {
        return this.maxReplicaLoad;
    }

    public int totalNumHotPartitions() {
        return this.totalNumHotPartitions;
    }
}

