/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import io.confluent.metrics.reporter.VolumeMetricsProvider;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerCapacityResolver
implements BrokerCapacityConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerCapacityResolver.class);
    public static final int DEFAULT_CAPACITY_BROKER_ID = -1;
    public static final String LOG_DIRS_CONFIG = KafkaConfig$.MODULE$.LogDirsProp();
    static final double BYTES_PER_KB = 1024.0;
    private static final Double DEFAULT_CPU_CAPACITY = 100.0;
    private static final double DISK_CAPACITY_UPDATE_THRESHOLD = 1.0;
    private static final double DISK_CAPACITY_WARN_THRESHOLD = 1.0;
    private static final Map<Resource, ResourceConfig> BROKER_RESOURCE_CONFIGS = Stream.of(new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.NW_IN, new ResourceConfig("network.in.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.PRODUCE_IN, new ResourceConfig("producer.in.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.NW_OUT, new ResourceConfig("network.out.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.CONSUME_OUT, new ResourceConfig("consumer.out.max.bytes.per.second", bps -> bps / 1024.0))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private final Map<Integer, BrokerCapacityInfo> capacitiesForBrokers = new ConcurrentHashMap<Integer, BrokerCapacityInfo>();

    @Override
    public BrokerCapacityInfo capacityForBroker(String rack, String host, int brokerId) {
        if (this.capacitiesForBrokers.isEmpty()) {
            throw new ConfigException("not configured");
        }
        if (brokerId < 0) {
            throw new IllegalArgumentException("The broker id(" + brokerId + ") should be non-negative.");
        }
        BrokerCapacityInfo capacity = this.capacitiesForBrokers.get(brokerId);
        if (capacity != null) {
            return capacity;
        }
        LOG.debug("Returning default broker capacity for broker {}", (Object)brokerId);
        return this.capacitiesForBrokers.get(-1);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        LOG.info("CruiseControl: Attempting to configure Broker Capacity from config properties");
        HashMap<Resource, Double> defaultBrokerCapacity = new HashMap<Resource, Double>();
        defaultBrokerCapacity.put(Resource.CPU, DEFAULT_CPU_CAPACITY);
        for (Map.Entry<Resource, ResourceConfig> resource : BROKER_RESOURCE_CONFIGS.entrySet()) {
            Double parsedValue;
            ResourceConfig resourceConfig = resource.getValue();
            Long configValue = (Long)configs.get(resourceConfig.configName);
            try {
                parsedValue = resourceConfig.convertConfigValue(configValue.doubleValue());
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid capacity (unparseable) " + configValue + " for capacity measure " + resourceConfig, (Object)e);
            }
            if (parsedValue < 0.0 || parsedValue == null) {
                throw new ConfigException("Negative capacity " + parsedValue + " (from " + configValue + ") is not allowed for " + resourceConfig);
            }
            defaultBrokerCapacity.put(resource.getKey(), parsedValue);
        }
        Boolean populateDefaultDiskCapacityWithLocalDisk = (Boolean)configs.get("populate.default.disk.capacity.from.local");
        if (populateDefaultDiskCapacityWithLocalDisk != null && populateDefaultDiskCapacityWithLocalDisk.booleanValue()) {
            double diskCapacityInMiB = this.diskCapacityForCurrentBrokerInMiB(configs);
            if (diskCapacityInMiB < 1.0) {
                LOG.warn("Default broker disk capacity configured to {} MB", (Object)diskCapacityInMiB);
            }
            defaultBrokerCapacity.put(Resource.DISK, diskCapacityInMiB);
        }
        this.capacitiesForBrokers.put(-1, BrokerCapacityInfo.builder().capacity(defaultBrokerCapacity).estimationInfo("default broker capacity").build());
    }

    @Override
    public void updateDiskCapacityForBroker(String rack, String host, int brokerId, double updateDiskCapacityInMiB) {
        if (brokerId < 0) {
            LOG.warn("Received disk capacity update for broker with negative id: {}, skipping update");
            return;
        }
        BrokerCapacityInfo brokerCapacity = this.capacityForBroker(rack, host, brokerId);
        double curDiskCapacity = brokerCapacity.capacity().getOrDefault((Object)Resource.DISK, 0.0);
        if (Math.abs(curDiskCapacity - updateDiskCapacityInMiB) > 1.0) {
            LOG.info("Updating disk capacity for broker {} from {} to {} mebibytes", new Object[]{brokerId, curDiskCapacity, updateDiskCapacityInMiB});
            HashMap<Resource, Double> updatedCapacity = new HashMap<Resource, Double>(brokerCapacity.capacity());
            updatedCapacity.put(Resource.DISK, updateDiskCapacityInMiB);
            this.capacitiesForBrokers.put(brokerId, BrokerCapacityInfo.builder().capacity(updatedCapacity).build());
        } else {
            LOG.debug("Skipping request to update disk capacity for broker {} from {} to {} mebibytes", new Object[]{brokerId, curDiskCapacity, updateDiskCapacityInMiB});
        }
    }

    private double diskCapacityForCurrentBrokerInMiB(Map<String, ?> configs) {
        String logDir;
        String string = logDir = configs.get(LOG_DIRS_CONFIG) instanceof String ? (String)configs.get(LOG_DIRS_CONFIG) : null;
        if (logDir == null || logDir.length() == 0) {
            throw new ConfigException("Error calculating disk capacity, invalid log dir " + logDir);
        }
        VolumeMetricsProvider volumeMetricsProvider = new VolumeMetricsProvider(0L, new String[]{logDir});
        Collection volumeInfos = volumeMetricsProvider.getMetrics().values();
        if (volumeInfos.size() > 1) {
            throw new IllegalStateException("Static disk size estimation not supported for multiple volumes");
        }
        Optional volume = volumeInfos.stream().findFirst();
        if (volume.isPresent()) {
            return (double)((VolumeMetricsProvider.VolumeInfo)volume.get()).totalBytes() / 1048576.0;
        }
        throw new ConfigException("Error calculating disk capacity, couldn't find volumes for log dir" + logDir);
    }

    private static class ResourceConfig {
        String configName;
        DoubleUnaryOperator conversionFunc;

        ResourceConfig(String configId, DoubleUnaryOperator converter) {
            this.configName = Objects.requireNonNull(configId);
            this.conversionFunc = Objects.requireNonNull(converter);
        }

        Double convertConfigValue(Double configValue) {
            return this.conversionFunc.applyAsDouble(configValue);
        }
    }
}

