/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.ProposalGenerator;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.BrokerLivenessListener;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import com.linkedin.kafka.cruisecontrol.monitor.ModelGeneration;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import io.confluent.databalancer.operation.SelfHealingStateTracker;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.RebalanceInProgressDuringPlanComputationException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalViolationDetector
implements Runnable,
BrokerLivenessListener {
    private static final Logger LOG = LoggerFactory.getLogger(GoalViolationDetector.class);
    private final KafkaCruiseControl kafkaCruiseControl;
    private final LoadMonitor loadMonitor;
    private final SelfHealingStateTracker selfHealingStateTracker;
    private final Time time;
    private final Queue<Anomaly> anomalies;
    private final Pattern excludedTopics;
    private final boolean allowCapacityEstimation;
    private final boolean excludeRecentlyRemovedBrokers;
    private final long deferGoalDetectionOnNewMembersDelayMs;
    private final double balancednessPriorityWeight;
    private final double balancednessStrictnessWeight;
    private final UpdatableSbcGoalsConfig updatableSbcGoalsConfig;
    private final OptimizationMetrics optimizationMetrics;
    private static AtomicLong resumeDetectionTimeMs;
    private ModelGeneration lastCheckedModelGeneration;
    private Map<String, Double> balancednessCostByGoal = new HashMap<String, Double>();
    private volatile double balancednessScore;

    public GoalViolationDetector(KafkaCruiseControlConfig kccConfig, LoadMonitor loadMonitor, Queue<Anomaly> anomalies, Time time, KafkaCruiseControl kafkaCruiseControl, UpdatableSbcGoalsConfig updatableSbcGoalsConfig, KafkaCruiseControl.CcStartupMode startupMode, DataBalancerMetricsRegistry metricsRegistry) {
        this.loadMonitor = loadMonitor;
        this.anomalies = anomalies;
        this.time = time;
        this.excludedTopics = Pattern.compile(kccConfig.getString("topics.excluded.from.partition.movement"));
        this.allowCapacityEstimation = kccConfig.getBoolean("anomaly.detection.allow.capacity.estimation");
        this.excludeRecentlyRemovedBrokers = kccConfig.getBoolean("goal.violation.exclude.recently.removed.brokers");
        this.deferGoalDetectionOnNewMembersDelayMs = kccConfig.getLong("goal.violation.delay.on.new.brokers.ms");
        this.kafkaCruiseControl = kafkaCruiseControl;
        this.updatableSbcGoalsConfig = updatableSbcGoalsConfig;
        this.balancednessPriorityWeight = kccConfig.getDouble("goal.balancedness.priority.weight");
        this.balancednessStrictnessWeight = kccConfig.getDouble("goal.balancedness.strictness.weight");
        this.optimizationMetrics = new OptimizationMetrics(metricsRegistry, this.getClass());
        this.balancednessScore = 100.0;
        resumeDetectionTimeMs = new AtomicLong(0L);
        if (startupMode != KafkaCruiseControl.CcStartupMode.ON_ENABLE) {
            resumeDetectionTimeMs.set(this.time.milliseconds() + this.deferGoalDetectionOnNewMembersDelayMs);
        }
        this.selfHealingStateTracker = new SelfHealingStateTracker(kccConfig);
    }

    public double balancednessScore() {
        return this.balancednessScore;
    }

    @Override
    public void notifyNewAddingBrokers(Set<Integer> newAddingBrokers) {
    }

    @Override
    public void notifyNewlyOnlineBrokers(Set<Integer> newlyOnlineBrokers) {
        if (newlyOnlineBrokers.isEmpty()) {
            return;
        }
        long nextDetectionTime = this.time.milliseconds() + this.deferGoalDetectionOnNewMembersDelayMs;
        resumeDetectionTimeMs.set(nextDetectionTime);
        LOG.info("Notified of new brokers {} - pausing goal violation detection for {}ms until {}", new Object[]{newlyOnlineBrokers, this.deferGoalDetectionOnNewMembersDelayMs, resumeDetectionTimeMs.get()});
    }

    @Override
    public void notifyDeadBrokers(Set<Integer> deadBrokers) {
    }

    boolean shouldSkipGoalViolationDetection() {
        if (this.loadMonitor.clusterModelGeneration().equals(this.lastCheckedModelGeneration)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping goal violation detection because the model generation hasn't changed. Current model generation {}", (Object)this.loadMonitor.clusterModelGeneration());
            }
            return true;
        }
        Set<Integer> brokersWithOfflineReplicas = this.loadMonitor.brokersWithOfflineReplicas(60000);
        if (!brokersWithOfflineReplicas.isEmpty()) {
            LOG.info("Skipping goal violation detection because there are dead brokers in the cluster, flawed brokers: {}", brokersWithOfflineReplicas);
            this.setBalancednessWithOfflineReplicas();
            return true;
        }
        if (this.shouldSkipGoalViolationDetectionDueToTime()) {
            LOG.info("Skipping goal violation detection due to previous new broker change");
            return true;
        }
        return AnomalyDetectorUtils.shouldSkipAnomalyDetection(this.loadMonitor, this.kafkaCruiseControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.shouldSkipGoalViolationDetection()) {
            return;
        }
        try {
            Optional<GoalViolations> goalViolationsOpt = this.detectViolations();
            if (!goalViolationsOpt.isPresent()) {
                return;
            }
            GoalViolations goalViolations = goalViolationsOpt.get();
            Map<Boolean, List<GoalViolations.GoalResult>> violatedGoalsByFixability = goalViolations.violatedGoalsByFixability();
            if (!violatedGoalsByFixability.isEmpty()) {
                LOG.info("Goal violation detector detected violated goals. (fixable: {}, unfixable: {})", violatedGoalsByFixability.get(true), violatedGoalsByFixability.get(false));
                this.anomalies.add(goalViolations);
            } else {
                LOG.info("Goal violation detector did not detect any violated goals.");
                this.kafkaCruiseControl.context().evenClusterLoadStateManager().noGoalViolationsFound();
                this.kafkaCruiseControl.clearGoalOptimizationHistory();
            }
            this.refreshBalancednessScore(violatedGoalsByFixability.values().stream().flatMap(a -> a.stream().map(g -> g.name)).collect(Collectors.toList()));
        }
        catch (RebalanceInProgressDuringPlanComputationException rebalanceInProgressDuringPlanComputationException) {
            LOG.info("Skipping goal violation detection because a reassignment was detected while computing the plan.", (Throwable)rebalanceInProgressDuringPlanComputationException);
        }
        catch (NotEnoughValidWindowsException nevwe) {
            LOG.info("Skipping goal violation detection because there are not enough valid metric windows.", (Throwable)nevwe);
        }
        catch (KafkaCruiseControlException kcce) {
            LOG.warn("Goal violation detector received exception", (Throwable)kcce);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", (Throwable)e);
        }
        finally {
            LOG.info("Goal violation detection finished.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GoalViolations> detectViolations() throws Exception {
        AutoCloseable clusterModelSemaphore = null;
        SbcGoalsConfig goalConfigSnapshot = this.updatableSbcGoalsConfig.config();
        GoalsConfig triggeringGoalsConfig = goalConfigSnapshot.effectiveTriggeringGoals();
        GoalsConfig rebalancingGoalsConfig = goalConfigSnapshot.effectiveRebalancingGoals();
        this.balancednessCostByGoal = KafkaCruiseControlUtils.balancednessCostByGoal(triggeringGoalsConfig.goals(), this.balancednessPriorityWeight, this.balancednessStrictnessWeight);
        try {
            Optional<GoalViolations> optional;
            HashMap<String, LoadMonitor.CompletenessCheck> skippedGoals = new HashMap<String, LoadMonitor.CompletenessCheck>();
            List<Goal> detectionGoals = triggeringGoalsConfig.goals();
            GoalViolations goalViolations = new GoalViolations(this.kafkaCruiseControl, this.selfHealingStateTracker, this.allowCapacityEstimation, this.excludeRecentlyRemovedBrokers, rebalancingGoalsConfig);
            long now = this.time.milliseconds();
            boolean newModelNeeded = true;
            ClusterModel clusterModel = null;
            LOG.debug("Running goal violation detection for the following goals: {}", detectionGoals);
            Set<Integer> excludedBrokersForLeadership = Collections.emptySet();
            Set<Integer> excludedBrokersForReplicaMove = this.excludeRecentlyRemovedBrokers ? ProposalGenerator.recentlyRemovedBrokers(this.kafkaCruiseControl.context()) : Collections.emptySet();
            for (Goal goal : detectionGoals) {
                LoadMonitor.CompletenessCheck completenessCheck = this.loadMonitor.meetCompletenessRequirements(goal.clusterModelCompletenessRequirements());
                if (!completenessCheck.meetsRequirements) {
                    skippedGoals.put(goal.name(), completenessCheck);
                    continue;
                }
                LOG.debug("Detecting if {} is violated.", (Object)goal.name());
                if (newModelNeeded) {
                    if (clusterModelSemaphore != null) {
                        clusterModelSemaphore.close();
                    }
                    clusterModelSemaphore = this.loadMonitor.acquireForModelGeneration(new OperationProgress());
                    clusterModel = null;
                    clusterModel = this.loadMonitor.createClusterModel(now, goal.clusterModelCompletenessRequirements(), new OperationProgress());
                    if (this.skipDueToOfflineReplicas(clusterModel)) {
                        LOG.info("Skipped goal violation detection because offline replicas were present in the cluster.");
                        Optional<GoalViolations> optional2 = Optional.empty();
                        return optional2;
                    }
                    KafkaCruiseControl.sanityCheckCapacityEstimation(this.allowCapacityEstimation, clusterModel.capacityEstimationInfoByBrokerId());
                    this.lastCheckedModelGeneration = clusterModel.generation();
                }
                newModelNeeded = this.optimizeForGoal(clusterModel, goal, goalViolations, excludedBrokersForLeadership, excludedBrokersForReplicaMove);
                LOG.debug("Goal {} was {}violated.", (Object)goal.name(), (Object)(newModelNeeded ? "" : "not "));
            }
            if (!skippedGoals.isEmpty()) {
                LOG.info("Skipped goal violation detection because load completeness requirement were not met for the following goals: {}.", skippedGoals);
                optional = Optional.empty();
                return optional;
            }
            optional = Optional.of(goalViolations);
            return optional;
        }
        finally {
            if (clusterModelSemaphore != null) {
                try {
                    clusterModelSemaphore.close();
                }
                catch (Exception e) {
                    LOG.error("Received exception when closing auto closable semaphore", (Throwable)e);
                }
            }
        }
    }

    Queue<Anomaly> anomalies() {
        return this.anomalies;
    }

    private boolean skipDueToOfflineReplicas(ClusterModel clusterModel) {
        if (!clusterModel.deadBrokers().isEmpty()) {
            LOG.info("Skipping goal violation detection due to dead brokers {}, which are reported by broker failure detector, and fixed if its self healing configuration is enabled.", clusterModel.deadBrokers());
            this.setBalancednessWithOfflineReplicas();
            return true;
        }
        if (!clusterModel.brokersWithBadDisks().isEmpty()) {
            LOG.info("Skipping goal violation detection due to brokers with bad disks {}, which are reported by disk failure detector, and fixed if its self healing configuration is enabled.", clusterModel.brokersWithBadDisks());
            this.setBalancednessWithOfflineReplicas();
            return true;
        }
        return false;
    }

    private boolean shouldSkipGoalViolationDetectionDueToTime() {
        LOG.debug("Checking goal violation skip time: current time {}, resume time {}", (Object)this.time.milliseconds(), (Object)resumeDetectionTimeMs);
        return this.time.milliseconds() < resumeDetectionTimeMs.get();
    }

    private void setBalancednessWithOfflineReplicas() {
        this.balancednessScore = 0.0;
    }

    private void refreshBalancednessScore(List<String> violatedGoals) {
        double computedBalancednessScore = 100.0;
        for (String violatedGoal : violatedGoals) {
            computedBalancednessScore -= this.balancednessCostByGoal.get(violatedGoal).doubleValue();
        }
        this.balancednessScore = computedBalancednessScore;
    }

    private Set<String> excludedTopics(ClusterModel clusterModel) {
        return clusterModel.topics().stream().filter(topic -> this.excludedTopics.matcher((CharSequence)topic).matches()).collect(Collectors.toSet());
    }

    private boolean optimizeForGoal(ClusterModel clusterModel, Goal goal, GoalViolations goalViolations, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove) {
        GoalOptimizationResult optimizeResult;
        if (clusterModel.topics().isEmpty()) {
            LOG.info("Skipping goal violation detection because the cluster model does not have any topic.");
            return false;
        }
        try {
            OptimizationOptions optimizationOptions = new OptimizationOptions.Builder().excludedTopics(this.excludedTopics(clusterModel)).excludedBrokersForLeadership(excludedBrokersForLeadership).excludedBrokersForReplicaMove(excludedBrokersForReplicaMove).triggeredByGoalViolation(true).build();
            optimizeResult = goal.optimize(clusterModel, new HashSet<Goal>(), optimizationOptions, Optional.of(this.optimizationMetrics));
        }
        catch (OptimizationFailureException ofe) {
            goalViolations.addViolation(goal.name(), false, ofe);
            return true;
        }
        if (optimizeResult.hasReplicaChange()) {
            goalViolations.addViolation(goal.name(), true);
            return true;
        }
        if (this.selfHealingStateTracker.isInProgress(goal.name())) {
            goalViolations.addViolation(goal.name(), true);
            LOG.info("Goal {} is added to the fixable violations due to being IN_PROGRESS - it hasn't completely reached its desired balancing thresholds.", (Object)goal);
            return true;
        }
        return false;
    }

    SelfHealingStateTracker selfHealingStateTracker() {
        return this.selfHealingStateTracker;
    }
}

