/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.notifier;

import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotifier;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NoopNotifier
implements AnomalyNotifier {
    private final Map<AnomalyType, Boolean> selfHealingEnabled = new ConcurrentHashMap<AnomalyType, Boolean>(AnomalyType.cachedValues().size());

    @Override
    public void configure(Map<String, ?> configs) {
        AnomalyType.cachedValues().forEach(anomalyType -> this.selfHealingEnabled.put((AnomalyType)((Object)anomalyType), false));
    }

    @Override
    public AnomalyNotificationResult onGoalViolation(GoalViolations goalViolations) {
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public AnomalyNotificationResult onBrokerFailure(BrokerFailures brokerFailures) {
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public Map<AnomalyType, Boolean> selfHealingEnabled() {
        return this.selfHealingEnabled;
    }

    @Override
    public boolean setSelfHealingFor(AnomalyType anomalyType, boolean isSelfHealingEnabled) {
        return false;
    }

    @Override
    public Map<AnomalyType, Float> selfHealingEnabledRatio() {
        HashMap<AnomalyType, Float> selfHealingEnabledRatio = new HashMap<AnomalyType, Float>(AnomalyType.cachedValues().size());
        for (AnomalyType anomalyType : AnomalyType.cachedValues()) {
            selfHealingEnabledRatio.put(anomalyType, Float.valueOf(0.0f));
        }
        return selfHealingEnabledRatio;
    }

    @Override
    public long uptimeMs(long nowMs) {
        return 0L;
    }
}

