/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskManager;
import com.linkedin.kafka.cruisecontrol.executor.Executor;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.executor.ReplicationThrottleHelper;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractExecutorReplicaMovement {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractExecutorReplicaMovement.class);
    protected final String uuid;
    protected final ExecutionTaskManager executionTaskManager;
    protected final Set<Integer> recentlyRemovedBrokers;
    protected final ReplicationThrottleHelper throttleHelper;
    protected final ConfluentAdmin adminClient;
    protected final SbkAdminUtils adminUtils;
    protected final AtomicBoolean stopRequested;

    public AbstractExecutorReplicaMovement(String executionUuid, ExecutionTaskManager executionTaskManager, Set<Integer> recentlyRemovedBrokers, ReplicationThrottleHelper throttleHelper, ConfluentAdmin adminClient, SbkAdminUtils adminUtils, AtomicBoolean stopRequested) {
        this.uuid = executionUuid;
        this.executionTaskManager = executionTaskManager;
        this.recentlyRemovedBrokers = recentlyRemovedBrokers;
        this.throttleHelper = throttleHelper;
        this.adminClient = adminClient;
        this.adminUtils = adminUtils;
        this.stopRequested = stopRequested;
    }

    public abstract void move(Executor.ExecutionTaskWaiter var1) throws InterruptedException;

    public void maybeReexecuteTasks() {
    }

    abstract ExecutionTask.TaskType taskType();

    abstract ExecutorState.State state();

    abstract ExecutorState executorState();
}

