/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerEntity;

public class BrokerMetricSample
extends MetricSample<BrokerEntity> {
    public BrokerMetricSample(String host, Integer brokerId) {
        super(new BrokerEntity(host, brokerId));
        if (host != null && host.length() >= Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("The length of host name %s is %d, which is longer than the max allowed length of %d", host, host.length(), (short)Short.MAX_VALUE));
        }
    }

    public int brokerId() {
        return ((BrokerEntity)this.entity()).brokerId();
    }

    @Override
    protected MetricDef metricDefForToString() {
        return KafkaMetricDef.brokerMetricDef();
    }

    public Double metricValue(KafkaMetricDef kafkaMetricDef) {
        return (Double)this.valuesByMetricId.get(KafkaMetricDef.brokerMetricDef().metricInfo(kafkaMetricDef).id());
    }
}

