/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;

class HolderUtils {
    static final double MISSING_BROKER_METRIC_VALUE = 0.0;
    static final Map<RawMetricType, RawMetricType> METRIC_TYPES_TO_SUM = new HashMap<RawMetricType, RawMetricType>();
    private static final int BYTES_IN_KB = 1024;
    private static final int BYTES_IN_MB = 0x100000;

    private HolderUtils() {
    }

    static void sanityCheckMetricScope(RawMetricType rawMetricType, RawMetricType.MetricScope expectedMetricScope) {
        if (rawMetricType.metricScope() != expectedMetricScope) {
            throw new IllegalArgumentException(String.format("Metric scope %s of raw metric type with id %d does not match the expected metric scope %s.", new Object[]{rawMetricType.metricScope(), rawMetricType.id(), expectedMetricScope}));
        }
    }

    static boolean allowMissingBrokerMetric(Cluster cluster, int brokerId, RawMetricType rawMetricType) {
        switch (rawMetricType) {
            case BROKER_FOLLOWER_FETCH_REQUEST_RATE: {
                for (PartitionInfo partitionInfo : cluster.partitionsForNode(brokerId)) {
                    if (partitionInfo.replicas().length <= 1 || partitionInfo.leader() == null || partitionInfo.leader().id() != brokerId) continue;
                    return false;
                }
                return true;
            }
            case BROKER_PRODUCE_REQUEST_RATE: 
            case BROKER_CONSUMER_FETCH_REQUEST_RATE: {
                return true;
            }
        }
        return false;
    }

    static double convertUnit(double value, RawMetricType rawMetricType) {
        switch (rawMetricType) {
            case ALL_TOPIC_BYTES_IN: 
            case ALL_TOPIC_BYTES_OUT: 
            case ALL_TOPIC_REPLICATION_BYTES_IN: 
            case ALL_TOPIC_REPLICATION_BYTES_OUT: 
            case ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT: 
            case TOPIC_BYTES_IN: 
            case TOPIC_BYTES_OUT: 
            case TOPIC_REPLICATION_BYTES_IN: 
            case TOPIC_REPLICATION_BYTES_OUT: 
            case TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT: {
                return value / 1024.0;
            }
            case PARTITION_SIZE: {
                return value / 1048576.0;
            }
        }
        return value;
    }

    static {
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_PRODUCE_REQUEST_RATE, RawMetricType.ALL_TOPIC_PRODUCE_REQUEST_RATE);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_FETCH_REQUEST_RATE, RawMetricType.ALL_TOPIC_FETCH_REQUEST_RATE);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_FOLLOWER_FETCH_REQUEST_RATE, RawMetricType.ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT, RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE, RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_BYTES_IN, RawMetricType.ALL_TOPIC_BYTES_IN);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_BYTES_OUT, RawMetricType.ALL_TOPIC_BYTES_OUT);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_REPLICATION_BYTES_IN, RawMetricType.ALL_TOPIC_REPLICATION_BYTES_IN);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_REPLICATION_BYTES_OUT, RawMetricType.ALL_TOPIC_REPLICATION_BYTES_OUT);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_MESSAGES_IN_PER_SEC, RawMetricType.ALL_TOPIC_MESSAGES_IN_PER_SEC);
    }
}

