/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.operation;

import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalContext;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalFuture;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalPhase;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalPhaseExecutor;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.errors.BalancerOperationFailedException;
import org.apache.kafka.common.errors.RebalancePlanComputationException;

public class BrokerRemovalPhaseBuilder {
    private BrokerRemovalPhaseExecutor.Builder<Void> executorReservationPhaseBuilder;
    private BrokerRemovalPhaseExecutor.Builder<Void> initialPlanComputationPhaseBuilder;
    private BrokerRemovalPhaseExecutor.Builder<Void> brokerExclusionPhaseBuilder;
    private BrokerRemovalPhaseExecutor.Builder<Void> planComputationPhaseBuilder;
    private BrokerRemovalPhaseExecutor.Builder<Void> planExecutionPhaseBuilder;
    private BrokerRemovalPhaseExecutor.Builder<Void> brokerShutdownPhaseBuilder;
    private BrokerRemovalPhaseExecutor.Builder<Void> brokerExclusionRemovalPhaseBuilder;
    private BrokerRemovalPhaseExecutor.Builder<Void> opCompletionPhaseBuilder;

    public BrokerRemovalFuture composeRemoval(BrokerRemovalContext removalOpts, BrokerRemovalCallback progressCallback, BrokerRemovalPhase<Void> executorReservationPhase, BrokerRemovalPhase<Void> initialPlanComputationPhase, BrokerRemovalPhase<Void> brokerExclusionPhase, BrokerRemovalPhase<Void> planComputationPhase, BrokerRemovalPhase<Void> planExecutionPhase, BrokerRemovalPhase<Void> brokerShutdownPhase, BrokerRemovalPhase<Void> brokerExclusionRemovalPhase, BrokerRemovalPhase<Void> opCompletionPhase) {
        this.createPhaseBuilders(removalOpts);
        BrokerRemovalPhaseExecutor<Void> executorReservationPhaseExecutor = this.executorReservationPhaseBuilder.build(progressCallback, removalOpts);
        BrokerRemovalPhaseExecutor<Void> initialPlanComputationPhaseExecutor = this.initialPlanComputationPhaseBuilder.build(progressCallback, removalOpts);
        BrokerRemovalPhaseExecutor<Void> brokerExclusionPhaseExecutor = this.brokerExclusionPhaseBuilder.build(progressCallback, removalOpts);
        BrokerRemovalPhaseExecutor<Void> planComputationPhaseExecutor = this.planComputationPhaseBuilder.build(progressCallback, removalOpts);
        BrokerRemovalPhaseExecutor<Void> planExecutionPhaseExecutor = this.planExecutionPhaseBuilder.build(progressCallback, removalOpts);
        BrokerRemovalPhaseExecutor<Void> brokerShutdownPhaseExecutor = this.brokerShutdownPhaseBuilder.build(progressCallback, removalOpts);
        BrokerRemovalPhaseExecutor<Void> brokerExclusionRemovalPhaseExecutor = this.brokerExclusionRemovalPhaseBuilder.build(progressCallback, removalOpts);
        BrokerRemovalPhaseExecutor<Void> opCompletionPhaseExecutor = this.opCompletionPhaseBuilder.build(progressCallback, removalOpts);
        CompletableFuture<Void> initialFuture = new CompletableFuture<Void>();
        CompletionStage chainedFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)initialFuture.thenCompose(aVoid -> executorReservationPhaseExecutor.execute(executorReservationPhase))).thenCompose(aVoid -> initialPlanComputationPhaseExecutor.execute(initialPlanComputationPhase))).thenCompose(aVoid -> brokerExclusionPhaseExecutor.execute(brokerExclusionPhase))).thenCompose(aVoid -> planComputationPhaseExecutor.execute(planComputationPhase))).thenCompose(aVoid -> planExecutionPhaseExecutor.execute(planExecutionPhase));
        if (removalOpts.shouldShutdown) {
            chainedFuture = ((CompletableFuture)((CompletableFuture)chainedFuture).thenCompose(aVoid -> brokerShutdownPhaseExecutor.execute(brokerShutdownPhase))).thenCompose(aVoid -> brokerExclusionRemovalPhaseExecutor.execute(brokerExclusionRemovalPhase));
        }
        ((CompletableFuture)chainedFuture).whenComplete((result, exc) -> opCompletionPhaseExecutor.execute(opCompletionPhase));
        return new BrokerRemovalFuture(removalOpts, initialFuture, (CompletableFuture<Void>)chainedFuture);
    }

    private void createPhaseBuilders(BrokerRemovalContext removalContext) {
        BrokerRemovalStateMachine.BrokerRemovalEvent planExecutionSuccessEvent = removalContext.shouldShutdown ? BrokerRemovalStateMachine.BrokerRemovalEvent.PLAN_EXECUTION_SUCCESS_WITH_SHUTDOWN : BrokerRemovalStateMachine.BrokerRemovalEvent.PLAN_EXECUTION_SUCCESS_NO_SHUTDOWN;
        this.executorReservationPhaseBuilder = new BrokerRemovalPhaseExecutor.Builder(null, BrokerRemovalStateMachine.BrokerRemovalEvent.INITIAL_PLAN_COMPUTATION_FAILURE, brokerIds -> String.format("Error while acquiring a reservation on the executor and aborting ongoing executions prior to beginning the broker removal operation for brokers %s.", brokerIds), BalancerOperationFailedException.class);
        this.initialPlanComputationPhaseBuilder = new BrokerRemovalPhaseExecutor.Builder(BrokerRemovalStateMachine.BrokerRemovalEvent.INITIAL_PLAN_COMPUTATION_SUCCESS, BrokerRemovalStateMachine.BrokerRemovalEvent.INITIAL_PLAN_COMPUTATION_FAILURE, brokerIds -> String.format("Error while computing the initial remove broker plan for brokers %s prior to exclusion.", brokerIds), RebalancePlanComputationException.class);
        this.brokerExclusionPhaseBuilder = new BrokerRemovalPhaseExecutor.Builder(BrokerRemovalStateMachine.BrokerRemovalEvent.EXCLUSION_SUCCESS, BrokerRemovalStateMachine.BrokerRemovalEvent.EXCLUSION_FAILURE, brokerIds -> String.format("Error while executing broker replica exclusion for brokers %s.", brokerIds), BalancerOperationFailedException.class);
        this.planComputationPhaseBuilder = new BrokerRemovalPhaseExecutor.Builder(BrokerRemovalStateMachine.BrokerRemovalEvent.PLAN_COMPUTATION_SUCCESS, BrokerRemovalStateMachine.BrokerRemovalEvent.PLAN_COMPUTATION_FAILURE, brokerIds -> String.format("Error while computing broker removal plan for brokers %s.", brokerIds), RebalancePlanComputationException.class);
        this.planExecutionPhaseBuilder = new BrokerRemovalPhaseExecutor.Builder(planExecutionSuccessEvent, BrokerRemovalStateMachine.BrokerRemovalEvent.PLAN_EXECUTION_FAILURE, brokerIds -> String.format("Unexpected exception while executing the broker removal plan for brokers %s", brokerIds), BalancerOperationFailedException.class);
        this.brokerShutdownPhaseBuilder = new BrokerRemovalPhaseExecutor.Builder(BrokerRemovalStateMachine.BrokerRemovalEvent.BROKER_SHUTDOWN_SUCCESS, BrokerRemovalStateMachine.BrokerRemovalEvent.BROKER_SHUTDOWN_FAILURE, brokerIds -> String.format("Error while executing shut down for brokers %s", brokerIds), BalancerOperationFailedException.class);
        this.brokerExclusionRemovalPhaseBuilder = new BrokerRemovalPhaseExecutor.Builder(BrokerRemovalStateMachine.BrokerRemovalEvent.EXCLUSION_REMOVAL_SUCCESS, BrokerRemovalStateMachine.BrokerRemovalEvent.EXCLUSION_REMOVAL_FAILURE, brokerIds -> String.format("Error while removing replica exclusions for brokers %s", brokerIds), BalancerOperationFailedException.class);
        this.opCompletionPhaseBuilder = new BrokerRemovalPhaseExecutor.Builder(null, null, brokerIds -> String.format("Error when handling completion of broker removal plan for brokers %s", brokerIds), BalancerOperationFailedException.class);
    }
}

