/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import com.linkedin.cruisecontrol.exception.CruiseControlException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.RebalanceResult;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationResult;
import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfigDelta;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalFuture;
import com.linkedin.kafka.cruisecontrol.operation.MultiBrokerAdditionOperation;
import io.confluent.databalancer.BrokerChangeEvent;
import io.confluent.databalancer.ConfluentDataBalanceEngineContext;
import io.confluent.databalancer.DataBalanceEngine;
import io.confluent.databalancer.DataBalanceEngineContext;
import io.confluent.databalancer.DatabalancerUtils;
import io.confluent.databalancer.EngineInitializationContext;
import io.confluent.databalancer.KafkaDataBalanceManager;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import io.confluent.databalancer.operation.BalanceOpExecutionCompletionCallback;
import io.confluent.databalancer.operation.BalancerStatusStateMachine;
import io.confluent.databalancer.operation.BalancerStatusTracker;
import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import io.confluent.databalancer.operation.BrokerRemovalStateTracker;
import io.confluent.databalancer.operation.MultiBrokerBalancerOperationTerminationListener;
import io.confluent.databalancer.operation.PersistRemoveApiStateListener;
import io.confluent.databalancer.operation.SingleBrokerBalancerOperationProgressListener;
import io.confluent.databalancer.operation.SingleBrokerBalancerOperationTerminationListener;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.persistence.BrokerRemovalStateRecord;
import io.confluent.databalancer.persistence.EvenClusterLoadStateRecord;
import io.confluent.databalancer.startup.CruiseControlStartable;
import io.confluent.databalancer.startup.StartupCheckInterruptedException;
import io.confluent.databalancer.utils.ImmutableSet;
import io.confluent.databalancer.utils.OperationRetryer;
import io.confluent.databalancer.utils.RetryableResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.common.AliveBrokersMetadata;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalancerJbodEnabledMisconfigurationException;
import org.apache.kafka.common.errors.BalancerMisconfigurationException;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.BrokerAdditionInProgressException;
import org.apache.kafka.common.errors.BrokerFailureFixInProgressException;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.errors.EvenClusterLoadTaskInProgressException;
import org.apache.kafka.common.errors.RebalancePlanComputationException;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentDataBalanceEngine
implements DataBalanceEngine {
    public static final String BROKER_ADD_COUNT_METRIC_NAME = "BrokerAddCount";
    public static final String CC_RUNNER_TASK_PROCESSING_TIME = "CcRunnerProcessingTime";
    public static final String CC_RUNNER_TASKS_COUNT = "CcRunnerTasksCount";
    private static final Logger LOG = LoggerFactory.getLogger(ConfluentDataBalanceEngine.class);
    private final ExecutorService ccRunner;
    private KafkaDataBalanceManager.BrokerRemovalMetricRegistry brokerRemovalMetricRegistry;
    final MultiBrokerBalancerOperationTerminationListener<BrokerRemovalStateMachine.BrokerRemovalState> removalTerminationListener;
    final SingleBrokerBalancerOperationTerminationListener<BrokerAdditionStateMachine.BrokerAdditionState> additionTerminationListener;
    final SingleBrokerBalancerOperationProgressListener<BrokerAdditionStateMachine.BrokerAdditionState> additionProgressListener;
    final ConfluentDataBalanceEngineContext context;
    private final Semaphore abortStartupCheck = new Semaphore(0);
    volatile boolean canAcceptRequests = false;
    private final AtomicLong ccRunnerTaskProcessingTime;
    private final AtomicInteger ccRunnerTasksCount;

    public ConfluentDataBalanceEngine(DataBalancerMetricsRegistry dataBalancerMetricsRegistry, KafkaConfig config) {
        this(Executors.newSingleThreadExecutor(ConfluentDataBalanceEngine.createThreadFactory(config)), ConfluentDataBalanceEngine.createContext(dataBalancerMetricsRegistry, config.getBoolean("confluent.balancer.incremental.balancing.enabled")));
    }

    private static ConfluentDataBalanceEngineContext createContext(DataBalancerMetricsRegistry dataBalancerMetricsRegistry, boolean incrementalBalancingEnabled) {
        return new ConfluentDataBalanceEngineContext(dataBalancerMetricsRegistry, null, (Time)new SystemTime(), incrementalBalancingEnabled);
    }

    private static KafkaCruiseControlThreadFactory createThreadFactory(KafkaConfig config) {
        return new KafkaCruiseControlThreadFactory("DataBalanceEngine", true, LOG, Optional.of(DatabalancerUtils.getBrokerId(config)));
    }

    ConfluentDataBalanceEngine(ExecutorService executor, ConfluentDataBalanceEngineContext context) {
        this.ccRunner = Objects.requireNonNull(executor, "ExecutorService must be non-null");
        this.context = context;
        this.removalTerminationListener = (brokerIds, state, e) -> {
            context.brokerRemovalsStateTrackers.remove(new ImmutableSet(brokerIds));
            LOG.info("Removal for brokers {} reached terminal state {}", (Object)brokerIds, (Object)state);
        };
        this.additionTerminationListener = (brokerId, state, e) -> LOG.info("Addition operation for broker {} reached terminal state {}", new Object[]{brokerId, state, e});
        this.additionProgressListener = (brokerId, state, e) -> LOG.info("Addition status for broker {} changed to {}", new Object[]{brokerId, state, e});
        this.ccRunnerTaskProcessingTime = new AtomicLong();
        this.ccRunnerTasksCount = new AtomicInteger();
    }

    @Override
    public DataBalanceEngineContext getDataBalanceEngineContext() {
        return this.context;
    }

    @Override
    public synchronized void onActivation(EngineInitializationContext initializationContext) {
        this.brokerRemovalMetricRegistry = initializationContext.brokerRemovalMetricRegistry();
        this.context.setBalancerStatusTracker(initializationContext.balancerStatusTracker());
        this.context.shouldAutoHeal(DatabalancerUtils.anyUnevenLoadEnabled(initializationContext.kafkaConfig()));
        this.context.v2AdditionEnabled(DatabalancerUtils.v2AdditionEnabled(initializationContext.kafkaConfig()));
        LOG.info("DataBalancer: Scheduling DataBalanceEngine Startup");
        this.registerMetrics();
        this.abortStartupCheck.drainPermits();
        this.canAcceptRequests = true;
        this.submitToCcRunnerOrElse(cruiseControl -> LOG.warn("DataBalanceEngine already running when startUp requested."), () -> {}, () -> this.doStart(initializationContext), LOG);
    }

    private void registerMetrics() {
        boolean isShortLived = true;
        this.context.getDataBalancerMetricsRegistry().newGauge(ConfluentDataBalanceEngine.class, BROKER_ADD_COUNT_METRIC_NAME, () -> {
            if (this.context.additionContext() != null) {
                return this.context.additionContext().brokersBeingAdded().size();
            }
            LOG.info("Broker Addition context is yet to be initialized, hence BrokerAddCount metrics will be reported as 0.");
            return 0;
        }, isShortLived);
        this.context.getDataBalancerMetricsRegistry().newGauge(ConfluentDataBalanceEngine.class, CC_RUNNER_TASKS_COUNT, this.ccRunnerTasksCount::get, isShortLived);
        this.context.getDataBalancerMetricsRegistry().newGauge(ConfluentDataBalanceEngine.class, CC_RUNNER_TASK_PROCESSING_TIME, this.ccRunnerTaskProcessingTime::get, isShortLived);
    }

    @Override
    public synchronized void onDeactivation(BalancerStatusStateMachine.BalancerEvent balancerEvent) {
        LOG.info("DataBalancer: Scheduling DataBalanceEngine Shutdown due to {}.", (Object)balancerEvent);
        Optional<BalancerStatusTracker> balancerStatusTracker = Optional.ofNullable(this.context.getBalancerStatusTracker());
        this.abortStartupCheck.release();
        this.canAcceptRequests = false;
        this.submitToCcRunnerOrElse(cruiseControl -> this.stopCruiseControl((KafkaCruiseControl)cruiseControl, balancerEvent, balancerStatusTracker), () -> LOG.info("Databalancer: Shutting down DataBalanceEngine on receiving balancer event {}", (Object)balancerEvent), () -> balancerStatusTracker.ifPresent(statusTracker -> statusTracker.registerEvent(balancerEvent)), LOG);
    }

    @Override
    public void shutdown(KafkaConfig kafkaConfig) throws InterruptedException {
        this.ccRunner.shutdown();
        Integer shutdownTimeoutMs = KafkaCruiseControlConfig.shutdownTimeoutMs(kafkaConfig.originalsWithPrefix("confluent.balancer."));
        boolean stopped = this.ccRunner.awaitTermination(shutdownTimeoutMs.intValue(), TimeUnit.MILLISECONDS);
        if (!stopped) {
            LOG.info("Unable to shutdown CDBE executor service, timeout {} expired", (Object)shutdownTimeoutMs);
        }
    }

    @Override
    public void updateThrottle(Long newThrottle) {
        LOG.info("DataBalancer: Scheduling DataBalanceEngine throttle update to {}", (Object)newThrottle);
        this.submitToCcRunner(cruiseControl -> this.updateThrottleHelper((KafkaCruiseControl)cruiseControl, newThrottle), "Databalancer: Updating throttle to " + newThrottle, "Cannot update throttle when no DataBalancer is active.", LOG);
    }

    @Override
    public void setAutoHealMode(boolean shouldAutoHeal) {
        LOG.info("DataBalancer: Scheduling DataBalanceEngine auto-heal update (setting to {})", (Object)shouldAutoHeal);
        this.context.shouldAutoHeal(shouldAutoHeal);
        this.submitToCcRunner(cruiseControl -> this.updateAutoHealHelper((KafkaCruiseControl)cruiseControl, shouldAutoHeal), "Databalancer: Updating auto-heal mode to (" + shouldAutoHeal + ")", "Attempt to update auto-heal mode (" + shouldAutoHeal + ") when no DataBalancer is active.", LOG);
    }

    @Override
    public void updateConfigPermanently(String configKey, Object configValue) {
        LOG.debug("Permanently updating config {} to {}", (Object)configKey, (Object)configValue.toString());
        this.submitToCcRunner(cruiseControl -> this.updateConfigPermanentlyHelper((KafkaCruiseControl)cruiseControl, configKey, configValue), "Databalancer: Updating configs dynamically as ConfigKey: " + configKey + "ConfigValue: " + configValue, "", LOG);
    }

    @Override
    public void updateConfigPermanently(SbcGoalsConfigDelta sbcGoalsConfigDelta) {
        LOG.info("Permanently updating goals config with the delta {}", (Object)sbcGoalsConfigDelta);
        this.submitToCcRunner(cruiseControl -> this.updateConfigPermanentlyHelper((KafkaCruiseControl)cruiseControl, sbcGoalsConfigDelta), "Databalancer: Updating sbc goals configs dynamically with delta " + sbcGoalsConfigDelta, "", LOG);
    }

    @Override
    public void removeBrokers(Map<Integer, Optional<Long>> brokersToRemoveAndEpochs, boolean shouldShutdown, String uid) {
        HashSet<Integer> brokersToRemove = new HashSet<Integer>(brokersToRemoveAndEpochs.keySet());
        String logPrefix = BrokerRemovalCallback.logPrefix(uid);
        if (!this.canAcceptRequests) {
            String msg = String.format("Received request to remove brokers %s (uid %s) while DataBalancer is not started.", brokersToRemoveAndEpochs, uid);
            LOG.error(msg);
            throw new BalancerOfflineException(msg);
        }
        LOG.info("DataBalancer: {} Scheduling DataBalanceEngine broker removal: {} (uid: {}, shouldShutdown: {})", new Object[]{logPrefix, brokersToRemoveAndEpochs, uid, shouldShutdown});
        ApiStatePersistenceStore persistenceStore = this.context.getPersistenceStore();
        Supplier<Stream> ongoingRemovalFilterSupplier = () -> persistenceStore.getAllBrokerRemovalStateRecords().values().stream().filter(status -> !BrokerRemovalStateMachine.isStateTerminal(status.state()));
        Set brokerIdsBeingRemoved = ongoingRemovalFilterSupplier.get().flatMap(record -> record.brokerIds().stream()).collect(Collectors.toSet());
        if (!brokerIdsBeingRemoved.isEmpty()) {
            if (brokerIdsBeingRemoved.containsAll(brokersToRemove)) {
                LOG.info("DataBalancer: {} Performing a no-op and returning a successful response for the broker removal operation {} because the requested brokers to be removed ({}) are already being removed with an on-going in-progress removal operation (for brokers {}).", new Object[]{logPrefix, uid, brokersToRemove, brokerIdsBeingRemoved});
                return;
            }
            String brokerIds = ongoingRemovalFilterSupplier.get().map(status -> String.format("[%s]", status.brokerIds().toString())).collect(Collectors.joining(","));
            String msg = "Cannot remove brokers " + brokersToRemove + " as broker removals already in progress: " + brokerIds;
            LOG.error(msg);
            throw new BrokerRemovalInProgressException(msg);
        }
        PersistRemoveApiStateListener listener = new PersistRemoveApiStateListener(this.context.getPersistenceStore(), shouldShutdown);
        BrokerRemovalStateTracker stateTracker = new BrokerRemovalStateTracker(brokersToRemove, listener, this.removalTerminationListener, this.brokerRemovalMetricRegistry.registerBrokerRemovalMetric(brokersToRemove), this.context.getTime());
        this.submitRemoveBroker(brokersToRemoveAndEpochs, shouldShutdown, stateTracker, uid);
    }

    private void submitRemoveBroker(Map<Integer, Optional<Long>> brokersToRemoveAndEpochs, boolean shouldShutdown, BrokerRemovalStateTracker stateTracker, String uid) {
        this.context.brokerRemovalsStateTrackers.put(stateTracker.brokerIds(), stateTracker);
        stateTracker.initialize();
        this.submitToCcRunner(cruiseControl -> this.doRemoveBroker((KafkaCruiseControl)cruiseControl, brokersToRemoveAndEpochs, shouldShutdown, stateTracker, uid), "Databalancer: Initiating remove broker operation with UID " + uid, "Broker removal operation with UID " + uid + " was not initiated due to the data balance engine not being initialized", LOG);
    }

    private void doRemoveBroker(KafkaCruiseControl cc, Map<Integer, Optional<Long>> brokersToRemoveAndEpochs, boolean shouldShutdown, BrokerRemovalStateTracker stateTracker, String uid) {
        LOG.info("Initiating broker removal operation with UID {} for brokers with epochs {}", (Object)uid, brokersToRemoveAndEpochs);
        ImmutableSet<Integer> brokersToRemove = stateTracker.brokerIds();
        try {
            BrokerRemovalFuture brokerRemovalFuture = cc.removeBrokers(brokersToRemoveAndEpochs, shouldShutdown, (success, ex) -> this.context.removeBrokerRemovalFuture(brokersToRemove), stateTracker, uid);
            this.context.putBrokerRemovalFuture(brokersToRemove, brokerRemovalFuture);
        }
        catch (Throwable e) {
            LOG.error("Broker removal operation with UID {} for brokers {} failed due to ", new Object[]{uid, brokersToRemove, e});
        }
    }

    Future<?> submitToCcRunner(Consumer<KafkaCruiseControl> task, String currentTaskMessage, String notActiveErrorMessage, Logger logger) {
        return this.submitToCcRunnerOrElse(task, () -> LOG.info(currentTaskMessage), () -> LOG.info(notActiveErrorMessage), logger);
    }

    Future<?> submitToCcRunnerOrElse(Consumer<KafkaCruiseControl> task, Runnable taskWhenActive, Runnable taskIfInactive, Logger logger) {
        this.ccRunnerTasksCount.incrementAndGet();
        return this.ccRunner.submit(() -> {
            long startTime = System.nanoTime();
            try {
                Optional<KafkaCruiseControl> cruiseControl = this.context.getCruiseControl();
                if (this.isActive() && cruiseControl.isPresent()) {
                    taskWhenActive.run();
                    cruiseControl.ifPresent(task);
                } else {
                    taskIfInactive.run();
                }
            }
            catch (Throwable e) {
                logger.error("Uncaught exception in " + Thread.currentThread().getName() + ": ", e);
                throw e;
            }
            finally {
                long totalTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
                this.ccRunnerTaskProcessingTime.set(totalTimeMs);
                this.ccRunnerTasksCount.decrementAndGet();
            }
        });
    }

    @Override
    public void addBrokers(Set<Integer> allBrokersToAdd, String uid, AliveBrokersMetadata brokersMetadata) {
        if (!this.canAcceptRequests) {
            String msg = String.format("Received request to add brokers %s while DataBalancer is not started.", allBrokersToAdd);
            LOG.error(msg);
            throw new BalancerOfflineException(msg);
        }
        if (this.context.additionContext().isV2AdditionEnabled()) {
            this.doAddBrokersV2(allBrokersToAdd, uid);
        } else {
            this.doAddBrokersV1(allBrokersToAdd, uid, brokersMetadata);
        }
    }

    private void doAddBrokersV2(Set<Integer> allBrokersToAdd, String uid) {
        if (!this.context.shouldAutoHeal()) {
            throw new BalancerMisconfigurationException(String.format("Cannot initiate a v2 broker addition operation %s for brokers %s when self-healing is disabled.", uid, allBrokersToAdd));
        }
        HashSet<Integer> brokerIdsToAdd = new HashSet<Integer>(allBrokersToAdd);
        Set brokerIdsToAddBeingRemoved = this.context.getPersistenceStore().getAllBrokerRemovalStateRecords().values().stream().filter(s -> !BrokerRemovalStateMachine.isStateTerminal(s.state())).flatMap(record -> record.brokerIds().stream()).filter(brokerIdsToAdd::contains).collect(Collectors.toSet());
        if (!brokerIdsToAddBeingRemoved.isEmpty()) {
            LOG.warn("Will not initiate a v2 broker addition operation {} for brokers {} because they are being removed.", (Object)uid, brokerIdsToAddBeingRemoved);
            brokerIdsToAdd.removeAll(brokerIdsToAddBeingRemoved);
            if (brokerIdsToAdd.isEmpty()) {
                return;
            }
        }
        try {
            Set<Integer> initializedAdditions = this.context.additionContext().initializeV2BrokerAddition(brokerIdsToAdd);
            LOG.info("Initialized a v2 broker addition operation for brokers {}", initializedAdditions);
            this.submitToCcRunner(KafkaCruiseControl::clearGoalOptimizationHistory, String.format("Clearing the goal optimization history as part of starting the v2 broker addition operation %s", uid), String.format("Could not clear the goal optimization history as part of starting the v2 broker addition operation %s due to the data balance engine not being initialized", uid), LOG);
        }
        catch (InterruptedException ie) {
            LOG.info("Caught an interrupted exception while trying to initialize a v2 broker addition operation for brokers {} {}", brokerIdsToAdd, (Object)ie);
            throw new RuntimeException(ie);
        }
        catch (Exception e) {
            LOG.error("Encountered an unexpected exception while trying to initialize a v2 broker addition operation for brokers {}: {}", brokerIdsToAdd, (Object)e);
            throw e;
        }
    }

    private void doAddBrokersV1(Set<Integer> allBrokersToAdd, String uid, AliveBrokersMetadata brokersMetadata) {
        Set activeExclusions = brokersMetadata.replicaExclusions();
        Set activeDemotions = brokersMetadata.demotedBrokers();
        HashSet activeExclusionsAndDemotions = new HashSet(activeExclusions);
        activeExclusionsAndDemotions.addAll(activeDemotions);
        boolean allBrokersToAddAreExcludedOrDemoted = activeExclusionsAndDemotions.containsAll(allBrokersToAdd);
        if (!activeExclusionsAndDemotions.isEmpty()) {
            if (allBrokersToAddAreExcludedOrDemoted) {
                String brokerIdsStr = allBrokersToAdd.stream().map(Object::toString).collect(Collectors.joining(","));
                LOG.info("All newly-added brokers are ignored for replica placement (brokers: {}, excluded and demoted brokers: {}) - completing the addition operation", (Object)brokerIdsStr, activeExclusionsAndDemotions);
                this.context.additionContext().initializeV1BrokerAddition(allBrokersToAdd).registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent.EXCLUSION_SHORT_CIRCUITS);
                return;
            }
            Set excludedAndDemotedBrokersToBeAdded = allBrokersToAdd.stream().filter(activeExclusionsAndDemotions::contains).collect(Collectors.toSet());
            if (!excludedAndDemotedBrokersToBeAdded.isEmpty()) {
                allBrokersToAdd.removeAll(excludedAndDemotedBrokersToBeAdded);
                LOG.info("Attempted to add brokers {} which are ignored for replica placement - filtering them out of the additions. New set of brokers to be added is: {}", excludedAndDemotedBrokersToBeAdded, allBrokersToAdd);
            }
        }
        HashSet<Integer> brokersToAddFinal = new HashSet<Integer>(allBrokersToAdd);
        BalanceOpExecutionCompletionCallback onExecutionCompletion = (opSuccess, ex) -> {
            if (opSuccess) {
                LOG.info("The broker addition operation for brokers {} has completed successfully", (Object)brokersToAddFinal);
            } else if (ex != null) {
                LOG.info("The broker addition operation for brokers {} has completed erroneously", (Object)brokersToAddFinal);
            } else {
                LOG.info("The broker addition operation for brokers {} completed unsuccessfully without any errors", (Object)brokersToAddFinal);
            }
        };
        MultiBrokerAdditionOperation multiBrokerAdditionOperation = this.context.additionContext().initializeV1BrokerAddition(brokersToAddFinal);
        ApiStatePersistenceStore persistenceStore = this.context.getPersistenceStore();
        Map<ImmutableSet<Integer>, BrokerRemovalStateRecord> existingBrokerRemovalStatus = persistenceStore.getAllBrokerRemovalStateRecords();
        if (existingBrokerRemovalStatus.values().stream().anyMatch(s -> !BrokerRemovalStateMachine.isStateTerminal(s.state()))) {
            LOG.warn("Broker removals ongoing, will not add new brokers {}", allBrokersToAdd);
            String errMsg = String.format("The broker addition operation for brokers %s was cancelled because a higher-priority broker removal request was ongoing", allBrokersToAdd.stream().map(Object::toString).collect(Collectors.joining(",")));
            multiBrokerAdditionOperation.registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent.BROKER_REMOVAL_REQUEST_OVERRIDES, (Exception)new BalancerOperationOverriddenException(errMsg));
            return;
        }
        LOG.info("DataBalancer: Scheduling DataBalanceEngine broker addition: {}", brokersToAddFinal);
        this.submitToCcRunner(cruiseControl -> this.doAddBrokers((KafkaCruiseControl)cruiseControl, multiBrokerAdditionOperation, onExecutionCompletion, uid), "Databalancer: Initiating broker addition operation with UID " + uid + " for brokers:  (" + brokersToAddFinal + ").", "Broker addition operation with UID " + uid + " was not initiated due to the data balance engine not being initialized", LOG);
    }

    @Override
    public boolean cancelBrokerRemoval(Set<Integer> brokerIds, String reason) {
        BrokerRemovalFuture removalFuture = this.context.brokerRemovalFuture(new ImmutableSet<Integer>(brokerIds));
        if (removalFuture == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Will not cancel broker removal for brokers {} because of reason {} as they are not being removed.", (Object)reason, brokerIds);
            }
            return false;
        }
        LOG.info("Canceling broker removal task for brokers {} because of reason {}", brokerIds, (Object)reason);
        boolean wasCanceled = removalFuture.cancel(reason);
        LOG.info("Canceled broker removal task for brokers {} because of reason {} (future canceled {})", new Object[]{brokerIds, reason, wasCanceled});
        return wasCanceled;
    }

    @Override
    public void notifyBrokerChange(Set<Integer> changedBrokers, BrokerChangeEvent event) {
        String nonActiveErrorMessage = String.format("Ignoring request to track %s event for brokers (%s) while the data balance engine is not initialized.", new Object[]{event, changedBrokers});
        String activeMessage = String.format("Databalancer: Working on tracking %s event for brokers (%s)", new Object[]{event, changedBrokers});
        LOG.info("Notify {} event for brokers: {}", (Object)event, changedBrokers);
        this.submitToCcRunner(cruiseControl -> cruiseControl.notifyBrokerChange(changedBrokers, event), activeMessage, nonActiveErrorMessage, LOG);
    }

    @Override
    public boolean isActive() {
        return this.context.isCruiseControlInitialized();
    }

    @Override
    public void triggerEvenClusterLoadTask(String uuid) {
        this.validateEvenClusterLoadTask(uuid, "TriggerEvenClusterLoad");
        this.submitTriggerEvenClusterLoadTask(uuid);
    }

    private void validateBalancerOnline(String logMessage, String errorMessage) {
        if (!this.canAcceptRequests) {
            LOG.error(logMessage);
            throw new BalancerOfflineException(errorMessage);
        }
    }

    private void validateOngoingBrokerRemovals(String logMessage, String errorMessage) {
        Map<ImmutableSet<Integer>, BrokerRemovalStateRecord> existingBrokerRemovalStatus = this.context.getPersistenceStore().getAllBrokerRemovalStateRecords();
        boolean hasOngoingBrokerRemovals = existingBrokerRemovalStatus.values().stream().anyMatch(s -> !BrokerRemovalStateMachine.isStateTerminal(s.state()));
        if (hasOngoingBrokerRemovals) {
            LOG.info(logMessage);
            throw new BrokerRemovalInProgressException(errorMessage);
        }
    }

    private void validateOngoingBrokerAdditions(String logMessage, String errorMessage) {
        boolean hasOngoingBrokerAdditions;
        boolean bl = hasOngoingBrokerAdditions = !this.context.additionContext().brokersBeingAdded().isEmpty();
        if (hasOngoingBrokerAdditions) {
            LOG.info(logMessage);
            throw new BrokerAdditionInProgressException(errorMessage);
        }
    }

    private void validateOngoingEvenClusterLoadTask(String logMessage, String errorMessage) {
        boolean hasOngoingEvenClusterLoadTask;
        EvenClusterLoadStateRecord evenClusterLoadStateRecord = this.context.getPersistenceStore().getEvenClusterLoadStateRecord();
        boolean bl = hasOngoingEvenClusterLoadTask = evenClusterLoadStateRecord != null && evenClusterLoadStateRecord.currentState() != null && !evenClusterLoadStateRecord.currentState().isTerminal();
        if (hasOngoingEvenClusterLoadTask) {
            LOG.info(logMessage);
            throw new EvenClusterLoadTaskInProgressException(errorMessage);
        }
    }

    private void validateBrokerFailureFixInProgress(String brokerFixLogMessage, String brokerFixErrMessage, String engineNotAvailableLogMessage, String engineNotAvailableErrMessage) {
        boolean hasOngoingBrokerFailureFixes;
        Optional<KafkaCruiseControl> cruiseControl = this.context.getCruiseControl();
        if (!cruiseControl.isPresent()) {
            LOG.info(engineNotAvailableLogMessage);
            throw new BalancerOfflineException(engineNotAvailableErrMessage);
        }
        Map<Integer, Long> failedBrokers = this.context.getPersistenceStore().getFailedBrokers();
        boolean bl = hasOngoingBrokerFailureFixes = !failedBrokers.isEmpty() || cruiseControl.get().context().executor().hasOngoingExecution();
        if (hasOngoingBrokerFailureFixes) {
            LOG.warn(String.format("%s Failed brokers are: %s", brokerFixLogMessage, failedBrokers));
            throw new BrokerFailureFixInProgressException(brokerFixErrMessage);
        }
    }

    private void validateEvenClusterLoadTask(String uuid, String operation) {
        this.validateBalancerOnline(String.format("Failed to execute '%s' operation with UUID %s due to balancer being offline.", operation, uuid), String.format("Received request to execute '%s' operation while the Confluent Balancer component has not started yet. Query the BalancerStatus Admin API for more details.", operation));
        this.validateOngoingBrokerRemovals(String.format("Broker removals ongoing, will not execute '%s' operation with UUID: %s.", operation, uuid), String.format("The '%s' operation was cancelled because a higher-priority broker removal request was ongoing.", operation));
        this.validateOngoingBrokerAdditions(String.format("Broker addition ongoing, will not execute '%s' operation with UUID: %s.", operation, uuid), String.format("The '%s' operation was cancelled because a higher-priority broker addition request was ongoing.", operation));
        this.validateOngoingEvenClusterLoadTask(String.format("Even cluster load ongoing, will not execute '%s' operation with UUID: %s.", operation, uuid), String.format("The '%s' operation was cancelled because of an on-going even cluster load operation.", operation));
        this.validateBrokerFailureFixInProgress(String.format("SBC is working on fixing failed brokers in the cluster, due to which the '%s' operation with UUID: %s was cancelled.", operation, uuid), String.format("The '%s' operation was cancelled because of an on-going fix for a broker failure anomaly.", operation), String.format("Could not check for on-going broker failure fixes during the execution of '%s' operation with UUID %s due to data balance engine not available.", operation, uuid), String.format("The '%s' operation was cancelled because check for on-going broker failure fixes failed due to data balance engine not available.", operation));
    }

    private void submitTriggerEvenClusterLoadTask(String uuid) {
        this.submitToCcRunner(cruiseControl -> this.doTriggerEvenClusterLoadTask((KafkaCruiseControl)cruiseControl, uuid), "Databalancer: Initiating trigger even cluster load operation with UUID " + uuid, "Trigger even cluster load operation with UUID " + uuid + " was not initiated due to the data balance engine not being initialized", LOG);
    }

    private void doTriggerEvenClusterLoadTask(KafkaCruiseControl cc, String uuid) {
        LOG.info("Triggering even cluster load operation {}", (Object)uuid);
        try {
            cc.triggerEvenClusterLoadTask(uuid);
        }
        catch (Throwable e) {
            LOG.error("Triggering even cluster load operation {} failed due to ", (Object)uuid, (Object)e);
        }
    }

    @Override
    public void computeEvenClusterLoadPlan(String uuid, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadPlanInternal> callback) {
        this.validateEvenClusterLoadTask(uuid, "ComputeEvenClusterLoadPlan");
        Consumer<KafkaCruiseControl> task = cruiseControl -> {
            LOG.info(String.format("Computing even cluster load plan. Operation UUID: %s.", uuid));
            try {
                RebalanceResult result = cruiseControl.computeEvenClusterLoadPlan(uuid);
                OptimizationResult optimizationResult = result.optimizationResult();
                EvenClusterLoadPlanInternal plan = optimizationResult.toEvenClusterLoadPlan();
                callback.respond(ApiError.NONE, Optional.of(plan));
            }
            catch (ApiException e) {
                LOG.info("Computation of even cluster load plan failed. Operation UUID: {}. Cause: {}.", (Object)uuid, (Object)e);
                callback.respond(ApiError.fromThrowable((Throwable)e), Optional.empty());
            }
            catch (Throwable e) {
                LOG.error("Computation of even cluster load plan failed due to an unknown issue. Operation UUID: {}. Cause: {}.", (Object)uuid, (Object)e);
                String errMsg = "The operation to compute an even cluster load plan failed with error " + e.getMessage();
                RebalancePlanComputationException rebalanceException = new RebalancePlanComputationException(errMsg, e);
                callback.respond(ApiError.fromThrowable((Throwable)rebalanceException), Optional.empty());
            }
        };
        Runnable inactiveTask = () -> {
            LOG.error("Computation of even cluster load plan failed due to data balance engine not yet available. Operation UUID: {}.", (Object)uuid);
            String errMsg = "Computation of even cluster load plan operation was not initiated due to the Confluent Balancer component being disabled or not started yet. Query the BalancerStatus Admin API for more details.";
            BalancerOfflineException balancerOffline = new BalancerOfflineException(errMsg);
            callback.respond(ApiError.fromThrowable((Throwable)balancerOffline), Optional.empty());
        };
        Runnable activeTask = () -> LOG.info("Databalancer: Initiating request for computation of even cluster load plan with uuid {}.", (Object)uuid);
        this.submitToCcRunnerOrElse(task, activeTask, inactiveTask, LOG);
    }

    @Override
    public EvenClusterLoadStatusDescriptionInternal evenClusterLoadStatus(KafkaConfig kafkaConfig) {
        if (this.canAcceptRequests) {
            if (this.isActive()) {
                boolean anyUnevenLoadEnabled = this.context.getCruiseControl().map(c -> c.context().selfHealingEnabled()).orElse(false);
                return this.context.getEvenClusterLoadStateManager().evenClusterLoadStatusDescription(anyUnevenLoadEnabled);
            }
            return DatabalancerUtils.anyUnevenLoadEnabled(kafkaConfig) ? EvenClusterLoadStatusDescriptionInternal.STARTING : EvenClusterLoadStatusDescriptionInternal.DISABLED;
        }
        String msg = "Received request to describe the cluster even load status while the Confluent Balancer component is disabled or not started yet. Query the BalancerStatus Admin API for more details.";
        LOG.error(msg);
        throw new BalancerOfflineException(msg);
    }

    void updateThrottleHelper(KafkaCruiseControl cc, Long newThrottle) {
        LOG.info("Updating balancer throttle to {}", (Object)newThrottle);
        cc.updateThrottle(newThrottle);
    }

    void updateAutoHealHelper(KafkaCruiseControl cc, boolean shouldAutoHeal) {
        LOG.info("Changing GOAL_VIOLATION anomaly self-healing actions to {}", (Object)shouldAutoHeal);
        cc.setGoalViolationSelfHealing(shouldAutoHeal);
    }

    private void updateConfigPermanentlyHelper(KafkaCruiseControl cc, String configKey, Object configValue) {
        LOG.trace("Permanently updating config {} to {}", (Object)configKey, (Object)configValue.toString());
        cc.updateConfig(configKey, configValue);
    }

    private void updateConfigPermanentlyHelper(KafkaCruiseControl cc, SbcGoalsConfigDelta sbcGoalsConfigDelta) {
        cc.updateConfig(sbcGoalsConfigDelta);
    }

    void doStart(EngineInitializationContext initializationContext) {
        CruiseControlStartable ccStartable = new CruiseControlStartable(this.context, initializationContext);
        this.doStart(initializationContext, ccStartable);
    }

    void doStart(EngineInitializationContext initializationContext, CruiseControlStartable ccStartable) {
        if (this.isActive()) {
            LOG.warn("DataBalanceEngine already running when startUp requested.");
            return;
        }
        LOG.info("DataBalancer: Instantiating DataBalanceEngine");
        BalancerStatusTracker balancerStatusTracker = this.context.getBalancerStatusTracker();
        balancerStatusTracker.registerEnabledEventIfDisabled();
        OperationRetryer<KafkaCruiseControl> retryer = ccStartable.createStartupRetryer();
        KafkaCruiseControl cruiseControl = null;
        try {
            cruiseControl = retryer.runWithRetries(() -> {
                KafkaCruiseControl newCruiseControl = null;
                try {
                    if (this.abortStartupCheck.availablePermits() > 0) {
                        throw new StartupCheckInterruptedException();
                    }
                    newCruiseControl = ccStartable.createKafkaCruiseControl(this.abortStartupCheck);
                    Map<String, Object> clientConfigWithBootstrapServer = ccStartable.generateClientConfigs();
                    ApiStatePersistenceStore persistenceStore = new ApiStatePersistenceStore(initializationContext.kafkaConfig(), this.context.getTime(), clientConfigWithBootstrapServer);
                    this.context.init(persistenceStore);
                    this.context.brokerAdditionContextContainer().initializeV2BrokerAdditionStateManager(persistenceStore);
                    newCruiseControl.startUp(this.context.getPersistenceStore(), this.context.brokerAdditionContextContainer().brokerAdditionV2StateManager());
                    return RetryableResult.Success.of(newCruiseControl);
                }
                catch (BalancerJbodEnabledMisconfigurationException je) {
                    balancerStatusTracker.registerEvent(BalancerStatusStateMachine.BalancerEvent.JBOD_ENABLED, (Exception)((Object)je));
                    this.handleStartupFailure(newCruiseControl, "Unable to start up DataBalanceEngine as JBOD is enabled", je);
                    return RetryableResult.Failure.instance();
                }
                catch (StartupCheckInterruptedException e) {
                    this.handleStartupFailure(newCruiseControl, "DataBalanceEngine startup aborted by shutdown.", e);
                    return RetryableResult.Failure.instance();
                }
                catch (Throwable e) {
                    this.handleStartupFailure(newCruiseControl, "DataBalancer: Failed when starting up DataBalanceEngine", e);
                    return RetryableResult.Incomplete.instance();
                }
            });
        }
        catch (Exception e) {
            LOG.error("DataBalancer: Failed to start DataBalanceEngine even after retrying multiple times.", (Throwable)e);
            balancerStatusTracker.registerEvent(BalancerStatusStateMachine.BalancerEvent.CRUISE_CONTROL_ERRORED, (Exception)new CruiseControlException(e));
        }
        if (cruiseControl == null) {
            LOG.error("DataBalancer: Unable to start DataBalancer, either because startup was canceled or it failed to start after multiple retries.");
            return;
        }
        try {
            this.resubmitPendingOperations(initializationContext);
        }
        catch (Exception ex) {
            LOG.error("DataBalancer: Unable to restart pending operations.", (Throwable)ex);
        }
        balancerStatusTracker.registerEvent(BalancerStatusStateMachine.BalancerEvent.CRUISE_CONTROL_INITIALIZATION_COMPLETED);
        this.setAutoHealMode(DatabalancerUtils.anyUnevenLoadEnabled(initializationContext.kafkaConfig()));
        this.context.setCruiseControl(cruiseControl);
        LOG.info("DataBalancer: DataBalanceEngine started");
    }

    private void handleStartupFailure(KafkaCruiseControl maybeCruiseControl, String errorMsg, Throwable e) {
        LOG.warn(errorMsg, e);
        if (maybeCruiseControl != null) {
            maybeCruiseControl.shutdown();
        }
        this.context.closeAndClearState();
    }

    private void resubmitPendingOperations(EngineInitializationContext initializationContext) {
        ApiStatePersistenceStore persistenceStore = this.context.getPersistenceStore();
        Set pendingRemovals = persistenceStore.getAllBrokerRemovalStateRecords().values().stream().filter(status -> !BrokerRemovalStateMachine.isStateTerminal(status.state())).collect(Collectors.toSet());
        if (pendingRemovals.isEmpty()) {
            LOG.info("No pending DataBalancer operations found at startup.");
            return;
        }
        for (BrokerRemovalStateRecord removalStateRecord : pendingRemovals) {
            PersistRemoveApiStateListener listener = new PersistRemoveApiStateListener(this.context.getPersistenceStore(), removalStateRecord.shouldShutdown());
            ImmutableSet<Integer> brokerIds = removalStateRecord.brokerIds();
            BrokerRemovalStateMachine.BrokerRemovalState pendingState = removalStateRecord.state();
            BrokerRemovalStateTracker stateTracker = new BrokerRemovalStateTracker(brokerIds, pendingState, listener, this.removalTerminationListener, this.brokerRemovalMetricRegistry.registerBrokerRemovalMetric(brokerIds), this.context.getTime());
            String uuid = BrokerRemovalCallback.uuid(brokerIds, this.context.getTime().milliseconds());
            AliveBrokersMetadata brokersMetadata = initializationContext.aliveBrokersMetadata().orElse((AliveBrokersMetadata)AliveBrokersSnapshot.EMPTY_SNAPSHOT);
            this.submitRemoveBroker(brokerIds.stream().collect(Collectors.toMap(k -> k, arg_0 -> ((AliveBrokersMetadata)brokersMetadata).epochFor(arg_0))), removalStateRecord.shouldShutdown(), stateTracker, uuid);
            LOG.info("Submitted pending operation {} to remove broker ids {} with state {}.", new Object[]{uuid, brokerIds, pendingState});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopCruiseControl(KafkaCruiseControl cruiseControl, BalancerStatusStateMachine.BalancerEvent event, Optional<BalancerStatusTracker> balancerStatusTracker) {
        String shutdownReason = String.format("DataBalanceEngine Shutdown due to %s", event.name());
        LOG.info("DataBalancer: Commencing {}", (Object)shutdownReason);
        try {
            cruiseControl.triggerStopExecution(shutdownReason);
            this.context.closeAndClearState();
        }
        catch (Exception ex) {
            LOG.warn("Unable to stop DataBalanceEngine due to {}", (Object)event.name(), (Object)ex);
        }
        finally {
            balancerStatusTracker.ifPresent(statusTracker -> statusTracker.registerEvent(event));
        }
        LOG.info("DataBalancer: {} completed.", (Object)shutdownReason);
    }

    void doAddBrokers(KafkaCruiseControl cc, MultiBrokerAdditionOperation additionOperation, BalanceOpExecutionCompletionCallback executionCompletionCallback, String operationUid) {
        if (additionOperation.brokerIds().isEmpty()) {
            LOG.info("Will not be proceeding with the add broker operation as no new brokers were supplied.");
            return;
        }
        LOG.info("DataBalancer: Starting addBrokers call for brokers {} (UUID {})", additionOperation.brokerIds(), (Object)operationUid);
        try {
            cc.addBrokers(additionOperation, executionCompletionCallback, operationUid);
        }
        catch (Exception ex) {
            LOG.warn("Broker addition for brokers {} (UUID {}) failed", new Object[]{additionOperation.brokerIds(), operationUid, ex});
        }
    }

    @Override
    public List<CellLoad> cellLoad(List<Integer> cellIds) throws Exception {
        Optional<KafkaCruiseControl> maybeCruiseControl = this.context.getCruiseControl();
        List<CellLoad> cellLoad = Collections.emptyList();
        if (maybeCruiseControl.isPresent()) {
            cellLoad = maybeCruiseControl.get().cellLoad(cellIds);
        }
        return cellLoad;
    }
}

