/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfigDelta;
import io.confluent.databalancer.BrokerChangeEvent;
import io.confluent.databalancer.DataBalanceEngine;
import io.confluent.databalancer.DataBalanceEngineContext;
import io.confluent.databalancer.EngineInitializationContext;
import io.confluent.databalancer.operation.BalancerStatusStateMachine;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kafka.common.AliveBrokersMetadata;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpDataBalanceEngine
implements DataBalanceEngine {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpDataBalanceEngine.class);

    @Override
    public DataBalanceEngineContext getDataBalanceEngineContext() {
        return null;
    }

    @Override
    public void onActivation(EngineInitializationContext initializationContext) {
    }

    @Override
    public void onDeactivation(BalancerStatusStateMachine.BalancerEvent event) {
    }

    @Override
    public void shutdown(KafkaConfig kafkaConfig) {
    }

    @Override
    public void updateThrottle(Long newThrottle) {
    }

    @Override
    public void setAutoHealMode(boolean shouldAutoHeal) {
    }

    @Override
    public void updateConfigPermanently(String configKey, Object configValue) {
    }

    @Override
    public void updateConfigPermanently(SbcGoalsConfigDelta sbcGoalsConfigDelta) {
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void removeBrokers(Map<Integer, Optional<Long>> brokersToRemoveAndEpochs, boolean shouldShutdown, String uid) {
        String msg = String.format("Received request to remove brokers %s (uid %s, shouldShutdown %s) while DataBalancer is not started.", brokersToRemoveAndEpochs, uid, shouldShutdown);
        LOG.error(msg);
        throw new InvalidRequestException(msg);
    }

    @Override
    public void addBrokers(Set<Integer> brokersToAdd, String uid, AliveBrokersMetadata brokersMetadata) {
        String msg = String.format("Ignoring request to add brokers %s while DataBalancer is not started.", brokersToAdd);
        LOG.warn(msg);
    }

    @Override
    public boolean cancelBrokerRemoval(Set<Integer> brokerIds, String reason) {
        String msg = String.format("Ignoring request to cancel brokers removals for brokers %s while DataBalancer is not started.", brokerIds);
        LOG.warn(msg);
        return false;
    }

    @Override
    public void notifyBrokerChange(Set<Integer> changedBrokers, BrokerChangeEvent event) {
        String msg = String.format("Ignoring notification of change event %s in brokers %s while DataBalancer is not started.", new Object[]{event, changedBrokers});
        LOG.warn(msg);
    }

    @Override
    public void triggerEvenClusterLoadTask(String uuid) {
        String msg = "Received request to trigger the even cluster load status while DataBalancer is disabled.";
        LOG.error(msg);
        throw new BalancerOfflineException(msg);
    }

    @Override
    public void computeEvenClusterLoadPlan(String uuid, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadPlanInternal> callback) {
        String msg = "Received request to compute an even cluster load plan while DataBalancer is disabled.";
        LOG.error(msg);
        throw new BalancerOfflineException(msg);
    }

    @Override
    public EvenClusterLoadStatusDescriptionInternal evenClusterLoadStatus(KafkaConfig kafkaConfig) {
        String msg = "Received request to describe the even cluster load status while DataBalancer is not started.";
        LOG.error(msg);
        throw new BalancerOfflineException(msg);
    }

    @Override
    public List<CellLoad> cellLoad(List<Integer> cellIds) {
        return Collections.emptyList();
    }
}

