/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import io.confluent.databalancer.DatabalancerUtils;
import io.confluent.databalancer.KafkaDataBalanceManager;
import io.confluent.databalancer.event.SbcEventQueue;
import io.confluent.databalancer.event.resource.BalancerResourceManager;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.utils.Time;

@NotThreadSafe
public class SbcContext {
    private final KafkaDataBalanceManager kdbm;
    private final BalancerResourceManager resourceManager;
    private final SbcEventQueue eventQueue;
    private final Time time;
    private final AtomicLong eventId = new AtomicLong(0L);
    private final KafkaConfig kafkaConfig;

    public SbcContext(KafkaDataBalanceManager kdbm, SbcEventQueue eventQueue, BalancerResourceManager resourceManager, KafkaConfig kafkaConfig, Time time) {
        this.time = time;
        this.kdbm = kdbm;
        this.resourceManager = resourceManager;
        this.eventQueue = eventQueue;
        this.kafkaConfig = kafkaConfig;
    }

    public KafkaDataBalanceManager kafkaDataBalanceManager() {
        return this.kdbm;
    }

    public BalancerResourceManager resourceManager() {
        return this.resourceManager;
    }

    public SbcEventQueue eventQueue() {
        return this.eventQueue;
    }

    public Time time() {
        return this.time;
    }

    public long generateEventId() {
        return this.eventId.incrementAndGet();
    }

    public synchronized KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public long taskHistoryRetentionMs() {
        return DatabalancerUtils.taskHistoryRetentionMs(this.kafkaConfig());
    }
}

