/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import com.linkedin.kafka.cruisecontrol.operation.MultiBrokerAdditionOperation;
import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import io.confluent.databalancer.operation.BrokerAdditionStateManager;
import io.confluent.databalancer.operation.BrokerAdditionV1Context;
import io.confluent.databalancer.operation.BrokerAdditionV2StateManager;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import kafka.common.BrokerAdditionDescriptionInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BrokerAdditionContextContainer {
    private final BrokerAdditionV1Context additionV1Context;
    private BrokerAdditionV2StateManager brokerAdditionV2StateManager;
    private boolean additionV2Enabled = false;
    private final boolean incrementalBalancingEnabled;
    private static final Logger LOG = LoggerFactory.getLogger(BrokerAdditionContextContainer.class);

    public BrokerAdditionContextContainer(BrokerAdditionV1Context additionV1Context, BrokerAdditionV2StateManager additionV2StateManager, boolean incrementalBalancingEnabled, boolean v2AdditionEnabled) {
        this.additionV1Context = additionV1Context;
        this.brokerAdditionV2StateManager = additionV2StateManager;
        this.incrementalBalancingEnabled = incrementalBalancingEnabled;
        this.additionV2Enabled = v2AdditionEnabled;
    }

    public boolean isV2AdditionEnabled() {
        return this.incrementalBalancingEnabled && this.additionV2Enabled;
    }

    public synchronized MultiBrokerAdditionOperation initializeV1BrokerAddition(Set<Integer> brokersToAdd) {
        HashMap<Integer, BrokerAdditionStateManager> brokerAdditionCallbacks = new HashMap<Integer, BrokerAdditionStateManager>();
        for (Integer brokerId : brokersToAdd) {
            BrokerAdditionStateManager stateManager = this.additionV1Context.initializeAddition(brokerId);
            brokerAdditionCallbacks.put(brokerId, stateManager);
        }
        return new MultiBrokerAdditionOperation(brokerAdditionCallbacks.keySet(), new ArrayList<BrokerAdditionStateManager>(brokerAdditionCallbacks.values()));
    }

    public synchronized Set<Integer> initializeV2BrokerAddition(Set<Integer> brokersToAdd) throws InterruptedException {
        HashSet<Integer> additionsToInitialize = new HashSet<Integer>(brokersToAdd);
        additionsToInitialize.removeAll(this.brokersBeingAdded());
        for (Integer brokerId : additionsToInitialize) {
            this.brokerAdditionV2StateManager.initializeAddition(brokerId);
        }
        return additionsToInitialize;
    }

    public synchronized void initializeV2BrokerAdditionStateManager(ApiStatePersistenceStore apiStatePersistenceStore) {
        this.brokerAdditionV2StateManager = new BrokerAdditionV2StateManager(apiStatePersistenceStore);
    }

    public synchronized void overrideAllPendingBrokerAdditions(BrokerAdditionStateMachine.AdditionEvent event, String cause) {
        if (!this.isV2AdditionEnabled()) {
            this.additionV1Context.overrideAllPendingBrokerAdditions(event.event, cause);
            return;
        }
        if (event.event != BrokerAdditionStateMachine.BrokerAdditionEvent.BROKER_REMOVAL_REQUEST_OVERRIDES) {
            LOG.debug("Will not attempt to override any pending v2 broker additions due to a {} event.", (Object)event.event);
            return;
        }
        HashSet<Integer> cancelledAdditions = new HashSet<Integer>();
        for (int brokerId : event.affectedBrokerIds) {
            try {
                boolean canceled = this.brokerAdditionV2StateManager.maybeCancelAddition(brokerId, cause);
                if (!canceled) continue;
                cancelledAdditions.add(brokerId);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while trying to cancel broker addition for broker {}", (Object)brokerId, (Object)e);
                throw new RuntimeException(e);
            }
        }
        if (!cancelledAdditions.isEmpty()) {
            LOG.info("Cancelled broker additions for brokers {} due to {}", cancelledAdditions, (Object)event.event);
        }
    }

    public synchronized Set<Integer> brokersBeingAdded() {
        if (this.isV2AdditionEnabled()) {
            return this.brokerAdditionV2StateManager.pendingBrokerAdditions().stream().map(b -> b.brokerId).collect(Collectors.toSet());
        }
        return this.additionV1Context.brokersBeingAdded();
    }

    public synchronized List<BrokerAdditionDescriptionInternal> brokerAdditionsNewerThan(long cutOffTimeMs) {
        return (this.isV2AdditionEnabled() ? this.brokerAdditionV2StateManager.brokerAdditionDescriptions() : this.additionV1Context.brokerAdditions()).stream().filter(description -> description.lastUpdateTimeMs() > cutOffTimeMs).collect(Collectors.toList());
    }

    public BrokerAdditionV2StateManager brokerAdditionV2StateManager() {
        return this.brokerAdditionV2StateManager;
    }
}

