/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BalancerOperationEvent;
import io.confluent.databalancer.operation.BalancerOperationState;
import io.confluent.databalancer.operation.StateMachine;
import io.confluent.databalancer.operation.StateTransitioner;
import io.confluent.databalancer.persistence.BrokerAdditionStateRecord;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;

public class BrokerAdditionV2StateMachine
extends StateMachine<BrokerAdditionV2State, BrokerAdditionV2Event> {
    private static final String OPERATION_NAME = "Broker Addition v2";
    private static final StateTransitioner<BrokerAdditionV2State, BrokerAdditionV2Event> TRANSITIONER = new StateTransitioner.Builder().with(BrokerAdditionV2StateMachine.transition().from(BrokerAdditionV2State.IN_PROGRESS).to(BrokerAdditionV2State.COMPLETED).when(new BrokerAdditionV2Event[]{BrokerAdditionV2Event.SUCCESS})).with(BrokerAdditionV2StateMachine.transition().from(BrokerAdditionV2State.IN_PROGRESS).to(BrokerAdditionV2State.CANCELED).when(new BrokerAdditionV2Event[]{BrokerAdditionV2Event.CANCELED})).build();
    static final BrokerAdditionV2State START_STATE = BrokerAdditionV2State.IN_PROGRESS;

    public BrokerAdditionV2StateMachine(int brokerId) {
        this(brokerId, START_STATE, SystemTime.SYSTEM);
    }

    public BrokerAdditionV2StateMachine(BrokerAdditionStateRecord record) {
        super(record.brokerId(), OPERATION_NAME, record.state(), record.startTimeMs(), record.lastUpdateTimeMs(), SystemTime.SYSTEM);
    }

    BrokerAdditionV2StateMachine(int brokerId, BrokerAdditionV2State state, Time time) {
        super(brokerId, OPERATION_NAME, state, time);
    }

    public int brokerId() {
        Optional brokerId = this.brokerIds.stream().findFirst();
        if (!brokerId.isPresent()) {
            throw new IllegalStateException("No broker id is present in this v2 addition state machine.");
        }
        return (Integer)brokerId.get();
    }

    private static StateTransitioner.TransitionBuilder<BrokerAdditionV2State, BrokerAdditionV2Event> transition() {
        return new StateTransitioner.TransitionBuilder<BrokerAdditionV2State, BrokerAdditionV2Event>();
    }

    @Override
    StateTransitioner<BrokerAdditionV2State, BrokerAdditionV2Event> transitioner() {
        return TRANSITIONER;
    }

    public static BalancerOperationStatus convertBrokerAdditionV2Status(PartitionReassignmentsStatus partitionReassignmentsStatus) {
        if (partitionReassignmentsStatus == PartitionReassignmentsStatus.COMPLETED) {
            return BalancerOperationStatus.SUCCESS;
        }
        if (partitionReassignmentsStatus == PartitionReassignmentsStatus.IN_PROGRESS) {
            return BalancerOperationStatus.IN_PROGRESS;
        }
        if (partitionReassignmentsStatus == PartitionReassignmentsStatus.CANCELED) {
            return BalancerOperationStatus.FAILED;
        }
        throw new IllegalArgumentException("Unexpected partition reassignment status for a v2 addition operation: " + partitionReassignmentsStatus);
    }

    @Immutable
    public static enum BrokerAdditionV2State implements BalancerOperationState
    {
        IN_PROGRESS(PartitionReassignmentsStatus.IN_PROGRESS),
        COMPLETED(PartitionReassignmentsStatus.COMPLETED, true),
        CANCELED(PartitionReassignmentsStatus.CANCELED, true);

        private final PartitionReassignmentsStatus status;
        private final boolean isTerminal;

        private BrokerAdditionV2State(PartitionReassignmentsStatus status) {
            this(status, false);
        }

        private BrokerAdditionV2State(PartitionReassignmentsStatus status, boolean isTerminal) {
            this.status = status;
            this.isTerminal = isTerminal;
        }

        public PartitionReassignmentsStatus status() {
            return this.status;
        }

        @Override
        public boolean isTerminal() {
            return this.isTerminal;
        }
    }

    public static enum BrokerAdditionV2Event implements BalancerOperationEvent
    {
        CANCELED,
        SUCCESS;

    }
}

