/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import kafka.security.authorizer.AclEntry;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

public class LinkContext
implements MessageContext {
    private final String localTenantAndClusterLinkPrefix;
    private final String localTenantPrefix;
    private final String linkName;
    private final Boolean clusterLinkPrefixConsumerGroup;

    public LinkContext(String localTenantPrefix, String clusterLinkPrefix, String linkName, Boolean prefixConsumerGroupWithClusterPrefix) {
        this.localTenantAndClusterLinkPrefix = localTenantPrefix + clusterLinkPrefix;
        this.localTenantPrefix = localTenantPrefix;
        this.linkName = linkName;
        this.clusterLinkPrefixConsumerGroup = prefixConsumerGroupWithClusterPrefix;
    }

    private String destToSource(String name, String prefix) {
        if (name == null) {
            return null;
        }
        if (name.isEmpty()) {
            return name;
        }
        if (!name.startsWith(prefix)) {
            throw new IllegalStateException("Name does not start with prefix " + prefix + " : " + name);
        }
        return name.substring(prefix.length());
    }

    private String sourceToDest(String name, String prefix) {
        if (name == null) {
            return null;
        }
        return prefix + name;
    }

    public String linkName() {
        return this.linkName;
    }

    public String write(EntityType entityType, String value) {
        switch (entityType) {
            case TOPIC_NAME: {
                return this.destToSource(value, this.localTenantAndClusterLinkPrefix);
            }
            case LINK_NAME: {
                return this.destToSource(value, this.localTenantPrefix);
            }
            case COORDINATOR_KEY: 
            case GROUP_ID: {
                if (this.clusterLinkPrefixConsumerGroup.booleanValue()) {
                    return this.destToSource(value, this.localTenantAndClusterLinkPrefix);
                }
                return this.destToSource(value, this.localTenantPrefix);
            }
            case TRANSACTIONAL_ID: {
                throw new IllegalStateException("TRANSACTIONAL_ID is not a supported entity type");
            }
            case CLUSTER_ID: {
                if (this.localTenantPrefix.isEmpty()) {
                    return value;
                }
                return this.localTenantPrefix.substring(0, this.localTenantPrefix.length() - 1);
            }
        }
        return value;
    }

    public Message write(EntityType entityType, Message value) {
        Message duplicate = value.duplicate();
        switch (entityType) {
            case CONFIG_RESOURCE: {
                if (!(duplicate instanceof DescribeConfigsRequestData.DescribeConfigsResource)) break;
                this.transformDestToSource((DescribeConfigsRequestData.DescribeConfigsResource)duplicate);
                break;
            }
            case ACL_RESOURCE: 
            case ACL_RESOURCE_FILTER: {
                break;
            }
        }
        return duplicate;
    }

    public String read(EntityType entityType, String value) {
        switch (entityType) {
            case TOPIC_NAME: {
                return this.sourceToDest(value, this.localTenantAndClusterLinkPrefix);
            }
            case LINK_NAME: {
                return this.sourceToDest(value, this.localTenantPrefix);
            }
            case COORDINATOR_KEY: 
            case GROUP_ID: {
                if (this.clusterLinkPrefixConsumerGroup.booleanValue()) {
                    return this.sourceToDest(value, this.localTenantAndClusterLinkPrefix);
                }
                return this.sourceToDest(value, this.localTenantPrefix);
            }
            case ACL_PRINCIPAL: {
                return this.sourceToDestAclPrincipal(value);
            }
            case TRANSACTIONAL_ID: {
                throw new IllegalStateException("TRANSACTIONAL_ID is not a supported entity type");
            }
        }
        return value;
    }

    public Message read(EntityType entityType, Message value) {
        switch (entityType) {
            case CONFIG_RESOURCE: {
                if (!(value instanceof DescribeConfigsResponseData.DescribeConfigsResult)) break;
                this.transformSourceToDest((DescribeConfigsResponseData.DescribeConfigsResult)value);
                break;
            }
            case ACL_RESOURCE: {
                if (!(value instanceof DescribeAclsResponseData.DescribeAclsResource)) break;
                this.transformSourceToDest((DescribeAclsResponseData.DescribeAclsResource)value);
            }
        }
        return value;
    }

    protected void transformDestToSource(DescribeConfigsRequestData.DescribeConfigsResource resource) {
        ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)resource.resourceType());
        switch (resourceType) {
            case TOPIC: {
                resource.setResourceName(this.destToSource(resource.resourceName(), this.localTenantAndClusterLinkPrefix));
                break;
            }
            case CLUSTER_LINK: {
                resource.setResourceName(this.destToSource(resource.resourceName(), this.localTenantPrefix));
                break;
            }
        }
    }

    protected void transformSourceToDest(DescribeConfigsResponseData.DescribeConfigsResult resource) {
        ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)resource.resourceType());
        switch (resourceType) {
            case TOPIC: {
                resource.setResourceName(this.sourceToDest(resource.resourceName(), this.localTenantAndClusterLinkPrefix));
                break;
            }
            case CLUSTER_LINK: {
                resource.setResourceName(this.sourceToDest(resource.resourceName(), this.localTenantPrefix));
                break;
            }
        }
    }

    private String sourceToDestAclPrincipal(String principal) {
        if (principal == null) {
            return null;
        }
        if (this.localTenantPrefix.isEmpty()) {
            return principal;
        }
        KafkaPrincipal kafkaPrincipal = SecurityUtils.parseKafkaPrincipal((String)principal);
        if (kafkaPrincipal.equals((Object)AclEntry.WildcardPrincipal())) {
            return "TenantUser*:" + this.localTenantPrefix;
        }
        String transformed = this.sourceToDest(kafkaPrincipal.getName(), this.localTenantPrefix);
        return "TenantUser:" + transformed;
    }

    private void transformSourceToDest(DescribeAclsResponseData.DescribeAclsResource resource) {
        if (this.localTenantPrefix.isEmpty()) {
            return;
        }
        if (this.isTransformRequired(ResourceType.fromCode((byte)resource.resourceType()))) {
            resource.setResourceName(this.sourceToDest(resource.resourceName(), this.localTenantPrefix));
        }
        PatternType patternType = PatternType.fromCode((byte)resource.patternType());
        String resourceName = resource.resourceName();
        String wildcard = this.localTenantPrefix + "*";
        if (patternType == PatternType.LITERAL && wildcard.equals(resourceName)) {
            resource.setResourceName(this.localTenantPrefix);
            resource.setPatternType(PatternType.PREFIXED.code());
        }
    }

    protected boolean isTransformRequired(ResourceType resourceType) {
        switch (resourceType) {
            case TOPIC: 
            case GROUP: 
            case TRANSACTIONAL_ID: 
            case CLUSTER: 
            case ANY: {
                return true;
            }
        }
        return false;
    }
}

