/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import io.confluent.kafka.common.multitenant.oauth.OauthMayActClaim;
import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.IdentityMetadata;
import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantSaslServer;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.trustservice.store.data.IdentityPool;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.message.DefaultPrincipalData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantPrincipalBuilder
implements KafkaPrincipalBuilder,
KafkaPrincipalSerde,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantPrincipalBuilder.class);
    private static final String CONFLUENT_ISSUER = "Confluent";
    private static final String OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY = "OAUTHBEARER.token";
    public static final String CCLOUD_INTERNAL_USER = "0";
    private static final String RESOURCE_ID_SERVICE_ACCOUNT_PREFIX = "sa-";
    private static final MetricName ORG_PROPS_METRIC_NAME = KafkaYammerMetrics.getMetricName((String)"kafka.multitenant", (String)MultiTenantPrincipalBuilder.class.getSimpleName(), (String)"org-props-missing-rate");
    private static final Meter ORG_PROPS_MISSING_METER = KafkaYammerMetrics.defaultRegistry().newMeter(ORG_PROPS_METRIC_NAME, "org-props-missing", TimeUnit.SECONDS);
    private BasePhysicalClusterMetadata<?> physicalClusterMetadata;
    private final DefaultKafkaPrincipalBuilder defaultKafkaPrincipalBuilder = new DefaultKafkaPrincipalBuilder(null, null);
    private AuthStore store;

    public void configure(Map<String, ?> configs) {
        this.physicalClusterMetadata = BasePhysicalClusterMetadata.getInstance((String)AuthUtils.getBrokerSessionUuid(configs));
        String uuid = AuthUtils.getBrokerSessionUuid(configs);
        this.store = AuthStore.getInstance((String)uuid);
    }

    public KafkaPrincipal build(AuthenticationContext context) {
        if (context instanceof SaslAuthenticationContext) {
            return this.createKafkaPrincipalfromSaslContext((SaslAuthenticationContext)context);
        }
        if (context instanceof SslAuthenticationContext) {
            return this.createKafkaPrincipalfromSslContext((SslAuthenticationContext)context);
        }
        if (context instanceof PlaintextAuthenticationContext) {
            return this.createKafkaPrincipalPlain();
        }
        throw new IllegalArgumentException("Unhandled authentication context type: " + context.getClass().getName());
    }

    private KafkaPrincipal createKafkaPrincipalPlain() {
        return KafkaPrincipal.ANONYMOUS;
    }

    private KafkaPrincipal createKafkaPrincipalfromSslContext(SslAuthenticationContext context) {
        SSLSession sslSession = context.session();
        try {
            Principal sslPrincipal = sslSession.getPeerPrincipal();
            return new KafkaPrincipal("User", sslPrincipal.getName());
        }
        catch (SSLPeerUnverifiedException se) {
            return KafkaPrincipal.ANONYMOUS;
        }
    }

    private KafkaPrincipal createKafkaPrincipalfromSaslContext(SaslAuthenticationContext context) {
        SaslServer saslServer = context.server();
        String authId = saslServer.getAuthorizationID();
        if (saslServer instanceof MultiTenantSaslServer) {
            MultiTenantSaslServer mtServer = (MultiTenantSaslServer)((Object)saslServer);
            TenantMetadata tenantMetadata = mtServer.tenantMetadata();
            this.updateTenantMetadata(tenantMetadata.clusterId, tenantMetadata, authId);
            return new MultiTenantPrincipal(authId, mtServer.authenticationId(), mtServer.networkId(), tenantMetadata, new IdentityMetadata(null, CONFLUENT_ISSUER, tenantMetadata.userResourceId, null));
        }
        if (saslServer instanceof OAuthBearerSaslServer) {
            OAuthBearerSaslServer server = (OAuthBearerSaslServer)saslServer;
            OAuthBearerJwsToken token = (OAuthBearerJwsToken)server.getNegotiatedProperty(OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY);
            String logicalCluster = (String)server.getNegotiatedProperty("logicalCluster");
            String authorizedPartyClaim = (String)server.getNegotiatedProperty("identityPoolId-azp");
            String subjectClaim = (String)server.getNegotiatedProperty("identityPoolId-sub");
            String poolId = (String)server.getNegotiatedProperty("identityPoolId");
            if (authorizedPartyClaim == null ^ subjectClaim == null) {
                throw new IllegalArgumentException("Unhandled identity pool context: authorizedPartyClaim = " + authorizedPartyClaim + ", subjectClaim = " + subjectClaim);
            }
            TenantMetadata tenantMetadata = new TenantMetadata.Builder(logicalCluster, subjectClaim == null ? this.userResourceId(token) : subjectClaim).serviceAccount(subjectClaim != null || this.isServiceAccount(token)).apiKeyAuthenticated(false).build();
            IdentityMetadata.Builder builder = new IdentityMetadata.Builder();
            builder.poolId(poolId);
            authId = subjectClaim == null ? token.principalName() : subjectClaim;
            List<Object> authorizationIds = Collections.emptyList();
            if (token.issuer() != null && token.issuer().equals(CONFLUENT_ISSUER)) {
                builder.providerId(CONFLUENT_ISSUER);
                builder.identity(this.userResourceId(token));
                authorizationIds = this.authorizationIds(token);
            }
            if (poolId != null) {
                IdentityPool pool = this.store.trustCache().identityPool(poolId);
                builder.providerId((String)(pool.providerId() != null && pool.providerId().isEmpty() ? null : pool.providerId()));
                builder.identity(authorizedPartyClaim);
                authorizationIds = Collections.singletonList(poolId);
            }
            builder.externalIdentityId(this.oauthClaim(token, "externalIdentityId"));
            IdentityMetadata identityMetadata = builder.build();
            this.updateTenantMetadata(logicalCluster, tenantMetadata, authId);
            if (authorizationIds.size() == 0) {
                authorizationIds = Collections.singletonList(tenantMetadata.userResourceId);
            }
            return new MultiTenantPrincipal(authId, authorizedPartyClaim == null ? token.principalName() : authorizedPartyClaim, server.networkId(), tenantMetadata, identityMetadata, authorizationIds);
        }
        return new KafkaPrincipal("User", authId);
    }

    private List<String> authorizationIds(OAuthBearerJwsToken token) {
        if (token.jwtClaims().containsKey("may_act")) {
            try {
                JSONObject mayActJsonObject = new JSONObject((Map)token.jwtClaims().get("may_act"));
                OauthMayActClaim mayActValue = (OauthMayActClaim)new ObjectMapper().readValue(mayActJsonObject.toJSONString(), OauthMayActClaim.class);
                return mayActValue.principals();
            }
            catch (JsonProcessingException e) {
                log.error("Unable to parse the may_act claim");
                throw new IllegalArgumentException("Unable to parse the may_act claim");
            }
        }
        return Arrays.asList(this.userResourceId(token));
    }

    private void updateTenantMetadata(String clusterId, TenantMetadata tenantMetadata, String user) {
        boolean lkcMetadataAvailable = false;
        if (this.physicalClusterMetadata == null) {
            tenantMetadata.isHealthcheckTenant = false;
        } else {
            LogicalClusterMetadata lkcMetadata = this.physicalClusterMetadata.metadata(clusterId);
            lkcMetadataAvailable = lkcMetadata != null;
            boolean bl = tenantMetadata.isHealthcheckTenant = lkcMetadataAvailable && lkcMetadata.isHealthcheckLogicalCluster();
            if (lkcMetadataAvailable && lkcMetadata.organizationId() != null && lkcMetadata.environmentId() != null) {
                tenantMetadata.updateOrgProperties(lkcMetadata.organizationId(), lkcMetadata.environmentId());
            } else if (lkcMetadataAvailable) {
                ORG_PROPS_MISSING_METER.mark();
                log.warn("Org Properties is missing for user {}, userResourceId {} and clusterId {}", new Object[]{user, tenantMetadata.userResourceId, clusterId});
            }
        }
        if (!lkcMetadataAvailable) {
            ORG_PROPS_MISSING_METER.mark();
            log.warn("LKC Metadata is unavailable due to " + (this.physicalClusterMetadata == null ? "physicalClusterMetadata=null" : "no metadata for cluster " + clusterId));
        }
    }

    private boolean isServiceAccount(OAuthBearerJwsToken token) {
        String userResourceId = this.userResourceId(token);
        return userResourceId != null && userResourceId.startsWith(RESOURCE_ID_SERVICE_ACCOUNT_PREFIX);
    }

    public String userResourceId(OAuthBearerJwsToken token) {
        return this.oauthClaim(token, "userResourceId");
    }

    public String oauthClaim(OAuthBearerJwsToken token, String claimKey) {
        Object oauthClaim = token.jwtClaims().get(claimKey);
        return oauthClaim != null ? oauthClaim.toString() : null;
    }

    public byte[] serialize(KafkaPrincipal principal) throws SerializationException {
        if (principal instanceof MultiTenantPrincipal) {
            DefaultPrincipalData data = new DefaultPrincipalData();
            MultiTenantPrincipal mtp = (MultiTenantPrincipal)principal;
            TenantMetadata tm = mtp.tenantMetadata();
            Optional im = mtp.maybeGetIdentityMetadata();
            data.setType(mtp.getPrincipalType()).setName(mtp.getName().substring(tm.tenantName.length() + "_".length())).setSaslAuthenticationId(mtp.authenticationId()).setTenantName(tm.tenantName).setClusterId(tm.clusterId).setOrganizationId(tm.organizationId).setEnvironmentId(tm.environmentId).setServiceAccount(tm.isServiceAccount).setApiKeyAuthenticated(tm.isApiKeyAuthenticated).setHealthcheckTenant(tm.isHealthcheckTenant).setUserResourceId(tm.userResourceId).setIdentity((String)im.map(IdentityMetadata::identity).orElse(null)).setPoolId((String)im.map(IdentityMetadata::poolId).orElse(null)).setProviderId((String)im.map(IdentityMetadata::providerId).orElse(null)).setAuthorizationIds(mtp.authorizationIds()).setExternalIdentityId((String)im.map(IdentityMetadata::externalIdentityId).orElse(null));
            return MessageUtil.toVersionPrefixedBytes((short)0, (Message)data);
        }
        return this.defaultKafkaPrincipalBuilder.serialize(principal);
    }

    public KafkaPrincipal deserialize(byte[] bytes) throws SerializationException {
        DefaultPrincipalData data;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short version = buffer.getShort();
        if (version < 0 || version > 0) {
            throw new SerializationException("Invalid principal data version " + version);
        }
        try {
            data = new DefaultPrincipalData((Readable)new ByteBufferAccessor(buffer), version);
        }
        catch (Throwable t) {
            throw new SerializationException("Failed to deserialize principal", t);
        }
        if (buffer.hasRemaining()) {
            throw new SerializationException("Failed to deserialize principal: " + buffer.remaining() + " bytes remaining after parsing");
        }
        String type = data.type();
        if (type.equals("User")) {
            return this.defaultKafkaPrincipalBuilder.deserialize(bytes);
        }
        if (type.equals("TenantUser")) {
            String tenantName = data.tenantName();
            String user = data.name();
            return new MultiTenantPrincipal(user, data.saslAuthenticationId(), Optional.empty(), new TenantMetadata(tenantName, data.clusterId(), data.organizationId(), data.environmentId(), data.userResourceId(), data.serviceAccount(), data.apiKeyAuthenticated(), data.healthcheckTenant()), new IdentityMetadata(data.poolId(), data.providerId(), data.identity(), data.externalIdentityId()), data.authorizationIds());
        }
        throw new SerializationException(String.format("Invalid principal type '%s', expected '%s' or '%s'", type, "User", "TenantUser"));
    }
}

