/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.multitenant.CommonTopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.SslCertificateManager;
import io.confluent.kafka.multitenant.TenantLifecycleManager;
import io.confluent.kafka.multitenant.quota.QuotaConfig;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.util.KafkaBasedLog;

public class TopicBasedPhysicalClusterMetadata
extends CommonTopicBasedPhysicalClusterMetadata<KafkaLogicalClusterMetadata> {
    public TenantLifecycleManager tenantLifecycleManager;
    public SslCertificateManager sslCertificateManager;
    private final AtomicReference<CommonTopicBasedPhysicalClusterMetadata.State> sslCertManagerState;
    private final AtomicBoolean startedMonitoringDeactivatedClusters = new AtomicBoolean(false);
    private long updateDeactivatedTenantsIntervalMs;
    private static final String LKC_LOAD_METRICS_GROUP_NAME = "confluent-lkc-load-metrics";
    private static final String LKC_METADATA_END_TO_END_LOAD_TIME_SENSOR_NAME = "lkc-metadata-end-to-end-load-time";
    private static final String LKC_METADATA_STARTUP_LOAD_TIME_SENSOR_NAME = "lkc-metadata-startup-load-time";
    private static final String LKC_METADATA_END_TO_END_LOAD_TIME_MIN_METRIC_NAME = "lkc-metadata-end-to-end-load-time-min";
    private static final String LKC_METADATA_END_TO_END_LOAD_TIME_MAX_METRIC_NAME = "lkc-metadata-end-to-end-load-time-max";
    private static final String LKC_METADATA_END_TO_END_LOAD_TIME_AVG_METRIC_NAME = "lkc-metadata-end-to-end-load-time-avg";
    private static final String LKC_METADATA_STARTUP_LOAD_TIME_METRIC_NAME = "lkc-metadata-startup-load-time-max";
    private final Sensor lkcTimeToLoadEndToEndSensor;
    private final Sensor lkcStartupLoadSensor;
    private Set<String> kafkaLogicalClusterIds = new HashSet<String>();

    public TopicBasedPhysicalClusterMetadata(Metrics metrics) {
        this(metrics, Time.SYSTEM);
    }

    public TopicBasedPhysicalClusterMetadata(Metrics metrics, Time time) {
        super(metrics, time);
        this.lkcTimeToLoadEndToEndSensor = metrics.sensor(LKC_METADATA_END_TO_END_LOAD_TIME_SENSOR_NAME);
        this.lkcTimeToLoadEndToEndSensor.add(metrics.metricName(LKC_METADATA_END_TO_END_LOAD_TIME_MIN_METRIC_NAME, LKC_LOAD_METRICS_GROUP_NAME, "The minimum end to end load time of logical cluster metadata in ms"), (MeasurableStat)new Min());
        this.lkcTimeToLoadEndToEndSensor.add(metrics.metricName(LKC_METADATA_END_TO_END_LOAD_TIME_MAX_METRIC_NAME, LKC_LOAD_METRICS_GROUP_NAME, "The maximum end to end load time of logical cluster metadata in ms"), (MeasurableStat)new Max());
        this.lkcTimeToLoadEndToEndSensor.add(metrics.metricName(LKC_METADATA_END_TO_END_LOAD_TIME_AVG_METRIC_NAME, LKC_LOAD_METRICS_GROUP_NAME, "The mean end to end load time of logical cluster metadata in ms"), (MeasurableStat)new Avg());
        this.lkcStartupLoadSensor = metrics.sensor(LKC_METADATA_STARTUP_LOAD_TIME_SENSOR_NAME);
        this.lkcStartupLoadSensor.add(metrics.metricName(LKC_METADATA_STARTUP_LOAD_TIME_METRIC_NAME, LKC_LOAD_METRICS_GROUP_NAME, "The time it took for the first load of all logical cluster metadata from the topic in ms"), (MeasurableStat)new Max());
        this.sslCertManagerState = new AtomicReference<CommonTopicBasedPhysicalClusterMetadata.State>(CommonTopicBasedPhysicalClusterMetadata.State.NOT_READY);
    }

    void configure(CloudAdmin adminClient, String brokerId, String sslCertsPath, long deletedDelayMs, boolean deleteTenantCellMetadata, long updateDeactivatedTenantsIntervalMs, List<String> multitenantListenerNames) throws IOException {
        LOG.warn("configure(AdminClient, ConfluentAdmin, String, String) called, shouldn't happen outside tests (Ignore if this is a unittest.)");
        this.multitenantListenerNames = multitenantListenerNames;
        this.tenantLifecycleManager = new TenantLifecycleManager(deletedDelayMs, deleteTenantCellMetadata, adminClient, this.time);
        this.sslCertificateManager = new SslCertificateManager(brokerId, sslCertsPath, (ConfluentAdmin)adminClient, multitenantListenerNames);
        this.updateDeactivatedTenantsIntervalMs = updateDeactivatedTenantsIntervalMs;
        this.startWatchingSslCertificates();
    }

    void start(KafkaBasedLog<String, byte[]> kafkaBasedLog) {
        LOG.warn("start(KafkaBasedLog<>) called, shouldn't happen outside tests (Ignore if this is a unittest.)");
        if (!this.logConsumerState.compareAndSet(CommonTopicBasedPhysicalClusterMetadata.State.NOT_READY, CommonTopicBasedPhysicalClusterMetadata.State.STARTING)) {
            throw new IllegalStateException("start() called twice from the same unit test. Shouldn't happen!");
        }
        this.lcLog = kafkaBasedLog;
        this.startLog();
    }

    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this.multitenantListenerNames = ConfluentConfigs.multitenantListenerNames(configs, null);
        Long updateIntervalMsValue = (Long)configs.get("multitenant.tenant.delete.check.ms");
        if (updateIntervalMsValue == null) {
            updateIntervalMsValue = ConfluentConfigs.MULTITENANT_TENANT_DELETE_CHECK_MS_DEFAULT;
        }
        this.updateDeactivatedTenantsIntervalMs = updateIntervalMsValue;
        this.tenantLifecycleManager = new TenantLifecycleManager(configs, this.time);
        this.sslCertificateManager = new SslCertificateManager(configs);
        try {
            this.startWatchingSslCertificates();
        }
        catch (IOException ioe) {
            this.close(this.getSessionUuid(configs));
            throw new ConfigException("Failed to start watching the SSL certs watcher: " + ioe.getMessage());
        }
    }

    protected String getSessionUuid(Map<String, ?> configs) {
        return AuthUtils.getBrokerSessionUuid(configs);
    }

    protected Sensor getStartSensor() {
        return this.lkcStartupLoadSensor;
    }

    protected Sensor getEndToEndSensor() {
        return this.lkcTimeToLoadEndToEndSensor;
    }

    protected String getTopicConfig() {
        return "confluent.cdc.lkc.metadata.topic";
    }

    protected String getTopicClientId(Map<String, ?> configs) {
        return String.format("%s-%s-%s", this.topicName, ConfluentConfigs.ClientType.CONSUMER, configs.get("broker.session.uuid"));
    }

    public void handleSocketServerInitialized() {
        this.tenantLifecycleManager.createAdminClient(this.interBrokerClientConfig);
        this.sslCertificateManager.createAdminClient(this.interBrokerClientConfig);
        this.sslCertificateManager.loadSslCertFiles();
    }

    Map<Endpoint, CompletableFuture<Void>> endpointsToFutures(Collection<Endpoint> endpoints, CompletableFuture<Void> future) {
        if (this.multitenantListenerNames.isEmpty()) {
            LOG.warn("No multi-tenant listeners are specified. This could make the broker start without the tenant metadata available");
        }
        return endpoints.stream().collect(Collectors.toMap(Function.identity(), e -> this.multitenantListenerNames.contains(e.listenerName().orElse("")) ? future : CompletableFuture.completedFuture(null)));
    }

    public Map<Endpoint, CompletableFuture<Void>> start(Map<String, Object> interBrokerClientConfig, Collection<Endpoint> endpoints) {
        CompletableFuture<Void> logStartedFuture;
        this.interBrokerClientConfig = new HashMap<String, Object>(interBrokerClientConfig);
        if (this.logConsumerState.compareAndSet(CommonTopicBasedPhysicalClusterMetadata.State.NOT_READY, CommonTopicBasedPhysicalClusterMetadata.State.STARTING)) {
            this.lcLog = this.createKafkaBasedLog(interBrokerClientConfig);
            try {
                logStartedFuture = CompletableFuture.runAsync(() -> this.startLog());
            }
            catch (Exception e) {
                this.logConsumerState.set(CommonTopicBasedPhysicalClusterMetadata.State.FAILED_TO_START);
                throw new IllegalStateException("Unable to create a future for startLog()", e);
            }
        } else {
            this.ensureNonTerminalState((CommonTopicBasedPhysicalClusterMetadata.State)this.logConsumerState.get());
            LOG.warn("Trying to start a TopicBasedPhysicalClusterMetadata which was already started!");
            logStartedFuture = CompletableFuture.completedFuture(null);
        }
        return this.endpointsToFutures(endpoints, logStartedFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLog() {
        CommonTopicBasedPhysicalClusterMetadata.State currentState = (CommonTopicBasedPhysicalClusterMetadata.State)this.logConsumerState.get();
        if (currentState != CommonTopicBasedPhysicalClusterMetadata.State.STARTING) {
            throw new IllegalStateException("Trying to start a log which is in a non-starting state: " + currentState);
        }
        try {
            long startNano = this.time.nanoseconds();
            this.lcLog.start();
            Map map = this.logicalClusterMap;
            synchronized (map) {
                this.postUpdateBookkeeping();
                this.logConsumerState.set(CommonTopicBasedPhysicalClusterMetadata.State.RUNNING);
                this.startMonitoringDeactivatedTenants();
            }
            long loadTimeNano = this.time.nanoseconds() - startNano;
            this.getStartSensor().record((double)TimeUnit.NANOSECONDS.toMillis(loadTimeNano));
            LOG.info("Consumed initial set of {} lkcs metadata from topic {} in {} ns", new Object[]{this.logicalClusterMap.size(), this.topicName, loadTimeNano});
        }
        catch (Exception e) {
            this.logConsumerState.set(CommonTopicBasedPhysicalClusterMetadata.State.FAILED_TO_START);
            throw new IllegalStateException("Unable to start consuming lkc metadata from topic", e);
        }
    }

    protected void shutdown() {
        LOG.info("Shutting down");
        try {
            CommonTopicBasedPhysicalClusterMetadata.State prevSslCertManagerState = this.sslCertManagerState.getAndSet(CommonTopicBasedPhysicalClusterMetadata.State.CLOSED);
            if (prevSslCertManagerState.equals((Object)CommonTopicBasedPhysicalClusterMetadata.State.RUNNING) || prevSslCertManagerState.equals((Object)CommonTopicBasedPhysicalClusterMetadata.State.STARTING)) {
                this.sslCertificateManager.shutdown();
                this.sslCertificateManager.close();
            } else {
                LOG.info("Trying to close already closed sslCertificateManager");
            }
        }
        catch (Exception e) {
            LOG.error("Error when shutting down sslCertificateManager", (Throwable)e);
        }
        try {
            CommonTopicBasedPhysicalClusterMetadata.State prevLogState = this.logConsumerState.getAndSet(CommonTopicBasedPhysicalClusterMetadata.State.CLOSED);
            if (prevLogState.equals((Object)CommonTopicBasedPhysicalClusterMetadata.State.RUNNING) || prevLogState.equals((Object)CommonTopicBasedPhysicalClusterMetadata.State.STARTING)) {
                this.lcLog.stop();
            } else {
                LOG.info("Trying to close an lkcLog that was in a non-closable state: {}", (Object)prevLogState);
            }
        }
        catch (Exception e) {
            LOG.error("Error when shutting down lkcLog", (Throwable)e);
        }
        this.backgroundUpdatesExecutorService.shutdownNow();
        try {
            this.backgroundUpdatesExecutorService.awaitTermination(CLOSE_TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.debug("Shutting down was interrupted", (Throwable)e);
        }
        this.tenantLifecycleManager.close();
        LOG.info("Closed topic-based tenant cluster metadata store");
    }

    public String dedicatedLogicalClusterId() {
        if (this.kafkaLogicalClusterIds.size() == 1) {
            return (String)this.kafkaLogicalClusterIds.stream().findFirst().get();
        }
        return "";
    }

    public Set<String> kafkaLogicalClusterIds() {
        return this.kafkaLogicalClusterIds;
    }

    public Set<String> logicalClusterIds() {
        this.ensureOpen();
        return this.logicalClusterMap.entrySet().stream().filter(e -> ((CommonTopicBasedPhysicalClusterMetadata.LCMPair)e.getValue()).isActiveCluster()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void startWatchingSslCertificates() throws IOException {
        if (this.sslCertManagerState.compareAndSet(CommonTopicBasedPhysicalClusterMetadata.State.NOT_READY, CommonTopicBasedPhysicalClusterMetadata.State.RUNNING)) {
            try {
                this.sslCertificateManager.startWatching();
            }
            catch (IOException ioe) {
                this.sslCertManagerState.compareAndSet(CommonTopicBasedPhysicalClusterMetadata.State.RUNNING, CommonTopicBasedPhysicalClusterMetadata.State.NOT_READY);
                throw ioe;
            }
        } else {
            LOG.warn("startWatchingSslCertificates, but state is: " + this.sslCertManagerState.get().toString());
        }
    }

    protected KafkaLogicalClusterMetadata parseLCM(ConsumerRecord<String, byte[]> record) {
        KafkaLogicalClusterMetadata lcm = null;
        try {
            LogicalCluster asProto = LogicalCluster.parseFrom((byte[])((byte[])record.value()));
            lcm = KafkaLogicalClusterMetadata.fromProtobuf(asProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
        return lcm;
    }

    private void updateQuotas() {
        Map<String, QuotaConfig> tenantQuotas = this.logicalClusterMap.entrySet().stream().filter(e -> ((CommonTopicBasedPhysicalClusterMetadata.LCMPair)e.getValue()).isActiveCluster()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((KafkaLogicalClusterMetadata)((CommonTopicBasedPhysicalClusterMetadata.LCMPair)e.getValue()).getLCM()).quotaConfig()));
        TenantQuotaCallback.updateQuotas(tenantQuotas, QuotaConfig.UNLIMITED_QUOTA);
    }

    private void updateMaxPartitionsIfNecessary(KafkaLogicalClusterMetadata oldLcm, KafkaLogicalClusterMetadata newLcm) {
        if (!this.tenantLifecycleManager.updateMaxPartitionsIfNecessary(oldLcm, newLcm)) {
            LOG.info("updateMaxPartitionsIfNecessary() failed, rescheduling it");
            this.backgroundUpdatesExecutorService.schedule(() -> this.updateMaxPartitionsIfNecessary(oldLcm, newLcm), this.maxPartitionRetryDelayMs, TimeUnit.MILLISECONDS);
        }
    }

    protected void recordEndToEndSensor(KafkaLogicalClusterMetadata newLcm) {
        Date creationDate;
        if (newLcm.lifecycleMetadata() != null && (creationDate = newLcm.lifecycleMetadata().creationDate()) != null) {
            long endToEndLoadTime = this.time.milliseconds() - creationDate.getTime();
            this.getEndToEndSensor().record((double)endToEndLoadTime);
        }
    }

    private void updateTenant(KafkaLogicalClusterMetadata oldLcm, KafkaLogicalClusterMetadata newLcm) {
        if (CommonTopicBasedPhysicalClusterMetadata.State.RUNNING.equals(this.logConsumerState.get())) {
            if (newLcm != null) {
                LOG.info("Adding or updating lkc metadata for cluster: {}", (Object)newLcm.logicalClusterId());
                this.recordEndToEndSensor(newLcm);
                if (this.addOrUpdate(oldLcm, newLcm)) {
                    this.updateMaxPartitionsIfNecessary(oldLcm, newLcm);
                }
            } else {
                LOG.info("Deleting lkc metadata for cluster: {}", (Object)oldLcm.logicalClusterId());
            }
            this.postUpdateBookkeeping();
        }
    }

    protected void postUpdateBookkeeping() {
        this.updateNumberOfTenantsMetric();
        this.updateKafkaLogicalClusterIds();
        this.updateQuotas();
    }

    private void startMonitoringDeactivatedTenants() {
        if (this.updateDeactivatedTenantsIntervalMs < 1L) {
            LOG.error("The interval to check for deactivated tenants is set at {}. No tenants would be actually deleted (only deactivated!) and partitions and ACLs would leak!", (Object)this.updateDeactivatedTenantsIntervalMs);
            return;
        }
        if (!this.startedMonitoringDeactivatedClusters.getAndSet(true)) {
            this.backgroundUpdatesExecutorService.scheduleAtFixedRate(() -> this.updateDeactivatedTenants(), this.updateDeactivatedTenantsIntervalMs, this.updateDeactivatedTenantsIntervalMs, TimeUnit.MILLISECONDS);
        } else {
            LOG.info("startMonitoringDeactivatedTenants() called twice. Ignoring");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeactivatedTenants() {
        if (!CommonTopicBasedPhysicalClusterMetadata.State.RUNNING.equals(this.logConsumerState.get())) {
            return;
        }
        List deactivatedClusters = this.logicalClusterMap.values().stream().filter(CommonTopicBasedPhysicalClusterMetadata.LCMPair::exists).filter(p -> !p.isActiveCluster()).map(CommonTopicBasedPhysicalClusterMetadata.LCMPair::getLCM).collect(Collectors.toList());
        for (KafkaLogicalClusterMetadata lcm : deactivatedClusters) {
            this.tenantLifecycleManager.updateTenantState(lcm);
        }
        this.tenantLifecycleManager.deleteTenants();
        Set<String> fullyDeletedClusters = this.tenantLifecycleManager.fullyDeletedClusters();
        Map map = this.logicalClusterMap;
        synchronized (map) {
            for (String lkcId : fullyDeletedClusters) {
                CommonTopicBasedPhysicalClusterMetadata.LCMPair oldRecord = (CommonTopicBasedPhysicalClusterMetadata.LCMPair)this.logicalClusterMap.get(lkcId);
                if (oldRecord == null) continue;
                this.logicalClusterMap.put(lkcId, new CommonTopicBasedPhysicalClusterMetadata.LCMPair((CommonTopicBasedPhysicalClusterMetadata)this, oldRecord.getSequenceId(), null));
            }
        }
    }

    private void updateKafkaLogicalClusterIds() {
        this.kafkaLogicalClusterIds = this.logicalClusterMap.values().stream().filter(CommonTopicBasedPhysicalClusterMetadata.LCMPair::isActiveCluster).filter(e -> ((KafkaLogicalClusterMetadata)e.getLCM()).isKafkaLogicalCluster()).map(e -> ((KafkaLogicalClusterMetadata)e.getLCM()).logicalClusterId()).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLogicalCluster(String clusterId, Long sequenceId, KafkaLogicalClusterMetadata lcm) {
        if (!this.isStartingOrRunningState((CommonTopicBasedPhysicalClusterMetadata.State)this.logConsumerState.get())) {
            LOG.warn("Tried to add or update a logical cluster with a non running log (state = {})", this.logConsumerState.get());
        } else {
            Map map = this.logicalClusterMap;
            synchronized (map) {
                CommonTopicBasedPhysicalClusterMetadata.LCMPair prevRecord = (CommonTopicBasedPhysicalClusterMetadata.LCMPair)this.logicalClusterMap.get(clusterId);
                if (prevRecord == null || prevRecord.getSequenceId() < sequenceId) {
                    this.logicalClusterMap.put(clusterId, new CommonTopicBasedPhysicalClusterMetadata.LCMPair((CommonTopicBasedPhysicalClusterMetadata)this, sequenceId.longValue(), (LogicalClusterMetadata)lcm));
                    this.tenantLifecycleManager.updateTenantState(lcm);
                    KafkaLogicalClusterMetadata prevLcm = null;
                    if (prevRecord != null) {
                        prevLcm = (KafkaLogicalClusterMetadata)prevRecord.getLCM();
                    }
                    this.updateTenant(prevLcm, lcm);
                } else {
                    LOG.warn("Got asked to update a cluster {} which has a newer sequence id in map: {}", (Object)clusterId, (Object)prevRecord.getSequenceId());
                }
            }
        }
    }

    protected void ensureOpen() {
        if (!CommonTopicBasedPhysicalClusterMetadata.State.RUNNING.equals((Object)this.sslCertManagerState.get())) {
            throw new IllegalStateException("SslCertificateManager not started.");
        }
        if (!CommonTopicBasedPhysicalClusterMetadata.State.RUNNING.equals(this.logConsumerState.get())) {
            throw new IllegalStateException("KafkaBasedLog for the consumer topic not started.");
        }
    }

    private boolean addOrUpdate(LogicalClusterMetadata oldMeta, LogicalClusterMetadata newMeta) {
        boolean updateNeeded = !newMeta.equals(oldMeta);
        boolean expiredCluster = oldMeta == null && !newMeta.isActive();
        return updateNeeded && !expiredCluster;
    }
}

