/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.ZoneAlignment;
import io.confluent.kafka.multitenant.metrics.FetchResponseSensorCreator;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.metrics.AbstractSensorCreator;
import org.apache.kafka.server.metrics.ApiSensorBuilder;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public class FetchApiSensorBuilder
extends ApiSensorBuilder {
    static final String RESPONSE_BYTE_METRIC_NAME = "response-byte";
    private final String zoneAlignmentSensorName;
    private final ZoneAlignment zoneAlignment;

    public FetchApiSensorBuilder(Metrics metrics, MetricsBuilderContext context, ApiKeys apiKey, ZoneAlignment zoneAlignment) {
        super(metrics, context, apiKey);
        this.zoneAlignment = zoneAlignment;
        this.zoneAlignmentSensorName = String.format("%s-%s", zoneAlignment.name(), RESPONSE_BYTE_METRIC_NAME);
    }

    public ApiSensors build() {
        Map sensors = this.getOrCreateSuffixedSensors();
        return new ApiSensors((Sensor)sensors.get("request"), (Sensor)sensors.get("request-byte"), (Sensor)sensors.get(this.zoneAlignmentSensorName), (Sensor)sensors.get("response-time-ns"));
    }

    protected Map<String, ? extends AbstractSensorCreator> sensorCreators() {
        Map fetchRequestReponseSensorCreators = ApiSensorBuilder.requestResponseSensorCreatorsCopy();
        fetchRequestReponseSensorCreators.remove(RESPONSE_BYTE_METRIC_NAME);
        fetchRequestReponseSensorCreators.put(this.zoneAlignmentSensorName, new FetchResponseSensorCreator(RESPONSE_BYTE_METRIC_NAME, "response bytes", this.zoneAlignment));
        return fetchRequestReponseSensorCreators;
    }
}

