/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.FailedAuthSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.AbstractSensorBuilder;
import org.apache.kafka.server.metrics.AbstractSensorCreator;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public class IpFailedAuthenticationByIpSensorBuilder
extends AbstractSensorBuilder<TenantMetrics.IpMetricsContext, FailedAuthSensors> {
    static final String FAILED_AUTH_RATE = "failed-authentication-by-ip";
    private static final Map<String, AbstractSensorCreator> FAILED_AUTH_SENSOR_CREATORS = new HashMap<String, AbstractSensorCreator>();

    public IpFailedAuthenticationByIpSensorBuilder(Metrics metrics, InetAddress clientAddress) {
        super(metrics, (MetricsBuilderContext)new TenantMetrics.IpMetricsContext(clientAddress));
    }

    public FailedAuthSensors build() {
        Map sensors = this.getOrCreateSuffixedSensors();
        return new FailedAuthSensors((Sensor)sensors.get(FAILED_AUTH_RATE));
    }

    protected String sensorSuffix(String name, TenantMetrics.IpMetricsContext context) {
        return context.sensorSuffix();
    }

    protected Map<String, ? extends AbstractSensorCreator> sensorCreators() {
        return FAILED_AUTH_SENSOR_CREATORS;
    }

    protected <T> Sensor createSensor(Map<T, ? extends AbstractSensorCreator> sensorCreators, T sensorKey, String sensorName) {
        FailedAuthSensors.FailedAuthSensorCreator sensorCreator = (FailedAuthSensors.FailedAuthSensorCreator)sensorCreators.get(sensorKey);
        return sensorCreator.createSensor(this.metrics, sensorName, (TenantMetrics.IpMetricsContext)this.context);
    }

    static {
        FAILED_AUTH_SENSOR_CREATORS.put(FAILED_AUTH_RATE, new FailedAuthSensors.FailedAuthSensorCreator(FAILED_AUTH_RATE, "failed-authentications-by-ip"));
    }
}

