/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.serde;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.serde.EventsMetadataHeader;
import io.confluent.kafka.multitenant.serde.LogicalClusterMetadataRecord;
import io.confluent.protobuf.cloud.events.v1.EventsMetadata;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class LogicalClusterMetadataRecordDeserializer
implements Deserializer<LogicalClusterMetadataRecord> {
    public LogicalClusterMetadataRecord deserialize(String topic, byte[] data) {
        return this.deserialize(topic, null, data);
    }

    public LogicalClusterMetadataRecord deserialize(String topic, Headers headers, byte[] data) {
        try {
            Header eventsMetadataHeader;
            EventsMetadataHeader eventsMetadata = null;
            if (headers != null && (eventsMetadataHeader = headers.lastHeader("eventsmetadata")) != null) {
                eventsMetadata = EventsMetadataHeader.fromProtobuf(EventsMetadata.parseFrom((byte[])eventsMetadataHeader.value()));
            }
            return new LogicalClusterMetadataRecord(eventsMetadata, KafkaLogicalClusterMetadata.fromProtobuf(LogicalCluster.parseFrom((byte[])data)));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

