/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import io.confluent.security.auth.dataplane.JwtIssuerAuthCache;
import io.confluent.security.authentication.AuthenticationConfig;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticationConfig;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticator;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.config.YamlConfigReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public final class JwtAuthenticatorConfig
extends AbstractConfig {
    public static final String CONFIG_PREFIX = "authenticator.jwt.";
    public static final String JWT_AUTHENTICATOR_CONFIG_URL = JwtAuthenticatorConfig.prefix("config.url");
    public static final String JWT_AUTHENTICATOR_CONFIG_URL_DOC = "Location of the JWT authenticator config in the YAML format";
    private static final ConfigDef CONFIG = new ConfigDef().define(JWT_AUTHENTICATOR_CONFIG_URL, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Location of the JWT authenticator config in the YAML format");

    public static JwtAuthenticatorConfig newInstance(Map<String, ?> originals) {
        return new JwtAuthenticatorConfig(originals);
    }

    private JwtAuthenticatorConfig(Map<String, ?> originals) {
        super(CONFIG, originals);
    }

    private static Map<String, ?> stripPrefix(String prefix, Map<String, ?> originals) {
        return originals.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), Map.Entry::getValue));
    }

    public JwtAuthenticator generateConfig(Map<String, ?> configs) {
        AuthenticationConfig authConfig = null;
        try {
            if (this.getString(JWT_AUTHENTICATOR_CONFIG_URL).isEmpty()) {
                JavaPropsMapper mapper = new JavaPropsMapper();
                Map<String, String> stringProps = this.originalsWithPrefix(CONFIG_PREFIX).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
                authConfig = (AuthenticationConfig)mapper.readMapAs(stringProps, AuthenticationConfig.class);
            } else {
                FileInputStream targetStream;
                File file = new File(this.getString(JWT_AUTHENTICATOR_CONFIG_URL));
                try {
                    targetStream = new FileInputStream(file);
                }
                catch (FileNotFoundException e2) {
                    throw new IllegalArgumentException("Expected file in <config.url> " + this.getString(JWT_AUTHENTICATOR_CONFIG_URL) + " is missing");
                }
                YamlConfigReader configReader = new YamlConfigReader();
                authConfig = (AuthenticationConfig)configReader.load((InputStream)targetStream, AuthenticationConfig.class);
            }
            if (authConfig == null) {
                throw new IllegalArgumentException("AuthenticationConfig cannot be null pointer");
            }
            if (!(authConfig instanceof JwtAuthenticationConfig)) {
                throw new IllegalArgumentException(String.format("Loaded AuthenticationConfig is type %s but expect JwtAuthenticationConfig", authConfig.getClass()));
            }
            JwtAuthenticationConfig config = (JwtAuthenticationConfig)authConfig;
            for (JwtIssuer issuer : config.issuers()) {
                if (!(issuer instanceof JwtIssuerAuthCache)) continue;
                ((JwtIssuerAuthCache)issuer).configure(configs);
            }
            return (JwtAuthenticator)config.createAuthenticator();
        }
        catch (IOException e3) {
            throw new ConfigException("Failed to read authentication configuration", (Object)e3);
        }
    }

    private static String prefix(String prop) {
        return CONFIG_PREFIX + prop;
    }
}

