/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.multitenant.schema.TenantContext;
import io.confluent.kafka.server.plugins.policy.TopicPolicyConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.GaugeSuite;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.ConfluentPartitionsPerTopicListener;
import org.apache.kafka.server.interceptor.Monitorable;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTopicPolicy
implements org.apache.kafka.server.policy.CreateTopicPolicy,
ConfluentPartitionsPerTopicListener,
Monitorable,
Reconfigurable {
    private static final Logger log = LoggerFactory.getLogger(CreateTopicPolicy.class);
    private static final Set<String> RECONFIGURABLE_CONFIGS = Collections.unmodifiableSet(Utils.mkSet((Object[])new String[]{"confluent.plugins.topic.policy.replication.factor", "confluent.plugins.topic.policy.max.partitions.per.tenant", "confluent.multitenant.max.partitions.per.request", "confluent.plugins.topic.policy.max.partitions.per.cluster", "confluent.plugins.topic.policy.max.topics.per.cluster", "confluent.plugins.topic.policy.max.replicas.per.broker"}));
    private short requiredRepFactor;
    private int maxTopicsPerCluster;
    private int numClusterTopics;
    private int totalTenantPartitions;
    private int maxPartitionsPerTenant;
    private int maxPartitionsPerCluster;
    private int maxPartitionsPerRequest;
    private int maxReplicasPerBroker;
    private TopicPolicyConfig policyConfig;
    private Map<String, Integer> tenantToNumPartitions;
    private Map<Integer, Integer> brokerToNumReplicas;
    private final Map<String, Integer> pendingTenantPartitionsAddedOrDeleted = new HashMap<String, Integer>();
    private final Map<Integer, Integer> pendingBrokerToNumReplicasAddedOrDeleted = new HashMap<Integer, Integer>();
    private int pendingTopicsAddedOrDeleted = 0;
    private final Object metadataLock = new Object();
    private GaugeSuite<String, Integer> partitionsByTenantMetrics;
    private final Object metricsLock = new Object();

    public void configure(Map<String, ?> configs) {
        this.reconfigure(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMetrics(Metrics metrics) {
        Object object = this.metricsLock;
        synchronized (object) {
            this.partitionsByTenantMetrics = new GaugeSuite(log, "partitions", metrics, tenant -> metrics.metricName("partitions", "tenant-metrics", "The total number of partitions for this tenant.", Collections.singletonMap("tenant", tenant)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(CreateTopicPolicy.RequestMetadata reqMetadata) throws PolicyViolationException {
        int maxNumReplicasPerBroker;
        int curLargestBrokerReplicas;
        int curNumClusterTopics;
        int maxNumClusterTopics;
        short reqReplicationFactor;
        int maxRequestPartitions;
        int curNumClusterPartitions;
        int maxNumClusterPartitions;
        int curNumTenantPartitions;
        int maxNumTenantPartitions;
        TopicPolicyConfig policy;
        String tenant = TenantHelpers.extractTenantPrefix((String)reqMetadata.topic(), (boolean)false);
        if (tenant == null || Topic.isInternal((String)reqMetadata.topic())) {
            return;
        }
        try {
            Topic.validate((String)TenantContext.removePrefix(reqMetadata.topic()));
        }
        catch (InvalidTopicException e2) {
            throw new PolicyViolationException("Invalid topic name specified.");
        }
        Integer numPartitionsPassed = reqMetadata.numPartitions();
        if (reqMetadata.replicasAssignments() != null && !reqMetadata.replicasAssignments().isEmpty()) {
            numPartitionsPassed = reqMetadata.replicasAssignments().size();
        }
        if (numPartitionsPassed == null) {
            throw new PolicyViolationException("Must specify number of partitions.");
        }
        HashMap<Integer, Integer> brokerToNumReplicasPassed = reqMetadata.replicasAssignments() == null ? new HashMap<Integer, Integer>() : CreateTopicPolicy.frequencies(reqMetadata.replicasAssignments().values(), e -> 1);
        Object object = this.metadataLock;
        synchronized (object) {
            policy = this.policyConfig;
            maxNumTenantPartitions = this.maxPartitionsPerTenant;
            curNumTenantPartitions = this.numPartitions(tenant);
            maxNumClusterPartitions = this.maxPartitionsPerCluster;
            curNumClusterPartitions = this.numClusterPartitions();
            maxRequestPartitions = this.maxPartitionsPerRequest;
            reqReplicationFactor = this.requiredRepFactor;
            maxNumClusterTopics = this.maxTopicsPerCluster;
            curNumClusterTopics = this.numClusterTopics + this.pendingTopicsAddedOrDeleted;
            curLargestBrokerReplicas = this.largestReplicasPerBrokerWithPendingReplicas(brokerToNumReplicasPassed);
            maxNumReplicasPerBroker = this.maxReplicasPerBroker;
        }
        if (numPartitionsPassed > maxRequestPartitions) {
            throw new PolicyViolationException(String.format("You may not create more than %d new partitions in a single request.", maxRequestPartitions));
        }
        Short repFactorPassed = reqMetadata.replicationFactor();
        if (reqMetadata.replicasAssignments() != null && !reqMetadata.replicasAssignments().isEmpty()) {
            repFactorPassed = (short)((List)reqMetadata.replicasAssignments().values().iterator().next()).size();
        }
        if (repFactorPassed != null && repFactorPassed != reqReplicationFactor) {
            throw new PolicyViolationException("Topic replication factor must be " + reqReplicationFactor);
        }
        policy.validateTopicConfigs(reqMetadata.configs());
        CreateTopicPolicy.ensureValidTenantPartitionCount(tenant, maxNumTenantPartitions, curNumTenantPartitions, numPartitionsPassed);
        CreateTopicPolicy.ensureValidClusterPartitionCount(maxNumClusterPartitions, curNumClusterPartitions, numPartitionsPassed);
        CreateTopicPolicy.ensureValidTopicCount(tenant, maxNumClusterTopics, curNumClusterTopics);
        CreateTopicPolicy.ensureValidReplicasPerBroker(maxNumReplicasPerBroker, curLargestBrokerReplicas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.metricsLock;
        synchronized (object) {
            Utils.closeQuietly(this.partitionsByTenantMetrics, (String)"partitionsByTenantMetrics");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numPartitions(String tenant) {
        Object object = this.metadataLock;
        synchronized (object) {
            if (this.tenantToNumPartitions == null) {
                log.info("Policy has not been initialized with topic metadata, returning NOT_CONTROLLER");
                throw new NotControllerException("Initialization of topic metadata has not been completed");
            }
            int numTenantPartitions = this.tenantToNumPartitions.getOrDefault(tenant, 0) + this.pendingTenantPartitionsAddedOrDeleted.getOrDefault(tenant, 0);
            log.debug("Found {} partition(s) for tenant {}.", (Object)numTenantPartitions, (Object)tenant);
            return numTenantPartitions;
        }
    }

    int numClusterPartitions() {
        if (this.tenantToNumPartitions == null) {
            log.info("Policy has not been initialized with topic metadata, returning NOT_CONTROLLER");
            throw new NotControllerException("Initialization of topic metadata has not been completed");
        }
        int numPartitions = this.totalTenantPartitions + this.pendingTenantPartitionsAddedOrDeleted.values().stream().mapToInt(Integer::intValue).sum();
        log.debug("Found {} partition(s) for cluster.", (Object)numPartitions);
        return numPartitions;
    }

    int largestReplicasPerBrokerWithPendingReplicas(Map<Integer, Integer> brokerToNumReplicasPassed) {
        if (this.brokerToNumReplicas == null) {
            log.info("Policy has not been initialized with topic metadata, returning NOT_CONTROLLER");
            throw new NotControllerException("Initialization of topic metadata has not been completed");
        }
        CreateTopicPolicy.incrementMap(brokerToNumReplicasPassed, this.brokerToNumReplicas);
        CreateTopicPolicy.incrementMap(brokerToNumReplicasPassed, this.pendingBrokerToNumReplicasAddedOrDeleted);
        return brokerToNumReplicasPassed.values().stream().max(Integer::compare).orElse(0);
    }

    static void ensureValidTenantPartitionCount(String tenant, int max, int cur, int added) throws PolicyViolationException {
        if (added > max) {
            throw new PolicyViolationException(String.format("You may not create more than the maximum number of partitions (%d).", max));
        }
        long total = cur;
        if ((total += (long)added) > (long)max) {
            throw new PolicyViolationException(String.format("You may not create more than %d new partitions. Adding the requested number of partitions will exceed %d total partitions. Currently, there are %d total topic partitions", max - cur, max, cur));
        }
        log.debug("Validated adding {} partitions to {} current partitions (total={}, max={}) for {}", new Object[]{added, cur, total, max, tenant});
    }

    static void ensureValidClusterPartitionCount(int maxPartitionsPerCluster, int clusterPartitions, int added) throws PolicyViolationException {
        if (clusterPartitions >= maxPartitionsPerCluster) {
            throw new PolicyViolationException(String.format("The cluster has reached the maximum number of partitions.", new Object[0]));
        }
        long total = clusterPartitions;
        if ((total += (long)added) > (long)maxPartitionsPerCluster) {
            throw new PolicyViolationException(String.format("You may not create more than %d new partitions. Adding the requested number of partitions will exceed cluster limits.", maxPartitionsPerCluster - clusterPartitions));
        }
        log.debug("Validated adding {} partitions to {} current partitions (total={}, max={}) for pkc", new Object[]{added, clusterPartitions, total, maxPartitionsPerCluster});
    }

    static void ensureValidTopicCount(String tenant, int maxTopicsPerCluster, int clusterTopics) {
        if (clusterTopics >= maxTopicsPerCluster) {
            throw new PolicyViolationException(String.format("The cluster has reached the maximum number of topics.", new Object[0]));
        }
        log.debug("Validated adding a new topic (current={}, max={}), requested by {}", new Object[]{clusterTopics, maxTopicsPerCluster, tenant});
    }

    static void ensureValidReplicasPerBroker(int maxReplicasPerBroker, int largestReplicasPerBroker) {
        log.debug("Validated adding replicas (current={}, max={})", (Object)largestReplicasPerBroker, (Object)maxReplicasPerBroker);
        if (largestReplicasPerBroker > maxReplicasPerBroker) {
            throw new PolicyViolationException("The cluster has reached the maximum number of replicas per broker.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullUpdate(Iterator<Map.Entry<String, Integer>> iterator, Map<Integer, Integer> brokersToNumReplicas) {
        Object tenant;
        Object topicName;
        HashMap<String, Integer> newTenantToNumPartitions = new HashMap<String, Integer>();
        HashSet<Object> newTopics = new HashSet<Object>();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry2 = iterator.next();
            topicName = entry2.getKey();
            tenant = TenantHelpers.extractTenantPrefix((String)topicName, (boolean)false);
            if (tenant == null) continue;
            newTenantToNumPartitions.put((String)tenant, newTenantToNumPartitions.getOrDefault(tenant, 0) + entry2.getValue());
            newTopics.add(topicName);
        }
        HashMap<String, Integer> changedTenantToNumPartitions = new HashMap<String, Integer>();
        topicName = this.metricsLock;
        synchronized (topicName) {
            tenant = this.metadataLock;
            synchronized (tenant) {
                this.numClusterTopics = newTopics.size();
                Map<Object, Object> oldTenantToNumPartitions = this.tenantToNumPartitions == null ? Collections.emptyMap() : this.tenantToNumPartitions;
                this.tenantToNumPartitions = newTenantToNumPartitions;
                int newTotalTenantPartitions = 0;
                for (Map.Entry<String, Integer> entry2 : this.tenantToNumPartitions.entrySet()) {
                    String tenant2 = entry2.getKey();
                    Integer newValue = entry2.getValue();
                    newTotalTenantPartitions += newValue.intValue();
                    Integer prevValue = (Integer)oldTenantToNumPartitions.remove(tenant2);
                    if (newValue.equals(prevValue)) continue;
                    changedTenantToNumPartitions.put(tenant2, newValue);
                }
                for (String string : oldTenantToNumPartitions.keySet()) {
                    changedTenantToNumPartitions.put(string, 0);
                }
                this.brokerToNumReplicas = new HashMap<Integer, Integer>(brokersToNumReplicas);
                this.totalTenantPartitions = newTotalTenantPartitions;
            }
            boolean removedSome = false;
            for (Map.Entry entry4 : changedTenantToNumPartitions.entrySet()) {
                if ((Integer)entry4.getValue() == 0) {
                    this.partitionsByTenantMetrics.remove(entry4.getKey());
                    removedSome = true;
                    continue;
                }
                this.partitionsByTenantMetrics.update(entry4.getKey(), entry4.getValue());
            }
            if (removedSome) {
                this.partitionsByTenantMetrics.flush();
            }
        }
        if (log.isInfoEnabled()) {
            StringBuilder brokerReplicaCountsStringBuilder = new StringBuilder();
            brokersToNumReplicas.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> brokerReplicaCountsStringBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append(' '));
            log.info("Fully updated with cluster currently having {} number of cluster partitions, {} number of cluster topics,brokers each having following number of replicas {}", new Object[]{this.totalTenantPartitions, this.numClusterTopics, brokerReplicaCountsStringBuilder});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialUpdate(String topicName, int numPartitionsAddedOrDeleted, int numTopicsAddedOrDeleted, Map<Integer, List<Integer>> partitionIdToReplicasAdded, Map<Integer, List<Integer>> partitionIdToReplicasDeleted, boolean pending) {
        String tenant = TenantHelpers.extractTenantPrefix((String)topicName, (boolean)false);
        if (tenant == null) {
            return;
        }
        Map<Integer, Integer> brokerToNumReplicasDelta = CreateTopicPolicy.brokerToNumReplicasDelta(partitionIdToReplicasAdded, partitionIdToReplicasDeleted);
        if (pending) {
            Object object = this.metadataLock;
            synchronized (object) {
                this.pendingTenantPartitionsAddedOrDeleted.put(tenant, this.pendingTenantPartitionsAddedOrDeleted.getOrDefault(tenant, 0) + numPartitionsAddedOrDeleted);
                this.pendingTopicsAddedOrDeleted += numTopicsAddedOrDeleted;
                CreateTopicPolicy.incrementMap(this.pendingBrokerToNumReplicasAddedOrDeleted, brokerToNumReplicasDelta);
            }
            return;
        }
        Object object = this.metricsLock;
        synchronized (object) {
            Object object2 = this.metadataLock;
            synchronized (object2) {
                int numTenantPartitions = this.tenantToNumPartitions.getOrDefault(tenant, 0);
                int newNumTenantPartitions = numTenantPartitions + numPartitionsAddedOrDeleted;
                if (newNumTenantPartitions == 0) {
                    this.tenantToNumPartitions.remove(tenant);
                    this.partitionsByTenantMetrics.remove((Object)tenant);
                    this.partitionsByTenantMetrics.flush();
                } else {
                    this.tenantToNumPartitions.put(tenant, newNumTenantPartitions);
                    this.partitionsByTenantMetrics.update((Object)tenant, (Object)newNumTenantPartitions);
                }
                this.numClusterTopics += numTopicsAddedOrDeleted;
                this.totalTenantPartitions += numPartitionsAddedOrDeleted;
                CreateTopicPolicy.incrementMap(this.brokerToNumReplicas, brokerToNumReplicasDelta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPending() {
        Object object = this.metadataLock;
        synchronized (object) {
            this.pendingTenantPartitionsAddedOrDeleted.clear();
            this.pendingTopicsAddedOrDeleted = 0;
            this.pendingBrokerToNumReplicasAddedOrDeleted.clear();
        }
    }

    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        new TopicPolicyConfig(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(Map<String, ?> configs) {
        TopicPolicyConfig newPolicyConfig = new TopicPolicyConfig(configs);
        Object object = this.metadataLock;
        synchronized (object) {
            this.policyConfig = newPolicyConfig;
            this.requiredRepFactor = newPolicyConfig.getShort("confluent.plugins.topic.policy.replication.factor");
            this.maxPartitionsPerTenant = newPolicyConfig.getInt("confluent.plugins.topic.policy.max.partitions.per.tenant");
            this.maxPartitionsPerRequest = newPolicyConfig.getInt("confluent.multitenant.max.partitions.per.request");
            this.maxPartitionsPerCluster = newPolicyConfig.getInt("confluent.plugins.topic.policy.max.partitions.per.cluster");
            this.maxTopicsPerCluster = newPolicyConfig.getInt("confluent.plugins.topic.policy.max.topics.per.cluster");
            this.maxReplicasPerBroker = newPolicyConfig.getInt("confluent.plugins.topic.policy.max.replicas.per.broker");
        }
        log.info("Configured policy with {} max partitions per tenant, {} max partitions per cluster, {} max partitions per topic/partition creation, a required replication factor of {}, {} max topics per cluster, and {} max replicas per broker.", new Object[]{this.maxPartitionsPerTenant, this.maxPartitionsPerCluster, this.maxPartitionsPerRequest, this.requiredRepFactor, this.maxTopicsPerCluster, this.maxReplicasPerBroker});
    }

    private static Map<Integer, Integer> brokerToNumReplicasDelta(Map<Integer, List<Integer>> partitionIdToReplicasAdded, Map<Integer, List<Integer>> partitionIdToReplicasDeleted) {
        Map<Integer, Integer> brokerToNumReplicasDelta = CreateTopicPolicy.frequencies(partitionIdToReplicasAdded.values(), e -> 1);
        CreateTopicPolicy.incrementMap(brokerToNumReplicasDelta, CreateTopicPolicy.frequencies(partitionIdToReplicasDeleted.values(), e -> -1));
        return brokerToNumReplicasDelta;
    }

    private static void incrementMap(Map<Integer, Integer> destination, Map<Integer, Integer> updateFrom) {
        for (Map.Entry<Integer, Integer> brokerToNumReplicasEntry : updateFrom.entrySet()) {
            Integer brokerId = brokerToNumReplicasEntry.getKey();
            Integer numReplicasDelta = brokerToNumReplicasEntry.getValue();
            destination.put(brokerId, destination.getOrDefault(brokerId, 0) + numReplicasDelta);
        }
    }

    public static <E> Map<E, Integer> frequencies(Collection<List<E>> items, Function<E, Integer> mapper) {
        return items.stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, mapper, Integer::sum)));
    }
}

