/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.ssl;

import io.confluent.kafka.server.plugins.ssl.ConfluentTrustManager;
import io.confluent.kafka.server.plugins.ssl.ConfluentTrustProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedTrustManager;

public class ConfluentTrustManagerFactory
extends TrustManagerFactorySpi {
    private final TrustManagerFactory defaultFactory;
    private Map<String, ?> configs = Collections.emptyMap();

    public ConfluentTrustManagerFactory() {
        try {
            this.defaultFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.buildConfigs();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Default trust manager factory could not be loaded", e);
        }
    }

    private void buildConfigs() {
        Map configs;
        this.configs = configs = (Map)Security.getProvider(ConfluentTrustProvider.class.getSimpleName()).get("ConfluentTrustProvider.config");
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        this.defaultFactory.init(keyStore);
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.defaultFactory.init(managerFactoryParameters);
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        for (TrustManager trustManager : this.defaultFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
            return new TrustManager[]{new ConfluentTrustManager(this.configs, (X509ExtendedTrustManager)trustManager)};
        }
        throw new IllegalStateException("Could not load default trust manager");
    }
}

