/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Request;

class ConnectConstraintSecurityHandler
extends ConstraintSecurityHandler {
    private static final Set<RequestMatcher> INTERNAL_REQUEST_MATCHERS = new HashSet<RequestMatcher>(Arrays.asList(new RequestMatcher("POST", "/?connectors/([^/]+)/tasks/?"), new RequestMatcher("PUT", "/?connectors/[^/]+/fence/?")));

    ConnectConstraintSecurityHandler() {
    }

    private static boolean isInternalRequest(HttpServletRequest request) {
        return INTERNAL_REQUEST_MATCHERS.stream().anyMatch(m -> m.test(request));
    }

    public void handle(String pathInContext, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (ConnectConstraintSecurityHandler.isInternalRequest(request)) {
            this.getHandler().handle(pathInContext, baseRequest, request, response);
        } else {
            super.handle(pathInContext, baseRequest, request, response);
        }
    }

    private static class RequestMatcher
    implements Predicate<HttpServletRequest> {
        private final String method;
        private final Pattern path;

        public RequestMatcher(String method, String path) {
            this.method = method;
            this.path = Pattern.compile(path);
        }

        @Override
        public boolean test(HttpServletRequest request) {
            return request.getMethod().equalsIgnoreCase(this.method) && this.path.matcher(request.getPathInfo()).matches();
        }
    }
}

