/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import java.util.Arrays;
import java.util.stream.Stream;

public enum SqlBaseType {
    BOOLEAN,
    INTEGER,
    BIGINT,
    DECIMAL,
    DOUBLE,
    STRING,
    ARRAY,
    MAP,
    STRUCT,
    TIME,
    DATE,
    TIMESTAMP,
    BYTES;


    public boolean isNumber() {
        return this == INTEGER || this == BIGINT || this == DECIMAL || this == DOUBLE;
    }

    public boolean isTime() {
        return this == TIME || this == DATE || this == TIMESTAMP;
    }

    public boolean canImplicitlyCast(SqlBaseType to) {
        if (to == null) {
            return false;
        }
        boolean canCastNumber = this.isNumber() && to.isNumber() && this.ordinal() <= to.ordinal();
        boolean canCastTime = this.equals((Object)STRING) && to.isTime();
        boolean canCastBytes = this.equals((Object)STRING) && to == BYTES;
        return this.equals((Object)to) || canCastNumber || canCastTime || canCastBytes;
    }

    public static Stream<SqlBaseType> numbers() {
        return Arrays.stream(SqlBaseType.values()).filter(SqlBaseType::isNumber);
    }
}

