/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.parallel;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.BiFunction;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.parallel.ParallelFlowable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ParallelReduceFull<T>
extends Flowable<T> {
    final ParallelFlowable<? extends T> source;
    final BiFunction<T, T, T> reducer;

    public ParallelReduceFull(ParallelFlowable<? extends T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        ParallelReduceFullMainSubscriber<? super T> parent = new ParallelReduceFullMainSubscriber<T>(s, this.source.parallelism(), this.reducer);
        s.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class SlotPair<T>
    extends AtomicInteger {
        private static final long serialVersionUID = 473971317683868662L;
        T first;
        T second;
        final AtomicInteger releaseIndex = new AtomicInteger();

        SlotPair() {
        }

        int tryAcquireSlot() {
            int acquired;
            do {
                if ((acquired = this.get()) < 2) continue;
                return -1;
            } while (!this.compareAndSet(acquired, acquired + 1));
            return acquired;
        }

        boolean releaseSlot() {
            return this.releaseIndex.incrementAndGet() == 2;
        }
    }

    static final class ParallelReduceFullInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7954444275102466525L;
        final ParallelReduceFullMainSubscriber<T> parent;
        final BiFunction<T, T, T> reducer;
        T value;
        boolean done;

        ParallelReduceFullInnerSubscriber(ParallelReduceFullMainSubscriber<T> parent, BiFunction<T, T, T> reducer) {
            this.parent = parent;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.setOnce(this, s, Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                T v = this.value;
                if (v == null) {
                    this.value = t;
                } else {
                    try {
                        v = ObjectHelper.requireNonNull(this.reducer.apply(v, t), "The reducer returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        ((Subscription)this.get()).cancel();
                        this.onError(ex);
                        return;
                    }
                    this.value = v;
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.parent.innerComplete(this.value);
            }
        }

        void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class ParallelReduceFullMainSubscriber<T>
    extends DeferredScalarSubscription<T> {
        private static final long serialVersionUID = -5370107872170712765L;
        final ParallelReduceFullInnerSubscriber<T>[] subscribers;
        final BiFunction<T, T, T> reducer;
        final AtomicReference<SlotPair<T>> current = new AtomicReference();
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicReference<Throwable> error = new AtomicReference();

        ParallelReduceFullMainSubscriber(Subscriber<? super T> subscriber, int n, BiFunction<T, T, T> reducer) {
            super(subscriber);
            ParallelReduceFullInnerSubscriber[] a = new ParallelReduceFullInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new ParallelReduceFullInnerSubscriber<T>(this, reducer);
            }
            this.subscribers = a;
            this.reducer = reducer;
            this.remaining.lazySet(n);
        }

        SlotPair<T> addValue(T value) {
            int c;
            SlotPair<T> curr;
            while (true) {
                if ((curr = this.current.get()) == null && !this.current.compareAndSet(null, curr = new SlotPair())) {
                    continue;
                }
                c = curr.tryAcquireSlot();
                if (c >= 0) break;
                this.current.compareAndSet(curr, null);
            }
            if (c == 0) {
                curr.first = value;
            } else {
                curr.second = value;
            }
            if (curr.releaseSlot()) {
                this.current.compareAndSet(curr, null);
                return curr;
            }
            return null;
        }

        @Override
        public void cancel() {
            for (ParallelReduceFullInnerSubscriber<T> inner : this.subscribers) {
                inner.cancel();
            }
        }

        void innerError(Throwable ex) {
            if (this.error.compareAndSet(null, ex)) {
                this.cancel();
                this.downstream.onError(ex);
            } else if (ex != this.error.get()) {
                RxJavaPlugins.onError(ex);
            }
        }

        void innerComplete(T value) {
            SlotPair<T> sp;
            if (value != null) {
                while ((sp = this.addValue(value)) != null) {
                    try {
                        value = ObjectHelper.requireNonNull(this.reducer.apply(sp.first, sp.second), "The reducer returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.innerError(ex);
                        return;
                    }
                }
            }
            if (this.remaining.decrementAndGet() == 0) {
                sp = this.current.get();
                this.current.lazySet(null);
                if (sp != null) {
                    this.complete(sp.first);
                } else {
                    this.downstream.onComplete();
                }
            }
        }
    }
}

