/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.secretregistry.rbac;

import io.confluent.connect.secretregistry.rbac.ActionBuilder;
import io.confluent.connect.secretregistry.rbac.SecretRegistryOperations;
import io.confluent.connect.secretregistry.rbac.SimpleSecretRegistryActionBuilder;
import io.confluent.kafka.secretregistry.client.rest.entities.requests.RegisterSecretRequest;
import io.confluent.kafka.secretregistry.rest.resources.PathKeyResource;
import io.confluent.kafka.secretregistry.rest.resources.PathKeyVersionResource;
import io.confluent.kafka.secretregistry.rest.resources.PathResource;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretRegistryActions {
    private static final Logger log = LoggerFactory.getLogger(SecretRegistryActions.class);
    private static final ActionBuilder EMPTY_ACTION_BUILDER = requestContext -> Collections.emptyList();
    public static final ResourceType SECRET_RESOURCE = new ResourceType("Secret");
    private final Map<Method, ActionBuilder> actionBuilders;

    public static SecretRegistryActions build(Scope scope, ConnectClusterState clusterState) {
        HashMap<Method, ActionBuilder> actionBuilders = new HashMap<Method, ActionBuilder>();
        try {
            actionBuilders.put(PathKeyVersionResource.class.getMethod("getSecret", SecurityContext.class, String.class, String.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.READ));
            actionBuilders.put(PathKeyVersionResource.class.getMethod("getSecretOnly", SecurityContext.class, String.class, String.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.READ));
            actionBuilders.put(PathKeyVersionResource.class.getMethod("list", SecurityContext.class, String.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.READ));
            actionBuilders.put(PathKeyVersionResource.class.getMethod("register", AsyncResponse.class, SecurityContext.class, HttpHeaders.class, String.class, String.class, RegisterSecretRequest.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.CREATE));
            actionBuilders.put(PathKeyVersionResource.class.getMethod("deleteSecretVersion", AsyncResponse.class, SecurityContext.class, HttpHeaders.class, String.class, String.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.DELETE));
            actionBuilders.put(PathKeyResource.class.getMethod("getAllVersions", SecurityContext.class, String.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.READ));
            actionBuilders.put(PathKeyResource.class.getMethod("list", SecurityContext.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.READ));
            actionBuilders.put(PathKeyResource.class.getMethod("deleteKey", AsyncResponse.class, SecurityContext.class, HttpHeaders.class, String.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.DELETE));
            actionBuilders.put(PathResource.class.getMethod("list", SecurityContext.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.READ));
            actionBuilders.put(PathResource.class.getMethod("allLatest", SecurityContext.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.READ));
            actionBuilders.put(PathResource.class.getMethod("deletePath", AsyncResponse.class, SecurityContext.class, HttpHeaders.class, String.class), new SimpleSecretRegistryActionBuilder(scope, SecretRegistryOperations.DELETE));
        }
        catch (NoSuchMethodException e) {
            throw new ConnectException("Failed to initialize Secret Registry RBAC extension", (Throwable)e);
        }
        return new SecretRegistryActions(actionBuilders);
    }

    SecretRegistryActions(Map<Method, ActionBuilder> actionBuilders) {
        this.actionBuilders = actionBuilders;
    }

    public List<Action> actions(Method resourceMethod, ContainerRequestContext requestContext) throws IOException {
        return this.actionBuilders.getOrDefault(resourceMethod, EMPTY_ACTION_BUILDER).computeActions(requestContext);
    }
}

