/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import org.apache.kafka.clients.admin.ConfigEntry;

public enum ConfigSource {
    DYNAMIC_CLUSTER_LINK_CONFIG,
    DYNAMIC_TOPIC_CONFIG,
    DYNAMIC_BROKER_LOGGER_CONFIG,
    DYNAMIC_BROKER_CONFIG,
    DYNAMIC_DEFAULT_BROKER_CONFIG,
    STATIC_BROKER_CONFIG,
    DEFAULT_CONFIG,
    UNKNOWN;


    public static ConfigSource fromAdminConfigSource(ConfigEntry.ConfigSource source) {
        try {
            return ConfigSource.valueOf(source.name());
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public static ConfigEntry.ConfigSource toAdminConfigSource(ConfigSource source) {
        try {
            return ConfigEntry.ConfigSource.valueOf((String)source.name());
        }
        catch (IllegalArgumentException e) {
            return ConfigEntry.ConfigSource.UNKNOWN;
        }
    }
}

