/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.ConsumerAssignment;
import io.confluent.kafkarest.entities.v3.AutoValue_ConsumerAssignmentData;
import io.confluent.kafkarest.entities.v3.Resource;

@AutoValue
public abstract class ConsumerAssignmentData
extends Resource {
    ConsumerAssignmentData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="consumer_group_id")
    public abstract String getConsumerGroupId();

    @JsonProperty(value="consumer_id")
    public abstract String getConsumerId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="partition_id")
    public abstract int getPartitionId();

    @JsonProperty(value="partition")
    public abstract Resource.Relationship getPartition();

    @JsonProperty(value="lag")
    public abstract Resource.Relationship getLag();

    public static Builder builder() {
        return new AutoValue_ConsumerAssignmentData.Builder().setKind("KafkaConsumerAssignment");
    }

    public static Builder fromConsumerAssignment(ConsumerAssignment assignment) {
        return ConsumerAssignmentData.builder().setClusterId(assignment.getClusterId()).setConsumerGroupId(assignment.getConsumerGroupId()).setConsumerId(assignment.getConsumerId()).setTopicName(assignment.getTopicName()).setPartitionId(assignment.getPartitionId());
    }

    @JsonCreator
    static ConsumerAssignmentData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="consumer_group_id") String consumerGroupId, @JsonProperty(value="consumer_id") String consumerId, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partition_id") int partitionId, @JsonProperty(value="partition") Resource.Relationship partition, @JsonProperty(value="lag") Resource.Relationship lag) {
        return ((Builder)((Builder)ConsumerAssignmentData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setConsumerGroupId(consumerGroupId).setConsumerId(consumerId).setTopicName(topicName).setPartitionId(partitionId).setPartition(partition).setLag(lag).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setConsumerId(String var1);

        public abstract Builder setTopicName(String var1);

        public abstract Builder setPartitionId(int var1);

        public abstract Builder setPartition(Resource.Relationship var1);

        public abstract Builder setLag(Resource.Relationship var1);

        public abstract ConsumerAssignmentData build();
    }
}

