/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.ratelimit;

import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.ratelimit.FixedCostRateLimitFeature;
import io.confluent.kafkarest.ratelimit.NullRequestRateLimiter;
import io.confluent.kafkarest.ratelimit.RateLimitModule;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import javax.inject.Inject;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public final class RateLimitFeature
implements Feature {
    private final boolean rateLimitEnabled;

    @Inject
    RateLimitFeature(@ConfigModule.RateLimitEnabledConfig Boolean rateLimitEnabled) {
        this.rateLimitEnabled = rateLimitEnabled;
    }

    public boolean configure(FeatureContext context) {
        if (this.rateLimitEnabled) {
            context.register(RateLimitModule.class);
            context.register(FixedCostRateLimitFeature.class);
            return true;
        }
        context.register(NullRateLimitModule.class);
        return false;
    }

    private static final class NullRateLimitModule
    extends AbstractBinder {
        private NullRateLimitModule() {
        }

        protected void configure() {
            this.bind(NullRequestRateLimiter.class).to(RequestRateLimiter.class);
        }
    }
}

